/*******************************************************************************
 * Copyright (c) 2019, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.ProxyVariableSupport;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.Variable;

class DocumentProxyChildVariable extends ProxyChildVariable implements ProxyVariableSupport {

	public DocumentProxyChildVariable(Variable base, Variable parent, Variable other, String name) {
		super(base, parent, other, name);
	}

	@Override
	public Variable create(Variable base, Variable parent, Variable other, String name) {
		return new DocumentProxyChildVariable(base, parent, other, name);
	}

	public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {

		if(CONTEXT_END.equals(name)) {
			if(other instanceof ProxyChildVariable) {
				// The context is also a proxy - let it do the job
				return super.getPossibleChild(graph, name);
			} else {
				return ProxyVariables.tryToOwnRenamed(graph, this, base, CONTEXT_END);
			}
		}

		return super.getPossibleChild(graph, name);

	}

	@Override
	public Variable attachTo(ReadGraph graph, Variable parent) {
		return attachToRenamed(graph, parent, name);
	}

	@Override
	public Variable attachToRenamed(ReadGraph graph, Variable parent, String name) {
		if(this.parent.equals(base))
			return new DocumentProxyChildVariable(parent, parent, other, name);
		else
			return new DocumentProxyChildVariable(base, parent, other, name);
	}

}