/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.RowContentProvider;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableOfContents;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.templates.IndexQueryReport;
import org.simantics.document.linking.report.templates.Messages;
import org.simantics.document.linking.report.templates.ResourceNameComparator;
import org.simantics.document.linking.report.templates.SourceParentDiagramComparator;
import org.simantics.document.linking.report.templates.SourceParentHierarchyWithPropComparator;
import org.simantics.document.linking.utils.SourceLinkUtil;

public class CompleteStructureWriter
extends IndexQueryReport {
    ReadGraph graph;
    Resource model;
    Map<Object, Object> context;
    DocumentLink sl;
    DocumentResource doc;
    ResourceNameComparator parentComparator;
    Comparator<Resource> hierarchyComparator;

    @Override
    public String getName() {
        return "Complete Structure";
    }

    @Override
    public void sort(List<Resource> list) throws DatabaseException {
        Collections.sort(list, this.parentComparator);
    }

    @Override
    public void start(ReadGraph graph, Resource model, Document writer, Map<Object, Object> context) throws Exception {
        super.start(graph, model, writer, context);
        this.context = context;
        DocumentTitlePage titlePage = writer.newElement(DocumentTitlePage.class, new String[0]);
        titlePage.writeTitle(graph, context);
        writer.newElement(TableOfContents.class, new String[0]);
        Table table = writer.newElement(Table.class, "toc");
        table.addColumn("Name", 0.2);
        table.addColumn("Attribute", 0.2);
        table.addColumn("Value", 0.15);
        table.addColumn("Document", 0.2);
        table.addColumn("Comment", 0.25);
        this.graph = graph;
        this.sl = DocumentLink.getInstance((ReadGraph)graph);
        this.doc = DocumentResource.getInstance((ReadGraph)graph);
        this.model = model;
        this.parentComparator = new SourceParentHierarchyWithPropComparator(graph, model);
        this.hierarchyComparator = new SourceParentDiagramComparator(graph, model);
        this.clearProviders();
        this.addLineProvider(new HierarchyProvider());
        this.addCellProvider(new LinkCellProvider());
    }

    private class HierarchyProvider
    implements RowContentProvider<Resource> {
        private HierarchyProvider() {
        }

        @Override
        public void setText(Document writer, Resource previous, Resource current, Resource next, TextItem[] row) throws Exception {
            boolean writeHierarchy = false;
            if (previous == null) {
                writeHierarchy = true;
            } else if (CompleteStructureWriter.this.hierarchyComparator.compare(previous, current) != 0) {
                writeHierarchy = true;
            }
            if (writeHierarchy) {
                Resource obj = CompleteStructureWriter.this.graph.getPossibleObject(current, CompleteStructureWriter.this.sl.hasSource_Inverse);
                Table table = writer.getCurrentElement(Table.class);
                if (writer.getCurrentLine() > 2) {
                    writer.nextPage();
                    table = writer.nextElement(Table.class, "toc");
                }
                if (obj != null) {
                    Object text = "";
                    List<Resource> path = SourceLinkUtil.getDiagramPath(CompleteStructureWriter.this.graph, CompleteStructureWriter.this.model, obj);
                    if (path == null) {
                        path = CompleteStructureWriter.this.parentComparator.getPath(obj);
                        i = 0;
                        while (i < path.size() - 1) {
                            Resource r = path.get(i);
                            text = (String)text + CompleteStructureWriter.this.parentComparator.getText(r);
                            if (i < path.size() - 2) {
                                text = (String)text + "/";
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < path.size()) {
                            Resource r = path.get(i);
                            text = (String)text + CompleteStructureWriter.this.parentComparator.getText(r);
                            if (i < path.size() - 1) {
                                text = (String)text + "/";
                            }
                            ++i;
                        }
                    }
                    table.setTitle((String)text);
                    TableOfContents toc = writer.getCurrentElement(TableOfContents.class);
                    toc.addTocElement((String)text, table);
                } else {
                    table.setTitle("Hierarchy missing");
                }
            }
        }
    }

    private class LinkCellProvider
    implements RowContentProvider<Resource> {
        private LinkCellProvider() {
        }

        @Override
        public void setText(Document writer, Resource previous, Resource source, Resource next, TextItem[] text) throws Exception {
            Resource document;
            Resource holder = CompleteStructureWriter.this.graph.getSingleObject(source, CompleteStructureWriter.this.sl.hasSource_Inverse);
            String holderName = NameUtils.getSafeLabel((ReadGraph)CompleteStructureWriter.this.graph, (Resource)holder);
            if (holderName.length() == 0) {
                holderName = NameUtils.getSafeName((ReadGraph)CompleteStructureWriter.this.graph, (Resource)holder);
            }
            if (previous == null || !CompleteStructureWriter.this.graph.getSingleObject(previous, CompleteStructureWriter.this.sl.hasSource_Inverse).equals(CompleteStructureWriter.this.graph.getSingleObject(source, CompleteStructureWriter.this.sl.hasSource_Inverse))) {
                text[0] = writer.newItem(TextItem.class, new String[0]);
                text[0].setText(holderName);
            }
            if (CompleteStructureWriter.this.graph.isInstanceOf(source, CompleteStructureWriter.this.sl.FunctionalSource)) {
                Resource relation = CompleteStructureWriter.this.graph.getPossibleObject(source, CompleteStructureWriter.this.sl.consernsRelation);
                text[1] = writer.newItem(TextItem.class, new String[0]);
                if (relation != null) {
                    String relationName = NameUtils.getSafeLabel((ReadGraph)CompleteStructureWriter.this.graph, (Resource)relation);
                    if (relationName.length() == 0) {
                        relationName = NameUtils.getSafeName((ReadGraph)CompleteStructureWriter.this.graph, (Resource)relation);
                    }
                    Object value = CompleteStructureWriter.this.graph.getPossibleRelatedValue(holder, relation);
                    text[1].setText(relationName);
                    if (value != null) {
                        text[2] = writer.newItem(TextItem.class, new String[0]);
                        text[2].setText(SourceLinkUtil.getValueString(value));
                    }
                } else {
                    text[1].setText(Messages.CompleteStructureWriter_ErrorInPropertyRefrence);
                }
            }
            text[3] = (document = SourceLinkUtil.getReferredDocument(CompleteStructureWriter.this.graph, source)) != null ? CompleteStructureWriter.this.getDocumentItem(document) : CompleteStructureWriter.this.getNonExistingDocumentItem();
            String comment = (String)CompleteStructureWriter.this.graph.getPossibleRelatedValue(source, CompleteStructureWriter.this.sl.hasSourceComment);
            if (comment != null) {
                text[4] = writer.newItem(TextItem.class, new String[0]);
                text[4].setText(comment);
            }
        }
    }
}

