/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.pdf;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentElement;
import org.simantics.document.linking.report.TableColumn;
import org.simantics.document.linking.report.TableOfContents;
import org.simantics.document.linking.report.pdf.Messages;
import org.simantics.document.linking.report.pdf.PDFDocument;
import org.simantics.document.linking.report.pdf.PDFElement;
import org.simantics.document.linking.report.pdf.PDFPage;
import org.simantics.document.linking.report.pdf.PDFPageStream;
import org.simantics.document.linking.report.pdf.PDFTable;
import org.simantics.utils.datastructures.Pair;

public class PDFTocElement
implements TableOfContents {
    PDFDocument writer;
    PDFPageStream stream;
    Font itemFont;
    Font titleFont;
    int linesPerPage;
    int linesOnFirstPage;
    PDFTable tocTable;
    private List<Pair<String, PDFElement>> toc = new ArrayList<Pair<String, PDFElement>>();

    public PDFTocElement(PDFDocument writer) throws Exception {
        this.writer = writer;
        this.stream = new PDFPageStream();
        this.itemFont = writer.getFont(Document.TextSize.SMALL);
        this.titleFont = writer.getFont(Document.TextSize.LARGE);
        this.stream.setDefaultFont(this.itemFont);
        this.stream.nextPage();
        this.tocTable = new PDFTable(writer, this.stream);
        this.linesPerPage = this.tocTable.getAvailableLines();
        PDFPage page = this.stream.getCurrentPage();
        page.setFont(this.titleFont);
        page.writeLine(Messages.PDFTocElement_TocHeading);
        page.setFont(this.itemFont);
        page.writeLine("");
        this.linesOnFirstPage = this.tocTable.getAvailableLines();
    }

    @Override
    public void addTocElement(String label, DocumentElement element) {
        this.toc.add((Pair<String, PDFElement>)new Pair((Object)label, (Object)((PDFElement)((Object)element))));
    }

    public void create(PDFPageStream destStream, PDFPage after) throws Exception {
        int tocPages = this.getEstimatedPages();
        List<PDFPage> pages = destStream.getPages();
        int tocIndex = pages.indexOf(after) + 1;
        this.tocTable.addColumn("Document", 0.9);
        this.tocTable.addColumn("Page", 0.1).setAlignment(TableColumn.Alignment.RIGHT);
        this.tocTable.setHeaderVisible(false);
        this.tocTable.setLinesVisible(false);
        for (Pair<String, PDFElement> item : this.toc) {
            int pageIndex = pages.indexOf(((PDFElement)item.second).getPage());
            if (pageIndex >= 0) {
                pageIndex += tocPages + 1;
            }
            this.tocTable.writeRow((String)item.first, Integer.toString(pageIndex));
        }
        pages.addAll(tocIndex, this.stream.getPages());
        this.stream = null;
    }

    public int getEstimatedPages() {
        int pages = 1;
        int items = this.toc.size();
        items -= this.linesOnFirstPage;
        while (items > 0) {
            items -= this.linesPerPage;
            ++pages;
        }
        return pages;
    }
}

