/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.html;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentElement;
import org.simantics.document.linking.report.DocumentItem;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableOfContents;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.URLItem;
import org.simantics.document.linking.report.base.TextItemImpl;
import org.simantics.document.linking.report.html.HTMLElement;
import org.simantics.document.linking.report.html.HTMLStreamElement;
import org.simantics.document.linking.report.html.HTMLTable;
import org.simantics.document.linking.report.html.HTMLTitlePage;
import org.simantics.document.linking.report.html.HTMLTocElement;
import org.simantics.document.linking.report.html.HTMLURLItemImpl;
import org.simantics.utils.datastructures.Arrays;

public class HTMLDocument
extends HTMLStreamElement
implements Document {
    boolean referCSS = false;
    int currentPage = 0;
    int currentLine = 1;
    HTMLStreamElement content;
    private Map<Class<? extends HTMLElement>, Integer> uniqueIndex = new HashMap<Class<? extends HTMLElement>, Integer>();
    private HTMLTable currentTable;
    HTMLTocElement toc;
    HTMLTitlePage titlePage;

    @Override
    public String getId() {
        return null;
    }

    public HTMLDocument(File file) throws Exception {
        super(file);
        this.content = new HTMLStreamElement(this);
    }

    String getUniqueId(Class<? extends HTMLElement> cls) {
        Integer index = this.uniqueIndex.get(cls);
        index = index == null ? Integer.valueOf(1) : Integer.valueOf(index + 1);
        this.uniqueIndex.put(cls, index);
        return cls.getSimpleName() + "_" + String.valueOf(index);
    }

    String getUniqueId(HTMLElement element) {
        Class<?> cls = element.getClass();
        return this.getUniqueId(cls);
    }

    private static String getDataUrl() throws IOException {
        Bundle b = Platform.getBundle((String)"org.simantics.document.linking.ui");
        URL dataUrl = FileLocator.find((Bundle)b, (IPath)new Path("report"), null);
        URL fileUrl = FileLocator.toFileURL((URL)dataUrl);
        return URLDecoder.decode(fileUrl.getPath(), "UTF-8");
    }

    private void copyBaseCSS(String cssUrl) throws Exception {
        File f = new File(URLDecoder.decode(cssUrl, "UTF-8")).getAbsoluteFile();
        this.copyData(f, this.os);
    }

    private void header() throws Exception {
        PrintStream resultOs = this.os;
        String cssUrl = HTMLDocument.getDataUrl() + "/report.css";
        resultOs.println("<!DOCTYPE html>");
        resultOs.println("<html lang=\"en\">");
        resultOs.println("<head>");
        resultOs.println("  <meta charset=\"utf-8\">");
        resultOs.println("  <title>Report</title>");
        if (this.referCSS) {
            resultOs.println("  <link rel=\"stylesheet\" href=\"" + cssUrl + "\" type=\"text/css\">");
        }
        resultOs.println("  <style>");
        if (!this.referCSS) {
            this.copyBaseCSS(cssUrl);
        }
        resultOs.println("  </style>");
        resultOs.println("</head>");
        resultOs.println("<body>");
    }

    private void footer() throws Exception {
        if (this.currentTable != null) {
            this.currentTable.endTable();
        }
        if (this.toc != null) {
            this.toc.close();
        }
        this.content.close();
        PrintStream resultOs = this.os;
        resultOs.println("</body>");
        resultOs.println("</html>");
    }

    @Override
    public void close() throws Exception {
        this.footer();
        super.close();
    }

    @Override
    public int getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public int getAvailableLines() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void nextPage() throws Exception {
        if (this.currentPage == 0) {
            this.header();
        }
        ++this.currentPage;
        this.currentLine = 1;
    }

    @Override
    public <T extends DocumentElement> T newElement(Class<T> cls, String ... options) throws Exception {
        if (cls == Table.class) {
            return (T)this.newTable(Arrays.contains((Object[])options, (Object)"toc"));
        }
        if (cls == TableOfContents.class) {
            return (T)this.getOrCreateToc();
        }
        if (cls == DocumentTitlePage.class) {
            if (this.titlePage != null) {
                throw new Exception("Document many have only one title page");
            }
            this.titlePage = new HTMLTitlePage(this);
            return (T)this.titlePage;
        }
        return null;
    }

    @Override
    public <T extends DocumentElement> T nextElement(Class<T> cls, String ... options) throws Exception {
        if (cls == Table.class) {
            return (T)this.nextTable(Arrays.contains((Object[])options, (Object)"toc"));
        }
        if (cls == TableOfContents.class) {
            return (T)this.getOrCreateToc();
        }
        return null;
    }

    @Override
    public <T extends DocumentElement> T getCurrentElement(Class<T> cls) {
        if (cls == Table.class) {
            return (T)this.getCurrentTable();
        }
        if (cls == TableOfContents.class) {
            return (T)this.toc;
        }
        if (cls == DocumentTitlePage.class) {
            return (T)this.titlePage;
        }
        return null;
    }

    @Override
    public <T extends DocumentItem> T newItem(Class<T> cls, String ... options) throws Exception {
        if (cls == TextItem.class) {
            return (T)new TextItemImpl();
        }
        if (cls == URLItem.class) {
            return (T)new HTMLURLItemImpl();
        }
        return null;
    }

    public Table nextTable(boolean id) throws Exception {
        if (this.currentTable != null) {
            this.currentTable.endTable();
            this.currentTable = new HTMLTable(this.currentTable, id);
            return this.currentTable;
        }
        return this.currentTable;
    }

    public Table newTable(boolean id) throws Exception {
        if (this.currentTable != null) {
            this.currentTable.endTable();
        }
        this.currentTable = new HTMLTable(this, this.content.os, id);
        return this.currentTable;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public TableOfContents getOrCreateToc() throws Exception {
        if (this.toc == null) {
            this.toc = new HTMLTocElement(this);
        }
        return this.toc;
    }
}

