/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.simantics.document.linking.report.evaluator.AlignmentHint;
import org.simantics.document.linking.report.evaluator.And;
import org.simantics.document.linking.report.evaluator.Constant;
import org.simantics.document.linking.report.evaluator.Date;
import org.simantics.document.linking.report.evaluator.EvaluatorItem;
import org.simantics.document.linking.report.evaluator.EvaluatorLeaf;
import org.simantics.document.linking.report.evaluator.EvaluatorRoot;
import org.simantics.document.linking.report.evaluator.If;
import org.simantics.document.linking.report.evaluator.Or;
import org.simantics.document.linking.report.evaluator.Path;
import org.simantics.document.linking.report.evaluator.TextSizeHint;
import org.simantics.document.linking.report.evaluator.Variable;
import org.simantics.objmap.graph.annotations.OrderedElementsAdd;
import org.simantics.objmap.graph.annotations.OrderedElementsGet;
import org.simantics.objmap.graph.annotations.OrderedElementsRem;

public abstract class EvaluatorNode
implements EvaluatorItem {
    EvaluatorNode parent;
    List<EvaluatorItem> children = new ArrayList<EvaluatorItem>();

    @Override
    public EvaluatorNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(EvaluatorNode parent) {
        this.parent = parent;
    }

    @OrderedElementsGet
    public List<EvaluatorItem> getChildren() {
        return this.children;
    }

    public boolean acceptChild(EvaluatorItem item) {
        return true;
    }

    public boolean acceptChild(int index, EvaluatorItem item) {
        return true;
    }

    public void addChild(EvaluatorItem item) {
        this.children.add(item);
        item.setParent(this);
    }

    @OrderedElementsAdd
    public void addChild(int index, EvaluatorItem item) {
        this.children.add(index, item);
        item.setParent(this);
    }

    public int indexOf(EvaluatorItem item) {
        return this.children.indexOf(item);
    }

    @OrderedElementsRem
    public void removeChild(EvaluatorItem item) {
        this.children.remove(item);
        item.setParent(null);
    }

    public List<Class<? extends EvaluatorItem>> getPossibleChildren(boolean add) {
        ArrayList<Class<? extends EvaluatorItem>> classes = new ArrayList<Class<? extends EvaluatorItem>>();
        classes.add(And.class);
        classes.add(Or.class);
        classes.add(If.class);
        classes.add(Constant.class);
        classes.add(Variable.class);
        classes.add(Date.class);
        classes.add(Path.class);
        EvaluatorRoot root = this.getRoot();
        if (root != null && root.isSupportStyles()) {
            classes.add(TextSizeHint.class);
            classes.add(AlignmentHint.class);
        }
        return classes;
    }

    public <T extends EvaluatorItem> T createChild(Class<T> cls) {
        try {
            EvaluatorItem child = (EvaluatorItem)cls.newInstance();
            if (child instanceof EvaluatorNode) {
                ((EvaluatorNode)child).parent = this;
            } else if (child instanceof EvaluatorLeaf) {
                ((EvaluatorLeaf)child).parent = this;
            }
            this.addChild(child);
            return (T)child;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T extends EvaluatorItem> T createChild(int index, Class<T> cls) {
        try {
            EvaluatorItem child = (EvaluatorItem)cls.newInstance();
            if (child instanceof EvaluatorNode) {
                ((EvaluatorNode)child).parent = this;
            } else if (child instanceof EvaluatorLeaf) {
                ((EvaluatorLeaf)child).parent = this;
            }
            this.addChild(child);
            return (T)child;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public EvaluatorRoot getRoot() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getRoot();
    }

    protected void copyChildren(EvaluatorNode copy) {
        for (EvaluatorItem i : this.children) {
            copy.addChild(i.copy());
        }
    }
}

