package org.simantics.document.linking.report.evaluator;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.Document.TextSize;
import org.simantics.objmap.graph.annotations.OrderedSetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;


@OrderedSetType(DocumentLink.URIs.EvaluatorTree_TextSizeHint)
public class TextSizeHint extends HintNode implements EnumEditableNode{
	
	
	TextSize textSize;
	
	public TextSizeHint() {
		textSize = TextSize.SMALL;
	}
	
	public TextSizeHint(TextSize textSize) {
		this.textSize = textSize;
	}
	
	
	@RelatedGetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public String getValue() {
		return textSize.toString();
	}
	
	@RelatedSetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public void setValue(String value) {
		textSize = TextSize.valueOf(value);
	}
	
	public TextSizeHint setTextSize(TextSize textSize) {
		this.textSize = textSize;
		return this;
	}
	
	@Override
	public String[] getEnumearation() {
		String values[] = new String[TextSize.values().length];
		for (int i = 0; i < values.length; i++)
			values[i] = TextSize.values()[i].toString();
		return values;
	}
	
	@Override
	public String toString() {
		return textSize.toString();
	}
	
	@Override
	public Object getHintValue() {
		return textSize;
	}
	
	@Override
	public Object getHintClass() {
		return TextSize.class;
	}
	
	@Override
	public EvaluatorItem copy() {
		TextSizeHint t = new TextSizeHint(textSize);
		copyChildren(t);
		return t;
	}
	
	@Override
	public ImageDescriptor getImage() {
		if (textSize == TextSize.TINY) {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_heading_5.png"); //$NON-NLS-1$ //$NON-NLS-2$
		} else if (textSize == TextSize.SMALL) {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_heading_4.png"); //$NON-NLS-1$ //$NON-NLS-2$
		} else if (textSize == TextSize.MEDIUM) {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_heading_3.png"); //$NON-NLS-1$ //$NON-NLS-2$
		} else if (textSize == TextSize.LARGE) {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_heading_2.png"); //$NON-NLS-1$ //$NON-NLS-2$
		} else if (textSize == TextSize.HUGE) {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_heading_1.png"); //$NON-NLS-1$ //$NON-NLS-2$
		} else {
			return null;
		}
	}

}
