/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.platform.debug;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.common.EvaluatorData.EvaluatorTree;
import org.simantics.browsing.ui.common.contributor.FinalRootViewpointContributionContributor;

public class EvaluatorTreeContribution extends FinalRootViewpointContributionContributor<EvaluatorTree<?>> {

    @Override
    public Collection<?> getContribution(EvaluatorTree<?> input) {
        Collection<Object> inputs = new ArrayList<Object>();
        inputs.addAll(input.getAcceptedFactories());
        inputs.addAll(input.getChildren());
        return inputs;
    }

    @Override
    public String getViewpointId() {
        return "Evaluators";
    }

}
