/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.HashSet;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.property.IProperty;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.GraphPropertyUtil;
import org.simantics.browsing.ui.graph.impl.IsEnumeratedValue;
import org.simantics.browsing.ui.graph.impl.LazyViewpoint;
import org.simantics.browsing.ui.graph.impl.ResourceProperty;
import org.simantics.browsing.ui.graph.impl.ResourcePropertyFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.RelationContextImpl;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class PropertyViewpointFactory
implements ViewpointFactory {
    public Viewpoint create(PrimitiveQueryUpdater provider, NodeContext context, BuiltinKeys.ViewpointKey key) {
        return new LazyViewpoint(provider, context, key){

            @Override
            public NodeContext[] children(ReadGraph graph) throws DatabaseException {
                Object in = this.getInput(Object.class);
                Resource input = null;
                if (in instanceof Resource) {
                    input = (Resource)in;
                } else if (in instanceof ResourceArray) {
                    ResourceArray ra = (ResourceArray)in;
                    if (ra.isEmpty()) {
                        return NodeContext.NONE;
                    }
                    input = ra.resources[0];
                } else if (in instanceof Statement) {
                    input = ((Statement)in).getObject();
                } else {
                    return NodeContext.NONE;
                }
                ArrayList<ResourceProperty> properties = new ArrayList<ResourceProperty>();
                HashSet<Resource> usedProperties = new HashSet<Resource>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource predicate : graph.getPredicates(input)) {
                    if (!graph.isSubrelationOf(predicate, L0.IsRelatedTo)) continue;
                    for (Statement stm : graph.getStatements(input, predicate)) {
                        Resource object = stm.getObject();
                        if (!usedProperties.add(stm.getPredicate()) || !graph.isInstanceOf(stm.getObject(), L0.Literal) || !graph.isSubrelationOf(stm.getPredicate(), L0.HasProperty) && !((Boolean)graph.syncRequest((Read)new IsEnumeratedValue(object))).booleanValue()) continue;
                        IProperty.Type type = stm.getSubject().equals(input) ? IProperty.Type.DIRECT : IProperty.Type.ASSERTED;
                        ResourceProperty prop = GraphPropertyUtil.tryCreateProperty(graph, object, new ResourcePropertyFactory(type, input, stm.getPredicate(), object, ResourceArray.EMPTY));
                        if (prop != null) {
                            properties.add(prop);
                            continue;
                        }
                        properties.add((ResourceProperty)new RelationContextImpl(input, stm));
                    }
                }
                return this.toContextsWithInput(properties);
            }

            @Override
            public Boolean hasChildren(ReadGraph graph) throws DatabaseException {
                if (this.children(graph).length > 0) {
                    return true;
                }
                return false;
            }
        };
    }

    public String toString() {
        return "Properties";
    }
}

