/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.simantics.xml.sax.ExporterGenerator;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.SchemaConversionComponent;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.SchemaElement;
import org.simantics.xml.sax.SchemaObject;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.AttributeGroupRef;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.Schema;

public abstract class JavaGenerator
implements SchemaConversionComponent {
    String commentTag = "//";
    Schema schema;
    String ontologyClassName;
    String ontologyUri;
    SchemaConverter converter;
    SchemaConversionBase base;
    List<String> ruleClassNames = new ArrayList<String>();
    String ontShort = "ONT";
    String name;
    File importParserDir;
    String elementPackageName;
    Map<SchemaObject, FileWriter> writers = new HashMap<SchemaObject, FileWriter>();

    public JavaGenerator(SchemaConverter converter, SchemaConversionBase base) {
        this.converter = converter;
        this.base = base;
        this.schema = base.schema;
        this.ontologyClassName = base.className;
        this.ontologyUri = base.ontologyURI;
        this.converter = converter;
        this.name = converter.name;
        this.ontShort = converter.shortName;
        this.ontShort = String.valueOf(this.ontShort) + ".";
        this.elementPackageName = this.name + this.getPackagePostFix();
    }

    public String getElementPackageName() {
        return this.elementPackageName;
    }

    protected PrintWriter createFile(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        PrintWriter writer = new PrintWriter(file);
        String[] stringArray = this.converter.getHeader();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            writer.println(this.commentTag + " " + s);
            ++n2;
        }
        writer.println();
        return writer;
    }

    protected String getValueGetterMethod(SchemaConversionBase.TypeEntry binding, String name) {
        if (binding == null) {
            return name + ".getValue()";
        }
        return binding.getValueGetterMethod(name);
    }

    protected String getValueGetter(SchemaConversionBase.TypeEntry binding, String name) {
        if (binding == null) {
            return name;
        }
        return binding.getValueGetter(name);
    }

    protected String getValueGetter(SchemaConversionBase.TypeEntry binding) {
        if (binding == null) {
            return "value";
        }
        return binding.getValueGetter();
    }

    @Override
    public String getSimpleTypePrefix() {
        return "SimpleTypes_";
    }

    @Override
    public String getComplexTypePrefix() {
        return "ComplexTypes_";
    }

    @Override
    public String getAttributeGroupPrefix() {
        return "AttributeGroups_";
    }

    @Override
    public String getModelGroupPrefix() {
        return "ModelGroups_";
    }

    @Override
    public String handleChoice(SchemaObject parent, SchemaElement indicator, List<SchemaElement> elements, String name) {
        String baseRelationName = this.getName(parent) + ".has" + name;
        return baseRelationName;
    }

    protected String getOntologyImport() {
        return this.ontologyClassName + " " + this.ontShort.substring(0, this.ontShort.length() - 1) + " = " + this.ontologyClassName + ".getInstance(graph);";
    }

    protected FileWriter getWriter(SchemaObject obj) {
        SchemaObject s = obj;
        while (s != null) {
            FileWriter fw = this.writers.get(s);
            if (fw != null) {
                return fw;
            }
            s = s.getParent();
        }
        return null;
    }

    public String getFullName(SchemaObject obj) {
        String prefix = this.getRefPrefix(obj);
        return prefix + this.getName(obj);
    }

    @Override
    public String getName(SchemaObject obj) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return this.getComplexTypePrefix() + obj.getName();
                }
                case ELEMENT: {
                    return obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return this.getAttributeGroupPrefix() + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return this.getSimpleTypePrefix() + obj.getName();
                }
                case MODEL_GROUP: {
                    return this.getModelGroupPrefix() + obj.getName();
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            Object name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = o.getName() + "_" + (String)name;
                }
                prev = o;
                o = o.getParent();
                if (!(prev.getObj() instanceof AttributeGroupRef)) continue;
                o = null;
            }
            name = ((String)name).substring(0, ((String)name).length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return this.getComplexTypePrefix() + (String)name;
                }
                case ELEMENT: {
                    return name;
                }
                case ATTRIBUTE_GROUP: {
                    return this.getAttributeGroupPrefix() + (String)name;
                }
                case SIMPLE_TYPE: {
                    return this.getSimpleTypePrefix() + (String)name;
                }
                case MODEL_GROUP: {
                    return this.getModelGroupPrefix() + (String)name;
                }
            }
        }
        throw new RuntimeException();
    }

    public String getFullName(SchemaObject obj, String rel) {
        String prefix = this.getRefPrefix(obj);
        return prefix + this.getName(obj, rel);
    }

    public String getName(SchemaObject obj, String rel) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return this.getComplexTypePrefix() + rel + obj.getName();
                }
                case ELEMENT: {
                    return rel + obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return this.getAttributeGroupPrefix() + rel + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return this.getSimpleTypePrefix() + rel + obj.getName();
                }
                case MODEL_GROUP: {
                    return this.getModelGroupPrefix() + rel + obj.getName();
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            Object name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = o.getName() + "_" + (String)name;
                }
                prev = o;
                o = o.getParent();
            }
            name = ((String)name).substring(0, ((String)name).length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return this.getComplexTypePrefix() + rel + (String)name;
                }
                case ELEMENT: {
                    return rel + (String)name;
                }
                case ATTRIBUTE_GROUP: {
                    return this.getAttributeGroupPrefix() + rel + (String)name;
                }
                case SIMPLE_TYPE: {
                    return this.getSimpleTypePrefix() + rel + (String)name;
                }
                case MODEL_GROUP: {
                    return this.getModelGroupPrefix() + rel + (String)name;
                }
            }
        }
        throw new RuntimeException();
    }

    public SchemaConversionBase getSchemaConversionBase(AttributeGroup attribute) {
        List<SchemaConverter> convs;
        SchemaConversionBase b = this.base;
        if (attribute.getRef() != null && (convs = this.converter.getConverter(attribute.getRef().getNamespaceURI())).size() == 1) {
            b = convs.get((int)0).base;
        }
        return b;
    }

    public String getRefPrefix(SchemaObject parent) {
        Object prefix = this.ontShort;
        if (parent.getSc() != this.base) {
            prefix = parent.getSc().converter.shortName + ".";
        }
        return prefix;
    }

    public void writeOntologyImports(FileWriter fw) {
        fw.writer.println("       " + this.getOntologyImport());
        for (SchemaConverter conv : this.converter.getSubConverters()) {
            ExporterGenerator gen = new ExporterGenerator(conv, conv.base);
            fw.writer.println("       " + gen.getOntologyImport());
        }
    }

    protected void writeClass(PrintWriter writer, boolean abst, String elementId, String className, String baseClass, List<String> interfaces) {
        writer.println("@SuppressWarnings(\"unused\")");
        writer.print("public " + (abst ? "abstract " : "") + "class " + className + " extends " + baseClass);
        if (interfaces.size() > 0) {
            writer.print(" implements ");
            int i = 0;
            while (i < interfaces.size()) {
                writer.print(interfaces.get(i));
                if (i < interfaces.size() - 1) {
                    writer.print(",");
                }
                ++i;
            }
        }
        writer.println("{");
        writer.println();
        writer.println("   @Override");
        writer.println("   public java.lang.String getElementId() {");
        if (elementId != null) {
            writer.println("      return \"" + elementId + "\";");
        } else {
            writer.println("      return null;");
        }
        writer.println("   }");
        writer.println();
    }

    protected abstract void createReferenceIndicator(SchemaObject var1, SchemaConversionBase.RefType var2, String var3, String var4, String var5, String var6, boolean var7, boolean var8);

    protected abstract void createPrimitiveIndicator(SchemaObject var1, String var2, SchemaConversionBase.TypeEntry var3, QName var4);

    protected abstract void createElementIndicator(SchemaObject var1, boolean var2, String var3, String var4, String var5, boolean var6);

    protected abstract String getPackagePostFix();

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement element, String refName, SchemaConversionBase.RefType referenceType, String baseRelationName) {
        if (referenceType != SchemaConversionBase.RefType.Element) {
            SchemaConversionBase.TypeEntry typeEntry;
            String objectName;
            QName refTypeName;
            SchemaObject refObject = null;
            if (referenceType == SchemaConversionBase.RefType.Type) {
                refTypeName = element.getElement().getType();
                if (refName == null) {
                    refName = this.base.getName(element.getElement());
                }
                objectName = this.base.getName(element.getElement());
                refObject = this.base.getComplexType(refTypeName);
                if (refObject == null) {
                    this.base.getSimpleType(refTypeName);
                }
            } else {
                refTypeName = element.getElement().getRef();
                if (refName == null) {
                    refName = this.base.getName(refTypeName);
                }
                objectName = refTypeName.getLocalPart();
                refObject = this.base.getElement(refTypeName);
            }
            if ((typeEntry = this.base.getTypeEntry(refTypeName)) == null) {
                Object primaryClassName = null;
                String secondaryClassName = null;
                if (refObject != null) {
                    primaryClassName = this.getName(refObject);
                    if (refObject.getSc() != this.base) {
                        SchemaConverter con = refObject.getSc().converter;
                        primaryClassName = con.getPluginName() + "." + con.name + this.getPackagePostFix() + "." + (String)primaryClassName;
                    }
                } else {
                    if (this.base.getSimpleType(refTypeName) != null) {
                        SchemaConversionBase.Inheritance inheritance = new SchemaConversionBase.Inheritance("");
                        this.base.getAtomicTypeInheritance(refTypeName, inheritance);
                        if (inheritance.atomicType != null) {
                            this.createPrimitiveIndicator(parent, refName, inheritance.atomicType, refTypeName);
                            return;
                        }
                        throw new RuntimeException("No supported atomic type found for simple type " + refTypeName.toString());
                    }
                    throw new RuntimeException("Type that is neither complex nor simple??");
                }
                secondaryClassName = primaryClassName;
                boolean useElementList = this.base.useElementList(parent, indicator, element, referenceType == SchemaConversionBase.RefType.Reference, refName, refTypeName);
                boolean useOriginalList = this.base.useOriginalList(parent, indicator, element, referenceType == SchemaConversionBase.RefType.Reference, refName, refTypeName);
                this.createReferenceIndicator(parent, referenceType, refName, objectName, (String)primaryClassName, secondaryClassName, useElementList, useOriginalList);
            } else {
                this.createPrimitiveIndicator(parent, refName, typeEntry, refTypeName);
            }
        } else {
            Element attrs = element.getElement();
            SchemaObject obj = this.base.getWithObj(parent, attrs);
            String objName = this.getFullName(obj);
            String className = this.getClassName(obj);
            if (refName == null) {
                refName = this.base.getName(attrs);
            }
            boolean useElementList = this.base.useElementList(parent, indicator, element, false, refName, new QName(obj.getName()));
            boolean useOriginalList = this.base.useOriginalList(parent, indicator, element, false, refName, new QName(obj.getName()));
            this.createElementIndicator(parent, useElementList, refName, objName, className, useOriginalList);
        }
    }

    protected String getClassName(SchemaObject obj) {
        Object className = this.getName(obj);
        if (obj.getSc() != this.base) {
            SchemaConverter conv = obj.getSc().converter;
            className = conv.pluginName + "." + conv.name + this.getPackagePostFix() + "." + (String)className;
        }
        return className;
    }

    protected static class FileWriter {
        public PrintWriter writer;
        public PrintWriter delayedWriter;
        public PrintWriter delayedWriter2;

        protected FileWriter() {
        }
    }
}

