/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.text;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.simantics.interop.update.text.ValueCompareInput;
import org.simantics.utils.strings.EString;

public class ObjectValueComparator
implements IStructureComparator,
IStreamContentAccessor,
ITypedElement,
IAdaptable,
ISharedDocumentAdapter,
IEditableContent,
IEditorInput,
IEncodedStreamContentAccessor {
    ValueCompareInput input;
    Object value;

    public ObjectValueComparator(ValueCompareInput input, Object value) {
        this.input = input;
        this.value = value;
    }

    public ValueCompareInput getInput() {
        return this.input;
    }

    public Object getValue() {
        return this.value;
    }

    public InputStream getContents() throws CoreException {
        if (this.value instanceof String) {
            return new ByteArrayInputStream(((String)this.value).getBytes(StandardCharsets.UTF_8));
        }
        if (this.value instanceof byte[]) {
            return new ByteArrayInputStream((byte[])this.value);
        }
        if (this.value.getClass().isArray()) {
            String s = null;
            if (this.value instanceof String[]) {
                s = EString.implode((Object[])((String[])this.value));
            } else if (this.value instanceof int[]) {
                s = Arrays.toString((int[])this.value);
            } else if (this.value instanceof long[]) {
                s = Arrays.toString((long[])this.value);
            } else if (this.value instanceof float[]) {
                s = Arrays.toString((float[])this.value);
            } else if (this.value instanceof double[]) {
                s = Arrays.toString((double[])this.value);
            } else if (this.value instanceof boolean[]) {
                s = Arrays.toString((boolean[])this.value);
            } else {
                throw new CoreException((IStatus)new Status(4, "fi.semantum.simupedia.changemanagement", "Cannot convert data to comparable string " + this.value.getClass().getSimpleName()));
            }
            return new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
        }
        return new ByteArrayInputStream(this.value.toString().getBytes(StandardCharsets.UTF_8));
    }

    protected void storeValue(Object newValue) {
        this.value = newValue;
        this.input.storeValue(newValue);
    }

    public void flushDocument(IDocumentProvider provider, IEditorInput documentKey, IDocument document, boolean overwrite) throws CoreException {
        if (this.input.pc.getDataType() == null) {
            throw new RuntimeException("Property is missing DataType");
        }
        if (this.input.pc.getDataType() == String.class) {
            this.storeValue(document.get());
        } else if (this.input.pc.getDataType() == byte[].class) {
            this.storeValue(document.get().getBytes(StandardCharsets.UTF_8));
        } else {
            this.convertToDataType(document.get());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertToDataType(String s) {
        if (this.input.pc.getDataType() == null) {
            throw new RuntimeException("Property is missing DataType");
        }
        if (this.input.pc.getDataType().isArray()) {
            s = s.trim();
            if (this.input.pc.getDataType() == String[].class) {
                this.storeValue(EString.explode((String)s));
                return;
            }
            if (!s.startsWith("[") || !s.endsWith("]")) {
                throw new RuntimeException("Expected array string, given input is not in format []");
            }
            s.substring(1, s.length() - 1);
            String[] elems = s.split(",");
            if (this.input.pc.getDataType() == int[].class) {
                int[] data = new int[elems.length];
                int i = 0;
                while (i < elems.length) {
                    data[i] = Integer.parseInt(elems[i]);
                    ++i;
                }
                this.storeValue(data);
                return;
            } else if (this.input.pc.getDataType() == long[].class) {
                long[] data = new long[elems.length];
                int i = 0;
                while (i < elems.length) {
                    data[i] = Long.parseLong(elems[i]);
                    ++i;
                }
                this.storeValue(data);
                return;
            } else if (this.input.pc.getDataType() == float[].class) {
                float[] data = new float[elems.length];
                int i = 0;
                while (i < elems.length) {
                    data[i] = Float.parseFloat(elems[i]);
                    ++i;
                }
                this.storeValue(data);
                return;
            } else if (this.input.pc.getDataType() == double[].class) {
                double[] data = new double[elems.length];
                int i = 0;
                while (i < elems.length) {
                    data[i] = Double.parseDouble(elems[i]);
                    ++i;
                }
                this.storeValue(data);
                return;
            } else {
                if (this.input.pc.getDataType() != boolean[].class) throw new RuntimeException("Unsupported DataType " + this.input.pc.getDataType().getSimpleName());
                boolean[] data = new boolean[elems.length];
                int i = 0;
                while (i < elems.length) {
                    data[i] = Boolean.parseBoolean(elems[i]);
                    ++i;
                }
                this.storeValue(data);
            }
            return;
        } else if (this.input.pc.getDataType() == Integer.TYPE || this.input.pc.getDataType() == Integer.class) {
            this.storeValue(Integer.parseInt(s));
            return;
        } else if (this.input.pc.getDataType() == Long.TYPE || this.input.pc.getDataType() == Long.class) {
            this.storeValue(Long.parseLong(s));
            return;
        } else if (this.input.pc.getDataType() == Short.TYPE || this.input.pc.getDataType() == Short.class) {
            this.storeValue(Short.parseShort(s));
            return;
        } else if (this.input.pc.getDataType() == Byte.TYPE || this.input.pc.getDataType() == Byte.class) {
            this.storeValue(Byte.parseByte(s));
            return;
        } else if (this.input.pc.getDataType() == Float.TYPE || this.input.pc.getDataType() == Float.class) {
            this.storeValue(Float.valueOf(Float.parseFloat(s)));
            return;
        } else if (this.input.pc.getDataType() == Double.TYPE || this.input.pc.getDataType() == Double.class) {
            this.storeValue(Double.parseDouble(s));
            return;
        } else {
            if (this.input.pc.getDataType() != Boolean.TYPE && this.input.pc.getDataType() != Boolean.class) throw new RuntimeException("Unsupported DataType " + this.input.pc.getDataType().getSimpleName());
            this.storeValue(Boolean.parseBoolean(s));
        }
    }

    public void setContent(byte[] newContent) {
        if (this.input.pc.getDataType() == null) {
            throw new RuntimeException("Property is missing DataType");
        }
        if (this.input.pc.getDataType() == String.class) {
            this.storeValue(new String(newContent, StandardCharsets.UTF_8));
        } else if (this.input.pc.getDataType() == byte[].class) {
            this.storeValue(newContent);
        } else {
            String s = new String(newContent, StandardCharsets.UTF_8);
            this.convertToDataType(s);
        }
    }

    public boolean isEditable() {
        if (this.input.fThreeWay) {
            return this.value == this.input.pc.getValues().third;
        }
        return this.value == this.input.pc.getValues().first;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    public Object[] getChildren() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return this.input.getTitle() + "." + this.getType();
    }

    public String getType() {
        return "txt";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ISharedDocumentAdapter.class.equals(adapter)) {
            return (T)this;
        }
        return null;
    }

    public IEditorInput getDocumentKey(Object element) {
        return this;
    }

    public void connect(IDocumentProvider provider, IEditorInput documentKey) throws CoreException {
        provider.connect((Object)this);
    }

    public void disconnect(IDocumentProvider provider, IEditorInput documentKey) {
        provider.disconnect((Object)this);
    }

    public void disconnect(Object element) {
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public String getCharset() throws CoreException {
        return "UTF-8";
    }
}

