/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import java.util.ArrayList;
import java.util.List;
import org.simantics.db.Resource;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.ResourceIdentifiable;
import org.simantics.interop.mapping.data.ResourceSetSplitIdentifiable;

public class ResourceSplitIdentifiable
extends ResourceIdentifiable {
    private static int counter = 0;
    private int identifier;
    private int index;

    ResourceSplitIdentifiable(Resource resource, int index, int identifier) {
        super(resource);
        this.index = index;
        this.identifier = identifier;
    }

    public static List<Identifiable> createIdentifiables(ResourceIdentifiable identifiable, int count) {
        ArrayList<Identifiable> result = new ArrayList<Identifiable>(count);
        int identifier = counter++;
        int i = 0;
        while (i < count) {
            result.add(new ResourceSplitIdentifiable(identifiable.getResource(), i, identifier));
            ++i;
        }
        return result;
    }

    public static List<Identifiable> createIdentifiables(Identifiable identifiable, int count) {
        Resource res = identifiable.getAdapter(Resource.class);
        if (res == null) {
            return null;
        }
        Resource[] resources = identifiable.getAdapter(Resource[].class);
        if (resources.length > 1) {
            return ResourceSetSplitIdentifiable.createIdentifiables(identifiable, count);
        }
        ArrayList<Identifiable> result = new ArrayList<Identifiable>(count);
        int identifier = counter++;
        int i = 0;
        while (i < count) {
            result.add(new ResourceSplitIdentifiable(res, i, identifier));
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass() != arg0.getClass()) {
            return false;
        }
        ResourceSplitIdentifiable other = (ResourceSplitIdentifiable)arg0;
        if (this.identifier != other.identifier) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return this.resource.equals(other.resource);
    }

    @Override
    public Identifiable merge(Identifiable other) {
        throw new RuntimeException("Cannot be merged");
    }
}

