/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.simantics.interop.mapping.data.Link;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphNode<T>
extends HintContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphNode.class);
    protected T data;
    private List<Link<T>> nodes = new ArrayList<Link<T>>();
    private boolean disposed = false;

    public GraphNode(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public void setHint(IHintContext.Key key, Object value) {
        this._checkDisposed();
        if (value == null) {
            return;
        }
        super.setHint(key, value);
    }

    public Link<T> addLink(String relationName, String inverseRelationName, GraphNode<T> node) {
        this._checkDisposed();
        LOGGER.info("Node link " + String.valueOf(this.data) + " " + String.valueOf(node.data) + " " + relationName + " " + inverseRelationName + "\n");
        if (this.containsLink(relationName, node) && node.containsLink(inverseRelationName, this)) {
            LOGGER.warn("Node " + String.valueOf(this.getData()) + " has already given child " + String.valueOf(node.getData()) + " ,with name " + relationName + " / " + inverseRelationName);
            return null;
        }
        Link<T> rel = this._addLink(relationName, node);
        Link<T> inv = node._addLink(inverseRelationName, this);
        rel.setInverseLink(inv);
        inv.setMainLink(rel);
        return rel;
    }

    public Link<T> addLink(String relationName, GraphNode<T> node) {
        this._checkDisposed();
        if (this.containsLink(relationName, node)) {
            LOGGER.warn("Node " + String.valueOf(this.getData()) + " has already given child " + String.valueOf(node.getData()) + " ,with name " + relationName);
            return null;
        }
        Link<T> rel = this._addLink(relationName, node);
        Link<T> inv = node._addLink(null, this);
        rel.setInverseLink(inv);
        inv.setMainLink(rel);
        return rel;
    }

    public Link<T> addLink(Link<T> link, GraphNode<T> node) {
        this._checkDisposed();
        if (this.containsLink(link.getName(), node) && node.containsLink(link.getInverseName(), this)) {
            LOGGER.warn("Node " + String.valueOf(this.getData()) + " has already given child " + String.valueOf(node.getData()) + " ,with name " + link.getName() + " / " + link.getInverseName());
            return null;
        }
        Link<T> rel = this._addLink(link.getName(), node);
        Link<T> inv = node._addLink(link.getInverseName(), this);
        rel.setInverseLink(inv);
        inv.setMainLink(rel);
        rel.setHints(link.getHints());
        inv.setHints(link.getInverse().getHints());
        return rel;
    }

    protected Link<T> _addLink(String relation, GraphNode<T> node) {
        Link<T> link = new Link<T>(this, relation, node);
        this.nodes.add(link);
        return link;
    }

    protected Link<T> _removeLink(String relation, String inverse, GraphNode<T> node) {
        int i = 0;
        while (i < this.nodes.size()) {
            Link<T> link = this.nodes.get(i);
            if (node.equals(link.to()) && GraphNode.equals(relation, link.getName()) && GraphNode.equals(inverse, link.getInverseName())) {
                return this.nodes.remove(i);
            }
            ++i;
        }
        return null;
    }

    protected Link<T> _removeLink(String relation) {
        int i = 0;
        while (i < this.nodes.size()) {
            Link<T> link = this.nodes.get(i);
            if (GraphNode.equals(relation, link.getName())) {
                return this.nodes.remove(i);
            }
            ++i;
        }
        return null;
    }

    protected Link<T> _removeLink(String relation, String inverse) {
        int i = 0;
        while (i < this.nodes.size()) {
            Link<T> link = this.nodes.get(i);
            if (GraphNode.equals(relation, link.getName()) && GraphNode.equals(inverse, link.getInverseName())) {
                return this.nodes.remove(i);
            }
            ++i;
        }
        return null;
    }

    protected Link<T> _removeLink(String relation, GraphNode<T> node) {
        int i = 0;
        while (i < this.nodes.size()) {
            Link<T> link = this.nodes.get(i);
            if (node.equals(link.to()) && GraphNode.equals(relation, link.getName())) {
                return this.nodes.remove(i);
            }
            ++i;
        }
        return null;
    }

    protected Link<T> _removeLink(GraphNode<T> node) {
        int i = 0;
        while (i < this.nodes.size()) {
            Link<T> link = this.nodes.get(i);
            if (node.equals(link.to())) {
                return this.nodes.remove(i);
            }
            ++i;
        }
        return null;
    }

    protected boolean _removeLink(Link<T> link) {
        return this.nodes.remove(link);
    }

    public boolean removeLink(Link<T> link) {
        this._checkDisposed();
        if (this._removeLink(link)) {
            if (link.hasInverse()) {
                link.to()._removeLink(link.getInverse());
            }
            return true;
        }
        return false;
    }

    public boolean removeLink(String relation) {
        Link<T> removed;
        this._checkDisposed();
        boolean deleted = false;
        while ((removed = this._removeLink(relation)) != null) {
            if (!removed.hasInverse()) continue;
            removed.to()._removeLink(removed.getInverse());
            deleted = true;
        }
        return deleted;
    }

    public boolean removeLink(String relation, String inverse) {
        Link<T> removed;
        this._checkDisposed();
        boolean deleted = false;
        while ((removed = this._removeLink(relation, inverse)) != null) {
            if (!removed.hasInverse()) continue;
            removed.to()._removeLink(removed.getInverse());
            deleted = true;
        }
        return deleted;
    }

    public boolean removeLink(String relation, GraphNode<T> node) {
        Link<T> removed;
        this._checkDisposed();
        boolean deleted = false;
        while ((removed = this._removeLink(relation, node)) != null) {
            if (!removed.hasInverse()) continue;
            removed.to()._removeLink(removed.getInverse());
            deleted = true;
        }
        return deleted;
    }

    public boolean removeLink(GraphNode<T> node) {
        Link<T> removed;
        this._checkDisposed();
        boolean deleted = false;
        while ((removed = this._removeLink(node)) != null) {
            if (!removed.hasInverse()) continue;
            removed.to()._removeLink(removed.getInverse());
            deleted = true;
        }
        return deleted;
    }

    public boolean removeLink(String relation, String inverse, GraphNode<T> node) {
        this._checkDisposed();
        Link<T> removed = this._removeLink(relation, inverse, node);
        if (removed != null && removed.hasInverse()) {
            removed.to()._removeLink(removed.getInverse());
            return true;
        }
        return false;
    }

    public boolean containsLink(GraphNode<T> node) {
        this._checkDisposed();
        for (Link<T> link : this.nodes) {
            if (!node.equals(link.to())) continue;
            return true;
        }
        return false;
    }

    public boolean containsLink(String relationName, GraphNode<T> node) {
        this._checkDisposed();
        if (relationName == null) {
            return false;
        }
        for (Link<T> link : this.nodes) {
            if (!node.equals(link.to()) || !GraphNode.equals(relationName, link.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsLink(String relationName, String inverseName, GraphNode<T> node) {
        this._checkDisposed();
        for (Link<T> link : this.nodes) {
            if (!node.equals(link.to()) || !GraphNode.equals(relationName, link.getName()) || !GraphNode.equals(inverseName, link.getInverseName())) continue;
            return true;
        }
        return false;
    }

    public Collection<Link<T>> getLinks() {
        this._checkDisposed();
        ArrayList<Link<T>> coll = new ArrayList<Link<T>>(this.nodes);
        return coll;
    }

    public Collection<GraphNode<T>> getNodes(String rel) {
        this._checkDisposed();
        ArrayList<GraphNode<T>> result = new ArrayList<GraphNode<T>>();
        for (Link<T> link : this.nodes) {
            if (!GraphNode.equals(rel, link.getName())) continue;
            result.add(link.to());
        }
        return result;
    }

    public Collection<Link<T>> getLinks(String rel) {
        this._checkDisposed();
        ArrayList<Link<T>> result = new ArrayList<Link<T>>();
        for (Link<T> link : this.nodes) {
            if (!GraphNode.equals(rel, link.getName())) continue;
            result.add(link);
        }
        return result;
    }

    public Collection<Link<T>> getLinks(String rel, GraphNode<T> node) {
        this._checkDisposed();
        ArrayList<Link<T>> result = new ArrayList<Link<T>>();
        for (Link<T> link : this.nodes) {
            if (!GraphNode.equals(rel, link.getName()) || !link.to().equals(node)) continue;
            result.add(link);
        }
        return result;
    }

    public Collection<Link<T>> getLinks(String rel, String inverse) {
        this._checkDisposed();
        ArrayList<Link<T>> result = new ArrayList<Link<T>>();
        for (Link<T> link : this.nodes) {
            if (!GraphNode.equals(rel, link.getName()) || !GraphNode.equals(inverse, link.getInverseName())) continue;
            result.add(link);
        }
        return result;
    }

    public Collection<Link<T>> getLinks(String rel, String inverse, GraphNode<T> node) {
        this._checkDisposed();
        ArrayList<Link<T>> result = new ArrayList<Link<T>>();
        for (Link<T> link : this.nodes) {
            if (!GraphNode.equals(rel, link.getName()) || !GraphNode.equals(inverse, link.getInverseName()) || !link.to().equals(node)) continue;
            result.add(link);
        }
        return result;
    }

    public Collection<GraphNode<T>> getNodesWithInv(String inv) {
        this._checkDisposed();
        ArrayList<GraphNode<T>> result = new ArrayList<GraphNode<T>>();
        for (Link<T> link : this.nodes) {
            if (!GraphNode.equals(inv, link.getInverseName())) continue;
            result.add(link.to());
        }
        return result;
    }

    public Collection<GraphNode<T>> getNodes(String rel, String inv) {
        this._checkDisposed();
        ArrayList<GraphNode<T>> result = new ArrayList<GraphNode<T>>();
        for (Link<T> link : this.nodes) {
            if (!GraphNode.equals(rel, link.getName()) || !GraphNode.equals(inv, link.getInverseName())) continue;
            result.add(link.to());
        }
        return result;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        if (s2 != null) {
            return s2.equals(s1);
        }
        return true;
    }

    public Collection<Link<T>> getLinks(GraphNode<T> node) {
        this._checkDisposed();
        ArrayList<Link<T>> result = new ArrayList<Link<T>>();
        for (Link<T> link : this.nodes) {
            if (!link.to().equals(node)) continue;
            result.add(link);
        }
        return result;
    }

    public Collection<String> getRelations(GraphNode<T> node) {
        this._checkDisposed();
        ArrayList<String> result = new ArrayList<String>();
        for (Link<T> link : this.nodes) {
            if (!link.to().equals(node) || link.getName() == null) continue;
            result.add(link.getName());
        }
        return result;
    }

    public Collection<Link<T>> getInverseLinks(GraphNode<T> node) {
        this._checkDisposed();
        ArrayList<Link<T>> result = new ArrayList<Link<T>>();
        for (Link<T> link : this.nodes) {
            if (!link.to().equals(node)) continue;
            result.add(link.getInverse());
        }
        return result;
    }

    public Collection<String> getInverses(GraphNode<T> node) {
        this._checkDisposed();
        ArrayList<String> result = new ArrayList<String>();
        for (Link<T> link : this.nodes) {
            if (!link.to().equals(node) || link.getInverseName() == null) continue;
            result.add(link.getInverseName());
        }
        return result;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object arg0) {
        if (!arg0.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        GraphNode other = (GraphNode)((Object)arg0);
        if (this == other) {
            return true;
        }
        if (this.data == null || other.data == null) {
            return false;
        }
        return this.data.equals(other.data);
    }

    public GraphNode<T> merge(GraphNode<T> other, T mergedData) {
        this._checkDisposed();
        GraphNode<T> mergedNode = new GraphNode<T>(mergedData);
        GraphNode.copyLinks(this, mergedNode);
        GraphNode.copyLinks(other, mergedNode);
        this.destroy();
        other.destroy();
        return mergedNode;
    }

    public static <T> Link<T> copyLink(GraphNode<T> from, GraphNode<T> to, Link<T> l) {
        if (l.from() != from) {
            throw new IllegalArgumentException("Link is not starting from " + String.valueOf(from) + " node.");
        }
        if (l.to() == to) {
            return null;
        }
        if (to.containsLink(l.getName(), l.getInverseName(), l.to())) {
            return null;
        }
        if (l.isMain()) {
            Link<T> newLink = to.addLink(l.getName(), l.getInverseName(), l.to());
            if (newLink != null) {
                newLink.setHints(l.getHints());
                newLink.getInverse().setHints(l.getInverse().getHints());
                return newLink;
            }
            return null;
        }
        Link<T> newLink = l.to().addLink(l.getInverseName(), l.getName(), to);
        if (newLink != null) {
            newLink.setHints(l.getInverse().getHints());
            newLink.getInverse().setHints(l.getHints());
            return newLink.getInverse();
        }
        return null;
    }

    public static <T> Link<T> copyLinkInverse(GraphNode<T> from, GraphNode<T> to, Link<T> l) {
        if (l.from() != from) {
            throw new IllegalArgumentException("Link is not starting from " + String.valueOf(from) + " node.");
        }
        if (l.to() == to) {
            return null;
        }
        if (to.containsLink(l.getInverseName(), l.getName(), l.to())) {
            return null;
        }
        if (l.isMain()) {
            Link<T> newLink = l.to().addLink(l.getName(), l.getInverseName(), to);
            if (newLink != null) {
                newLink.setHints(l.getHints());
                newLink.getInverse().setHints(l.getInverse().getHints());
                return newLink;
            }
            return null;
        }
        Link<T> newLink = to.addLink(l.getInverseName(), l.getName(), l.to());
        if (newLink != null) {
            newLink.setHints(l.getInverse().getHints());
            newLink.getInverse().setHints(l.getHints());
            return newLink.getInverse();
        }
        return null;
    }

    public static <T> void copyLinks(GraphNode<T> from, GraphNode<T> to, Collection<Link<T>> links) {
        for (Link<T> l : links) {
            GraphNode.copyLink(from, to, l);
        }
    }

    public static <T> void copyLinks(GraphNode<T> from, GraphNode<T> to) {
        for (Link<T> l : from.getLinks()) {
            GraphNode.copyLink(from, to, l);
        }
    }

    public static <T> Link<T> moveLink(GraphNode<T> from, GraphNode<T> to, Link<T> l) {
        Link<T> newLink = GraphNode.copyLink(from, to, l);
        if (newLink != null) {
            from.removeLink(l);
            return newLink;
        }
        return null;
    }

    public static <T> void moveLinks(GraphNode<T> from, GraphNode<T> to, Collection<Link<T>> links) {
        for (Link<T> l : links) {
            Link<T> newLink = GraphNode.copyLink(from, to, l);
            if (newLink == null) continue;
            from.removeLink(l);
        }
    }

    public static <T> void moveLinkInverses(GraphNode<T> from, GraphNode<T> to, Collection<Link<T>> links) {
        for (Link<T> l : links) {
            Link<T> newLink = GraphNode.copyLinkInverse(from, to, l);
            if (newLink == null) continue;
            from.removeLink(l);
        }
    }

    public static <T> void moveLinks(GraphNode<T> from, GraphNode<T> to) {
        for (Link<T> l : from.getLinks()) {
            Link<T> newLink = GraphNode.copyLink(from, to, l);
            if (newLink == null) continue;
            from.removeLink(l);
        }
    }

    public static <T> Link<T>[] insert(Link<T> link, GraphNode<T> insert) {
        GraphNode<T> a = link.from();
        Link<T> c_b = GraphNode.moveLink(a, insert, link);
        Link<T> a_c = a.addLink(c_b, insert);
        return new Link[]{a_c, c_b};
    }

    public Collection<GraphNode<T>> getFullSimilars() {
        this._checkDisposed();
        ArrayList<GraphNode<T>> result = new ArrayList<GraphNode<T>>();
        HashSet<GraphNode<T>> potential = new HashSet<GraphNode<T>>();
        for (Link<T> link : this.nodes) {
            for (Link<T> link2 : link.to().nodes) {
                if (link2.to().equals((Object)this)) continue;
                potential.add(link2.to());
            }
        }
        for (GraphNode graphNode : potential) {
            if (!graphNode.nodes.containsAll(this.nodes)) continue;
            result.add(graphNode);
        }
        return result;
    }

    public Collection<GraphNode<T>> getSemiSimilars() {
        this._checkDisposed();
        ArrayList<GraphNode<T>> result = new ArrayList<GraphNode<T>>();
        HashSet<GraphNode<T>> potential = new HashSet<GraphNode<T>>();
        for (Link<T> link : this.nodes) {
            for (Link<T> link2 : link.to().nodes) {
                if (link2.to().equals((Object)this)) continue;
                potential.add(link2.to());
            }
        }
        for (GraphNode graphNode : potential) {
            for (Link<T> link : this.nodes) {
                if (!graphNode.nodes.contains(link)) continue;
                result.add(graphNode);
            }
        }
        return result;
    }

    public void destroy() {
        if (this.disposed) {
            return;
        }
        LOGGER.info("Node destroy " + String.valueOf(this.data) + " " + String.valueOf((Object)this));
        ArrayList<Link<T>> coll = new ArrayList<Link<T>>();
        coll.addAll(this.nodes);
        this.nodes.clear();
        for (Link link : coll) {
            link.to()._removeLink(this);
        }
        this.nodes = null;
        this.disposed = true;
    }

    public void remove() {
        if (this.disposed) {
            return;
        }
        LOGGER.info("Node remove " + String.valueOf(this.data) + " " + String.valueOf((Object)this));
        if (this.nodes.size() == 1) {
            Link<T> link = this.nodes.get(0);
            link.to().removeLink(link.getInverseName(), link.getName(), this);
        } else {
            int i = 0;
            while (i < this.nodes.size() - 1) {
                Link<T> link1 = this.nodes.get(i);
                link1.to()._removeLink(link1.getInverseName(), link1.getName(), this);
                int j = i + 1;
                while (j < this.nodes.size()) {
                    Link<T> link2 = this.nodes.get(j);
                    link2.to()._removeLink(link2.getInverseName(), link2.getName(), this);
                    if (!link1.to().equals(link2.to())) {
                        link1.to().addLink(link1.getInverseName(), link2.getInverseName(), link2.to());
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.nodes.clear();
        this.nodes = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        ArrayList<Link<T>> links = new ArrayList<Link<T>>();
        links.addAll(this.nodes);
        this.nodes.clear();
        for (Link link : links) {
            link.to().dispose();
        }
        links.clear();
        this.nodes = null;
        this.disposed = true;
    }

    protected void _checkDisposed() {
        if (this.disposed) {
            LOGGER.error("Remove Node, disposed " + String.valueOf((Object)this));
            throw new RuntimeException("Node " + String.valueOf((Object)this) + " is disposed.");
        }
    }

    public int distanceTo(GraphNode<T> node, String rel, String inv) {
        HashSet<GraphNode<T>> nextNext;
        if (node.equals((Object)this)) {
            return 0;
        }
        int count = 0;
        HashSet processed = new HashSet();
        HashSet<GraphNode> next = new HashSet<GraphNode>();
        next.add(this);
        do {
            if (next.size() == 0) {
                return -1;
            }
            ++count;
            processed.addAll(next);
            nextNext = new HashSet<GraphNode<T>>();
            for (GraphNode n : next) {
                for (GraphNode<T> nn : n.getNodes(rel, inv)) {
                    if (processed.contains(nn)) continue;
                    nextNext.add(nn);
                }
            }
        } while (!(next = nextNext).contains(node));
        return count;
    }

    public String toString() {
        return "Node : " + String.valueOf(this.data);
    }
}

