/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.interop.mapping.CancelException;
import org.simantics.interop.mapping.ConnectionGenerationRule;
import org.simantics.interop.mapping.ConnectionIdentificationRule;
import org.simantics.interop.mapping.GenerationRule;
import org.simantics.interop.mapping.IdentificationRule;
import org.simantics.interop.mapping.InitializedRule;
import org.simantics.interop.mapping.MappingHints;
import org.simantics.interop.mapping.MappingRule;
import org.simantics.interop.mapping.MappingTools;
import org.simantics.interop.mapping.ModificationRule;
import org.simantics.interop.mapping.data.GraphNode;
import org.simantics.interop.mapping.data.Identifiable;
import org.simantics.interop.mapping.data.Link;
import org.simantics.interop.mapping.data.ResourceIdentifiable;
import org.simantics.ui.jobs.SessionGarbageCollectorJob;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mapper.class);
    public static final boolean USE_SPLIT_TRANSACTIONS = false;
    public static int OBJECTS_PER_TRANSACTION = 5000;
    private static boolean SLEEP_BETWEEN_WRITES = false;
    private static int SLEEP_TIME = 10;
    private static boolean COLLECT_BETWEEN_WRITES = false;
    private static boolean COLLECT_WITHIN_TRANSACTIONS = true;
    public static int OBJECTS_BEFORE_COLLECT = 5000;
    private List<InitializedRule> initializedRules = new ArrayList<InitializedRule>();
    private List<Pair<IdentificationRule, Pair<Integer, GenerationRule>>> generationRules;
    private List<List<ModificationRule>> globalModificationRules;
    private List<List<Pair<IdentificationRule, ModificationRule>>> modificationRules;
    private List<Pair<ConnectionIdentificationRule, ConnectionGenerationRule>> connectionRules;
    int maxGenPass = 0;
    private VirtualGraph vg;
    int collect = 0;

    public Mapper() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int use = 290;
        int freeMem = (int)(maxMemory /= 0x100000L) - use;
        OBJECTS_BEFORE_COLLECT = freeMem * freeMem / 1000;
        if (OBJECTS_BEFORE_COLLECT < 2) {
            OBJECTS_BEFORE_COLLECT = 2;
        }
        OBJECTS_PER_TRANSACTION = OBJECTS_BEFORE_COLLECT;
        this.generationRules = new ArrayList<Pair<IdentificationRule, Pair<Integer, GenerationRule>>>();
        this.modificationRules = new ArrayList<List<Pair<IdentificationRule, ModificationRule>>>();
        this.globalModificationRules = new ArrayList<List<ModificationRule>>();
        this.connectionRules = new ArrayList<Pair<ConnectionIdentificationRule, ConnectionGenerationRule>>();
    }

    public void addRule(int pass, IdentificationRule idRule, GenerationRule genRule) {
        if (idRule == null || genRule == null) {
            throw new NullPointerException();
        }
        this.generationRules.add((Pair<IdentificationRule, Pair<Integer, GenerationRule>>)new Pair((Object)idRule, (Object)new Pair((Object)pass, (Object)genRule)));
        this.maxGenPass = Math.max(this.maxGenPass, pass);
        if (genRule instanceof InitializedRule) {
            this.initializedRules.add((InitializedRule)((Object)genRule));
        }
    }

    public void addRule(IdentificationRule idRule, MappingRule mappingRule) {
        this.addRule(0, idRule, mappingRule);
    }

    public void addRule(IdentificationRule idRule, MappingRule ... mappingRules) {
        MappingRule[] mappingRuleArray = mappingRules;
        int n = mappingRules.length;
        int n2 = 0;
        while (n2 < n) {
            MappingRule mappingRule = mappingRuleArray[n2];
            this.addRule(0, idRule, mappingRule);
            ++n2;
        }
    }

    public void addRule(int pass, IdentificationRule idRule, MappingRule mappingRule) {
        if (idRule == null || mappingRule == null) {
            throw new NullPointerException();
        }
        if (mappingRule instanceof ModificationRule) {
            while (pass >= this.modificationRules.size()) {
                this.modificationRules.add(new ArrayList());
            }
            List<Pair<IdentificationRule, ModificationRule>> priList = this.modificationRules.get(pass);
            priList.add((Pair<IdentificationRule, ModificationRule>)new Pair((Object)idRule, (Object)((ModificationRule)mappingRule)));
        }
        if (mappingRule instanceof GenerationRule) {
            this.generationRules.add((Pair<IdentificationRule, Pair<Integer, GenerationRule>>)new Pair((Object)idRule, (Object)new Pair((Object)pass, (Object)((GenerationRule)mappingRule))));
        }
        if (mappingRule instanceof InitializedRule) {
            this.initializedRules.add((InitializedRule)((Object)mappingRule));
        }
    }

    public void addRule(int pass, IdentificationRule idRule, MappingRule ... mappingRules) {
        MappingRule[] mappingRuleArray = mappingRules;
        int n = mappingRules.length;
        int n2 = 0;
        while (n2 < n) {
            MappingRule mappingRule = mappingRuleArray[n2];
            this.addRule(pass, idRule, mappingRule);
            ++n2;
        }
    }

    public void addRule(IdentificationRule idRule, ModificationRule ... modRules) {
        this.addRule(0, idRule, modRules);
    }

    /*
     * Unable to fully structure code
     */
    public void addRule(int pass, IdentificationRule idRule, ModificationRule ... modRules) {
        if (idRule != null) ** GOTO lbl5
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            this.modificationRules.add(new ArrayList<E>());
lbl5:
            // 2 sources

            ** while (pass >= this.modificationRules.size())
        }
lbl6:
        // 1 sources

        priList = this.modificationRules.get(pass);
        var8_5 = modRules;
        var7_6 = modRules.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            modRule = var8_5[var6_7];
            if (modRule == null) {
                throw new NullPointerException();
            }
            priList.add((Pair<IdentificationRule, ModificationRule>)new Pair((Object)idRule, (Object)modRule));
            if (modRule instanceof InitializedRule) {
                this.initializedRules.add((InitializedRule)modRule);
            }
            ++var6_7;
        }
    }

    public void addRule(ModificationRule modRule) {
        this.addRule(0, modRule);
    }

    public void addRule(InitializedRule initRule) {
        this.initializedRules.add(initRule);
    }

    /*
     * Unable to fully structure code
     */
    public void addRule(int pass, ModificationRule modRule) {
        if (modRule != null) ** GOTO lbl5
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            this.globalModificationRules.add(new ArrayList<E>());
lbl5:
            // 2 sources

            ** while (pass >= this.globalModificationRules.size())
        }
lbl6:
        // 1 sources

        priList = this.globalModificationRules.get(pass);
        priList.add(modRule);
        if (modRule instanceof InitializedRule) {
            this.initializedRules.add((InitializedRule)modRule);
        }
    }

    public void addRule(ConnectionIdentificationRule idRule, ConnectionGenerationRule genRule) {
        if (idRule == null || genRule == null) {
            throw new NullPointerException();
        }
        this.connectionRules.add((Pair<ConnectionIdentificationRule, ConnectionGenerationRule>)new Pair((Object)idRule, (Object)genRule));
        if (genRule instanceof InitializedRule) {
            this.initializedRules.add((InitializedRule)((Object)genRule));
        }
    }

    public void map(WriteGraph g, Resource model, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        this.startMapping(null);
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            for (InitializedRule rule : this.initializedRules) {
                rule.initialize(g, model);
            }
            this.applyModifications((ReadGraph)g, nodes, monitor);
            monitor.worked(1);
            this.applyGenerations(g, nodes, monitor);
            monitor.worked(1);
            this.applyConnections(g, nodes, monitor);
            monitor.worked(1);
        }
        finally {
            MappingTools.disposeNodes(nodes);
            this.endMapping();
        }
    }

    public void map(Session session, Resource model, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        this.map(session, model, null, nodes, monitor);
    }

    public void map(Session session, Resource model, VirtualGraph vg, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        this.startMapping(vg);
        try {
            long time = System.currentTimeMillis();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            this.initializeRules(session, vg, model);
            this.applyModifications2(session, nodes, monitor);
            monitor.worked(1);
            this.applyGenerations2(session, vg, nodes, monitor);
            monitor.worked(1);
            this.applyConnections2(session, vg, nodes, monitor);
            monitor.worked(1);
            long time2 = System.currentTimeMillis();
            System.out.println("Mapping took " + (time2 - time) / 1000L + " seconds");
        }
        finally {
            MappingTools.disposeNodes(nodes);
            if (COLLECT_BETWEEN_WRITES) {
                SessionGarbageCollection.gc(null, (Session)session, (boolean)true, null);
            }
            this.endMapping();
        }
    }

    protected void startMapping(VirtualGraph vg) {
        SessionGarbageCollectorJob.getInstance().setEnabled(false);
        this.vg = vg;
    }

    protected void endMapping() {
        SessionGarbageCollectorJob.getInstance().setEnabled(true).scheduleAfterQuietTime();
        this.vg = null;
    }

    private void applyModifications(ReadGraph g, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        int passCount = Math.max(this.globalModificationRules.size(), this.modificationRules.size());
        int pass = 0;
        while (pass < passCount) {
            Collection<GraphNode<Identifiable>> ruleModified;
            int size;
            List<ModificationRule> modRules;
            int count;
            if (this.globalModificationRules.size() > pass) {
                count = 0;
                modRules = this.globalModificationRules.get(pass);
                size = modRules.size();
                monitor.subTask("Running global modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                for (ModificationRule modificationRule : modRules) {
                    ruleModified = modificationRule.modify(g, nodes);
                    if (ruleModified == null) continue;
                    for (GraphNode<Identifiable> m : ruleModified) {
                        if (m.isDisposed()) {
                            nodes.remove(m);
                            continue;
                        }
                        if (nodes.contains(m)) continue;
                        nodes.add(m);
                    }
                    monitor.subTask("Running global modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                    if (monitor.isCanceled()) {
                        throw new CancelException("Cancel requested.");
                    }
                    if (!COLLECT_WITHIN_TRANSACTIONS) continue;
                    this.collect(g);
                }
            }
            if (this.modificationRules.size() > pass) {
                count = 0;
                modRules = this.modificationRules.get(pass);
                size = modRules.size();
                monitor.subTask("Running object modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                for (Pair pair : modRules) {
                    ruleModified = new ArrayList<GraphNode<Identifiable>>();
                    for (GraphNode<Identifiable> n : nodes) {
                        this.applyModifications(g, n, (Pair<IdentificationRule, ModificationRule>)pair, ruleModified);
                        if (!COLLECT_WITHIN_TRANSACTIONS) continue;
                        this.collect2(g);
                    }
                    for (GraphNode<Identifiable> m : ruleModified) {
                        if (m.isDisposed()) {
                            nodes.remove(m);
                            continue;
                        }
                        if (nodes.contains(m)) continue;
                        nodes.add(m);
                    }
                    monitor.subTask("Running object modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                    if (!monitor.isCanceled()) continue;
                    throw new CancelException("Cancel requested.");
                }
            }
            ++pass;
        }
    }

    protected void applyGenerations(WriteGraph graph, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        int size = nodes.size();
        int count = 0;
        monitor.subTask("Assigning generation rules (" + count + "/" + size + ")");
        for (GraphNode<Identifiable> n : nodes) {
            for (Pair<IdentificationRule, Pair<Integer, GenerationRule>> r : this.generationRules) {
                if (!((IdentificationRule)r.first).matches((ReadGraph)graph, n)) continue;
                MappingTools.assignGenerationRule(n, (Integer)((Pair)r.second).first, (GenerationRule)((Pair)r.second).second);
            }
            monitor.subTask("Assigning generation rules (" + ++count + "/" + size + ")");
            if (monitor.isCanceled()) {
                throw new CancelException("Cancel requested.");
            }
            if (!COLLECT_WITHIN_TRANSACTIONS) continue;
            this.collect2((ReadGraph)graph);
        }
        count = 0;
        monitor.subTask("Generating objects (" + count + "/" + size + ")");
        int stage = 0;
        while (stage <= this.maxGenPass) {
            count = 0;
            for (GraphNode<Identifiable> n : nodes) {
                MapList priRules = (MapList)n.getHint(MappingHints.KEY_GENERATION_RULES);
                if (priRules != null) {
                    List rules = priRules.getValues((Object)stage);
                    for (GenerationRule r : rules) {
                        r.generate(graph, n);
                    }
                }
                monitor.subTask("Generating objects, stage " + stage + " :  (" + ++count + "/" + size + ")");
                if (monitor.isCanceled()) {
                    throw new CancelException("Cancel requested.");
                }
                if (!COLLECT_WITHIN_TRANSACTIONS) continue;
                this.collect2((ReadGraph)graph);
            }
            ++stage;
        }
    }

    protected void applyConnections(WriteGraph g, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        int size = nodes.size();
        int count = 0;
        monitor.subTask("Generating connections (" + count + "/" + size + ")");
        for (GraphNode<Identifiable> node : nodes) {
            this.applyConnections(g, node);
            monitor.subTask("Generating connections (" + ++count + "/" + size + ")");
            if (monitor.isCanceled()) {
                throw new CancelException("Cancel requested.");
            }
            if (!COLLECT_WITHIN_TRANSACTIONS) continue;
            this.collect2((ReadGraph)g);
        }
    }

    protected String getName(ReadGraph g, Identifiable res) throws DatabaseException {
        if (res instanceof ResourceIdentifiable) {
            return NameUtils.getSafeName((ReadGraph)g, (Resource)((ResourceIdentifiable)res).getResource());
        }
        return res.toString();
    }

    protected void initializeRules(Session session, VirtualGraph vg, final Resource model) throws DatabaseException {
        session.syncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph g) throws DatabaseException {
                for (InitializedRule rule : Mapper.this.initializedRules) {
                    rule.initialize(g, model);
                }
            }
        });
    }

    protected void collect(ReadGraph g) throws DatabaseException {
        if (this.vg != null) {
            return;
        }
        SessionGarbageCollection.gc((ReadGraph)g, (int)0, (int)-1);
    }

    protected void collect2(ReadGraph g) throws DatabaseException {
        if (this.vg != null) {
            return;
        }
        if (this.collect == OBJECTS_BEFORE_COLLECT) {
            SessionGarbageCollection.gc((ReadGraph)g, (int)0, (int)-1);
            this.collect = 0;
        } else {
            ++this.collect;
        }
    }

    protected void applyModifications(Session session, final Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        int passCount = Math.max(this.globalModificationRules.size(), this.modificationRules.size());
        int pass = 0;
        while (pass < passCount) {
            int size;
            List<ModificationRule> modRules;
            int count;
            if (this.globalModificationRules.size() > pass) {
                count = 0;
                modRules = this.globalModificationRules.get(pass);
                size = modRules.size();
                monitor.subTask("Running global modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                for (final ModificationRule modificationRule : modRules) {
                    session.syncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph g) throws DatabaseException {
                            try {
                                Collection<GraphNode<Identifiable>> ruleModified = modificationRule.modify(g, nodes);
                                if (ruleModified == null) {
                                    return;
                                }
                                for (GraphNode<Identifiable> m : ruleModified) {
                                    if (m.isDisposed()) {
                                        nodes.remove(m);
                                        continue;
                                    }
                                    if (nodes.contains(m)) continue;
                                    nodes.add(m);
                                }
                                if (COLLECT_WITHIN_TRANSACTIONS) {
                                    Mapper.this.collect(g);
                                }
                            }
                            catch (Exception e) {
                                throw new DatabaseException((Throwable)e);
                            }
                        }
                    });
                    monitor.subTask("Running global modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                    if (!monitor.isCanceled()) continue;
                    throw new CancelException("Cancel requested.");
                }
            }
            if (this.modificationRules.size() > pass) {
                count = 0;
                modRules = this.modificationRules.get(pass);
                size = modRules.size();
                monitor.subTask("Running object modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                for (final Pair pair : modRules) {
                    final Iterator<GraphNode<Identifiable>> iter = nodes.iterator();
                    final ArrayList ruleModified = new ArrayList();
                    while (iter.hasNext()) {
                        session.syncRequest((Read)new ReadRequest(){

                            public void run(ReadGraph g) throws DatabaseException {
                                try {
                                    int j = 0;
                                    while (iter.hasNext() && j < OBJECTS_PER_TRANSACTION) {
                                        GraphNode n = (GraphNode)((Object)iter.next());
                                        Mapper.this.applyModifications(g, n, (Pair<IdentificationRule, ModificationRule>)pair, ruleModified);
                                        ++j;
                                    }
                                    if (COLLECT_WITHIN_TRANSACTIONS) {
                                        Mapper.this.collect(g);
                                    }
                                }
                                catch (Exception e) {
                                    throw new DatabaseException((Throwable)e);
                                }
                            }
                        });
                    }
                    for (GraphNode m : ruleModified) {
                        if (m.isDisposed()) {
                            nodes.remove((Object)m);
                            continue;
                        }
                        if (nodes.contains((Object)m)) continue;
                        nodes.add(m);
                    }
                    ruleModified.clear();
                    monitor.subTask("Running object modification rules: pass (" + (pass + 1) + "/" + passCount + "), rule (" + ++count + "/" + size + ")");
                    if (!monitor.isCanceled()) continue;
                    throw new CancelException("Cancel requested.");
                }
            }
            ++pass;
        }
    }

    private void applyModifications2(Session session, final Collection<GraphNode<Identifiable>> nodes, final IProgressMonitor monitor) throws Exception {
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                try {
                    Mapper.this.applyModifications(g, (Collection<GraphNode<Identifiable>>)nodes, monitor);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    protected void applyGenerations(Session session, VirtualGraph vg, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        int size = nodes.size();
        int count = 0;
        monitor.subTask("Assigning generation rules (" + count + "/" + size + ")");
        final Iterator<GraphNode<Identifiable>> iter = nodes.iterator();
        while (iter.hasNext()) {
            int c = (Integer)session.syncRequest((Read)new Read<Integer>(){

                public Integer perform(ReadGraph graph) throws DatabaseException {
                    int j = 0;
                    while (iter.hasNext() && j < OBJECTS_PER_TRANSACTION) {
                        GraphNode n = (GraphNode)((Object)iter.next());
                        for (Pair<IdentificationRule, Pair<Integer, GenerationRule>> r : Mapper.this.generationRules) {
                            if (!((IdentificationRule)r.first).matches(graph, n)) continue;
                            MapList rules = (MapList)n.getHint(MappingHints.KEY_GENERATION_RULES);
                            if (rules == null) {
                                rules = new MapList();
                            }
                            rules.add((Object)((Integer)((Pair)r.second).first), (Object)((GenerationRule)((Pair)r.second).second));
                            n.setHint(MappingHints.KEY_GENERATION_RULES, rules);
                        }
                        ++j;
                    }
                    if (COLLECT_WITHIN_TRANSACTIONS) {
                        Mapper.this.collect(graph);
                    }
                    return j;
                }
            });
            this.collect(session);
            monitor.subTask("Assigning generation rules (" + (count += c) + "/" + size + ")");
            if (monitor.isCanceled()) {
                throw new CancelException("Cancel requested.");
            }
            this.sleep();
        }
        count = 0;
        monitor.subTask("Generating objects (" + count + "/" + size + ")");
        int stage = 0;
        while (stage <= this.maxGenPass) {
            final int fStage = stage;
            count = 0;
            final Iterator<GraphNode<Identifiable>> iter2 = nodes.iterator();
            while (iter2.hasNext()) {
                int c = (Integer)session.syncRequest((WriteResult)new WriteResultRequest<Integer>(vg){

                    public Integer perform(WriteGraph graph) throws DatabaseException {
                        int j = 0;
                        try {
                            while (iter2.hasNext() && j < OBJECTS_PER_TRANSACTION) {
                                GraphNode n = (GraphNode)((Object)iter2.next());
                                MapList priRules = (MapList)n.getHint(MappingHints.KEY_GENERATION_RULES);
                                if (priRules == null) {
                                    ++j;
                                    continue;
                                }
                                List rules = priRules.getValues((Object)fStage);
                                if (fStage == 0 && rules.size() == 0) {
                                    System.out.println();
                                }
                                for (GenerationRule r : rules) {
                                    r.generate(graph, n);
                                }
                                ++j;
                            }
                            if (COLLECT_WITHIN_TRANSACTIONS) {
                                Mapper.this.collect((ReadGraph)graph);
                            }
                            return j;
                        }
                        catch (Exception e) {
                            throw new DatabaseException((Throwable)e);
                        }
                    }
                });
                this.collect(session);
                monitor.subTask("Generating objects, stage " + stage + " :  (" + (count += c) + "/" + size + ")");
                if (monitor.isCanceled()) {
                    throw new CancelException("Cancel requested.");
                }
                this.sleep();
            }
            ++stage;
        }
    }

    private void applyGenerations2(Session session, VirtualGraph vg, final Collection<GraphNode<Identifiable>> nodes, final IProgressMonitor monitor) throws Exception {
        session.syncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                try {
                    Mapper.this.applyGenerations(graph, nodes, monitor);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    private void collect(Session session) {
        if (COLLECT_BETWEEN_WRITES) {
            SessionGarbageCollection.gc(null, (Session)session, (boolean)true, null);
        }
    }

    private void sleep() {
        if (SLEEP_BETWEEN_WRITES) {
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void applyConnections(Session session, VirtualGraph vg, Collection<GraphNode<Identifiable>> nodes, IProgressMonitor monitor) throws Exception {
        int size = nodes.size();
        int count = 0;
        monitor.subTask("Generating connections (" + count + "/" + size + ")");
        final Iterator<GraphNode<Identifiable>> iter = nodes.iterator();
        while (iter.hasNext()) {
            int c = (Integer)session.syncRequest((WriteResult)new WriteResultRequest<Integer>(vg){

                public Integer perform(WriteGraph g) throws DatabaseException {
                    int j = 0;
                    try {
                        while (iter.hasNext() && j < OBJECTS_PER_TRANSACTION) {
                            GraphNode node = (GraphNode)((Object)iter.next());
                            Mapper.this.applyConnections(g, node);
                            ++j;
                        }
                        if (COLLECT_WITHIN_TRANSACTIONS) {
                            Mapper.this.collect((ReadGraph)g);
                        }
                        return j;
                    }
                    catch (Exception e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            });
            this.collect(session);
            monitor.subTask("Generating connections (" + (count += c) + "/" + size + ")");
            if (monitor.isCanceled()) {
                throw new CancelException("Cancel requested.");
            }
            this.sleep();
        }
    }

    private void applyConnections2(Session session, VirtualGraph vg, final Collection<GraphNode<Identifiable>> nodes, final IProgressMonitor monitor) throws Exception {
        session.syncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                try {
                    Mapper.this.applyConnections(graph, nodes, monitor);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    protected void applyModifications(ReadGraph g, GraphNode<Identifiable> n, Pair<IdentificationRule, ModificationRule> modRule, Collection<GraphNode<Identifiable>> ruleModified) throws Exception {
        if (!n.isDisposed() && ((IdentificationRule)modRule.first).matches(g, n)) {
            ArrayList<GraphNode<Identifiable>> perRule = new ArrayList<GraphNode<Identifiable>>();
            perRule.add(n);
            ruleModified.addAll(((ModificationRule)modRule.second).modify(g, perRule));
        }
    }

    protected void applyConnections(WriteGraph g, GraphNode<Identifiable> node) throws Exception {
        block0: for (Link<Identifiable> link : node.getLinks()) {
            if (!link.isMain()) continue;
            for (Pair<ConnectionIdentificationRule, ConnectionGenerationRule> r : this.connectionRules) {
                if (!((ConnectionIdentificationRule)r.first).mathces((ReadGraph)g, node, link.to(), link)) continue;
                LOGGER.info("Connecting " + this.getName((ReadGraph)g, node.getData()) + " to " + this.getName((ReadGraph)g, link.to().getData()) + " " + link.getName() + "/" + link.getInverseName());
                ((ConnectionGenerationRule)r.second).generate(g, node, link.to(), link);
                continue block0;
            }
        }
    }
}

