/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph.base;

import org.eclipse.core.runtime.ListenerList;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;

public abstract class Node
implements INode {
    public static transient long IDCOUNTER = 1L;
    protected transient ParentNode<?> parent = null;
    protected transient String parentName = null;
    protected Long id = IDCOUNTER++;
    protected ListenerList<NodeListener> listeners = new ListenerList();

    public Long getId() {
        return this.id;
    }

    @Override
    public ParentNode<?> getParent() {
        return this.parent;
    }

    @Override
    public String getParentRel() {
        return this.parentName;
    }

    @Override
    public void setParent(ParentNode<?> parent, String name) {
        this.parent = parent;
        this.parentName = name;
    }

    @Override
    public ParentNode<?> getRootNode() {
        return this.parent != null ? this.parent.getRootNode() : null;
    }

    @Override
    public void remove() {
        if (this.parent != null) {
            this.parent.removeNode(this.parentName, this);
        }
    }

    @Override
    public void deattach() {
        if (this.parent != null) {
            this.parent.deattachNode(this.parentName, this);
        }
    }

    public void init() {
    }

    @Override
    public void cleanup() {
        if (this.parent != null) {
            this.parent.removeNode(this.parentName, this);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void addListener(NodeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(NodeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public ListenerList<NodeListener> getListeners() {
        return this.listeners;
    }

    protected void firePropertyChanged(String id) {
        for (NodeListener listener : this.listeners) {
            listener.propertyChanged(this, id);
        }
    }
}

