/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.utils;

import java.util.ArrayList;
import java.util.List;
import org.simantics.g3d.vtk.Activator;
import org.simantics.g3d.vtk.preferences.CloseMethod;
import org.simantics.utils.threads.AWTThread;
import vtk.vtkCamera;
import vtk.vtkObject;
import vtk.vtkPanel;
import vtk.vtkReferenceInformation;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;

public class vtkPanelUtil {
    private static List<vtkPanel> activePanels = new ArrayList<vtkPanel>();
    private static List<vtkPanel> waitingToDeletePanels = new ArrayList<vtkPanel>();

    public static void registerPanel(vtkPanel panel) {
        activePanels.add(panel);
    }

    public static void unregisterPanel(vtkPanel panel) {
        assert (AWTThread.getThreadAccess().currentThreadAccess());
        if (!activePanels.remove(panel)) {
            return;
        }
        CloseMethod method = vtkPanelUtil.getCloseMethod();
        if (method == CloseMethod.ON_LAST_CLOSE) {
            waitingToDeletePanels.add(panel);
            if (activePanels.size() == 0) {
                vtkPanelUtil.cleanup();
            }
        } else if (method == CloseMethod.ON_CLOSE) {
            vtkPanelUtil.dPanel(panel);
            vtkPanelUtil.vtkGC();
        } else if (method == CloseMethod.NO_CLOSE) {
            waitingToDeletePanels.add(panel);
        }
    }

    public static CloseMethod getCloseMethod() {
        return CloseMethod.valueOf(Activator.getDefault().getPreferenceStore().getString("closeMethod"));
    }

    private static void cleanup() {
        for (vtkPanel p : waitingToDeletePanels) {
            vtkPanelUtil.dPanel(p);
        }
        waitingToDeletePanels.clear();
        vtkPanelUtil.vtkGC();
    }

    private static void vtkGC() {
        vtkReferenceInformation info = vtkObject.JAVA_OBJECT_MANAGER.gc(true);
        System.out.println("Referenced objects when closing editor: " + info.getTotalNumberOfObjects() + "\n");
        System.out.println(info.listRemovedReferenceToString());
        System.out.println(info.listKeptReferenceToString());
    }

    private static void dPanel(vtkPanel panel) {
        panel.lock();
        vtkCamera camera = panel.GetRenderer().GetActiveCamera();
        vtkRenderer ren = panel.GetRenderer();
        vtkRenderWindow win = panel.GetRenderWindow();
        win.SetForceMakeCurrent();
        panel.Delete();
        panel = null;
        camera.Delete();
        ren.Delete();
        win.Delete();
    }
}

