/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.swt;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.simantics.g3d.Activator;
import org.simantics.g3d.math.EulerTools;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.math.Ray;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.structural.IStructuralNode;
import org.simantics.g3d.toolbar.ToolComposite;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.gizmo.RotateAxisGizmo;
import org.simantics.g3d.vtk.swt.InteractiveVtkComposite;
import org.simantics.g3d.vtk.swt.vtkSwtAction;
import org.simantics.g3d.vtk.utils.vtkUtil;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkProp;

public class RotateAction
extends vtkSwtAction {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int P = 3;
    private VTKNodeMap<?, ? extends INode> nodeMap;
    private RotateAxisGizmo gizmo = new RotateAxisGizmo();
    private IG3DNode node;
    private Cursor activeCursor;
    private Cursor dragCursor;
    int stepMethod = 1;
    EulerTools.Order order = EulerTools.Order.YXZ;
    private int steps;
    private double[] angles;
    int index = 3;
    boolean valid = false;
    private boolean worldCoord = true;
    private Quat4d parentWorldOrientation = null;
    Quat4d worldOrientation = new Quat4d();
    protected ToolComposite toolComposite;
    protected Combo axisCombo;
    Vector3d axis = null;
    private double prevS = 0.0;
    private Vector3d i = new Vector3d();
    private Vector3d j = new Vector3d();
    private double prevAngle = 0.0;
    InputType inputType;
    private boolean useStep = false;

    public void setNode(IG3DNode node) {
        this.node = node;
        if (node instanceof IStructuralNode && ((IStructuralNode)node).isPartOfInstantiatedModel() && !((IStructuralNode)node).isInstantiatedModelRoot()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        String set = Activator.getDefault().getPreferenceStore().getString("orientationPresentationPreference");
        if (set.equals("aa")) {
            this.stepMethod = 0;
        } else if (set.equals("euler")) {
            this.stepMethod = 1;
            String eulerOrder = Activator.getDefault().getPreferenceStore().getString("eulerAngleOrderPreference");
            try {
                this.order = EulerTools.Order.valueOf((String)eulerOrder);
            }
            catch (Exception e) {
                this.order = EulerTools.Order.YXZ;
            }
        } else {
            this.stepMethod = 2;
        }
    }

    public IG3DNode getNode() {
        return this.node;
    }

    public RotateAction(InteractiveVtkComposite panel, VTKNodeMap<?, ? extends INode> nodeMap, ToolComposite toolComposite) {
        super(panel);
        this.setImageDescriptor(org.simantics.g3d.vtk.Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/arrow_rotate_clockwise.png"));
        this.setText("Rotate");
        this.nodeMap = nodeMap;
        this.toolComposite = toolComposite;
        this.steps = 36;
        this.angles = new double[this.steps + 1];
        int i = 0;
        while (i < this.angles.length) {
            this.angles[i] = -Math.PI + Math.PI * (double)i * 2.0 / (double)this.steps;
            ++i;
        }
        this.activeCursor = Display.getCurrent().getSystemCursor(21);
        this.dragCursor = Display.getCurrent().getSystemCursor(2);
    }

    protected void createTools(ToolComposite toolComposite) {
        Label label = new Label((Composite)toolComposite, 8);
        label.setText("Rotate axis:");
        this.axisCombo = new Combo((Composite)toolComposite, 8);
        this.axisCombo.add("X");
        this.axisCombo.add("Y");
        this.axisCombo.add("Z");
        this.axisCombo.add("Camera");
        this.axisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo c = (Combo)e.getSource();
                RotateAction.this.index = c.getSelectionIndex();
                RotateAction.this.updateLock();
                RotateAction.this.panel.getComponent().setFocus();
            }
        });
        this.axisCombo.select(this.index);
        Button close = new Button((Composite)toolComposite, 8);
        close.setText("Close");
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RotateAction.this.panel.useDefaultAction();
            }
        });
        toolComposite.relayout();
    }

    @Override
    public void attach() {
        if (this.node == null) {
            return;
        }
        if (this.toolComposite != null) {
            this.createTools(this.toolComposite);
        }
        super.attach();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                RotateAction.this.attachUI();
                RotateAction.this.update();
            }
        });
        this.setDBUndo(false);
    }

    @Override
    public void deattach() {
        this.setDBUndo(true);
        if (this.toolComposite != null) {
            this.toolComposite.clear();
            this.axisCombo = null;
        }
        this.node = null;
        this.nodeMap.commit("Rotate");
        this.deattachUI();
        super.deattach();
        this.panel.refresh();
    }

    private void attachUI() {
        this.panel.getComponent().setCursor(this.activeCursor);
        this.gizmo.attach(this.panel);
    }

    private void deattachUI() {
        this.panel.getComponent().setCursor(Display.getCurrent().getSystemCursor(0));
        this.gizmo.deattach();
    }

    @Override
    public boolean keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.panel.useDefaultAction();
        }
        if (this.valid) {
            return true;
        }
        if (e.getKeyCode() == 88) {
            this.index = this.index != 0 ? 0 : 3;
        }
        if (e.getKeyCode() == 89) {
            this.index = this.index != 1 ? 1 : 3;
        }
        if (e.getKeyCode() == 90) {
            this.index = this.index != 2 ? 2 : 3;
        }
        if (e.getKeyCode() == 71) {
            this.worldCoord = !this.worldCoord;
        }
        this.updateLock();
        return true;
    }

    private void updateLock() {
        this.gizmo.setType(this.index);
        if (this.axisCombo != null) {
            this.axisCombo.select(this.index);
        }
        this.panel.refresh();
    }

    @Override
    public boolean keyReleased(KeyEvent e) {
        return false;
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            if (this.isOverNode(e)) {
                return true;
            }
            this.panel.useDefaultAction();
            return true;
        }
        return false;
    }

    public void setWorldCoord(boolean b) {
        if (this.worldCoord == b) {
            return;
        }
        this.worldCoord = b;
        this.update();
    }

    private void update() {
        Vector3d nodePos = this.node.getWorldPosition();
        this.gizmo.setPosition((Tuple3d)nodePos);
        if (this.worldCoord) {
            this.gizmo.setRotation(new AxisAngle4d());
            this.parentWorldOrientation = null;
        } else {
            AxisAngle4d aa = new AxisAngle4d();
            this.parentWorldOrientation = ((IG3DNode)this.node.getParent()).getWorldOrientation();
            aa.set(this.parentWorldOrientation);
            this.gizmo.setRotation(aa);
        }
        Point3d camPos = new Point3d(this.panel.getRenderer().GetActiveCamera().GetPosition());
        Vector3d p = new Vector3d(nodePos);
        p.sub((Tuple3d)camPos);
        if (this.parentWorldOrientation != null) {
            Quat4d qi = new Quat4d(this.parentWorldOrientation);
            qi.inverse();
            MathTools.rotate((Quat4d)this.parentWorldOrientation, (Tuple3d)p, (Tuple3d)p);
        }
        if (this.panel.getRenderer().GetActiveCamera().GetParallelProjection() == 0) {
            double distance = p.length();
            p.negate();
            double fov = this.panel.getRenderer().GetActiveCamera().GetViewAngle();
            float s = (float)(Math.sin(fov) * distance * 0.1);
            Vector3d scale = new Vector3d(1.0, 1.0, 1.0);
            scale.scale((double)s);
            this.gizmo.setScale((Tuple3d)scale);
        } else {
            Vector3d scale = new Vector3d(1.0, 1.0, 1.0);
            double s = this.panel.getRenderer().GetActiveCamera().GetParallelScale() / 5.0;
            scale.scale(s);
            this.gizmo.setScale((Tuple3d)scale);
        }
        this.panel.refresh();
    }

    private boolean isOverNode(MouseEvent e) {
        vtkProp[] picked = this.panel.pick(e.getX(), e.getY());
        if (picked != null) {
            int i = 0;
            while (i < picked.length) {
                if (this.node.equals(this.nodeMap.getNode(picked[i]))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.isOverNode(e)) {
                this.valid = true;
                this.useStep = (e.getModifiers() & 2) > 0;
                this.worldOrientation = this.node.getWorldOrientation();
                this.doChanges(true, e.getX(), e.getY());
                this.panel.getComponent().setCursor(this.dragCursor);
            } else {
                this.valid = false;
                this.getDefaultAction().mousePressed(e);
                this.panel.getComponent().setCursor(this.activeCursor);
            }
        } else {
            this.getDefaultAction().mousePressed(e);
        }
        return true;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.valid = false;
            this.worldOrientation = null;
            this.panel.getComponent().setCursor(this.activeCursor);
        } else {
            this.getDefaultAction().mouseReleased(e);
        }
        return true;
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) > 0 && this.valid) {
            this.useStep = (e.getModifiers() & 2) > 0;
            this.doChanges(false, e.getX(), e.getY());
            this.update();
        } else {
            this.getDefaultAction().mouseDragged(e);
            this.update();
        }
        return true;
    }

    @Override
    public boolean keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            this.inputType = InputType.KEY;
            this.axis = new Vector3d(0.0, 1.0, 0.0);
        } else if (e.getKeyCode() == 39) {
            this.inputType = InputType.KEY;
            this.axis = new Vector3d(0.0, -1.0, 0.0);
        } else if (e.getKeyCode() == 38) {
            this.inputType = InputType.KEY;
            this.axis = new Vector3d(1.0, 0.0, 0.0);
        } else if (e.getKeyCode() == 40) {
            this.inputType = InputType.KEY;
            this.axis = new Vector3d(-1.0, 0.0, 0.0);
        }
        return true;
    }

    public void doChanges(boolean pressed, int x, int y) {
        AxisAngle4d aa;
        AxisAngle4d rot;
        Vector3d i2;
        double[] s;
        Vector3d axis;
        Ray ray = vtkUtil.createMouseRay(this.panel.getRenderer(), x, y);
        Vector3d p = this.node.getWorldPosition();
        if (pressed && (axis = this.getRotationAxis()) != null) {
            if (!this.worldCoord) {
                MathTools.rotate((Quat4d)this.parentWorldOrientation, (Tuple3d)axis, (Tuple3d)axis);
            }
            s = new double[2];
            i2 = new Vector3d();
            boolean intersect = MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)axis, (Vector3d)i2, (double[])s);
            double dot = Math.abs(ray.dir.dot(axis));
            this.inputType = intersect && dot > 0.4 ? InputType.INTERSECT : InputType.NONINTERSECT;
            if (this.inputType == InputType.INTERSECT) {
                i2.sub((Tuple3d)p);
                this.j.set((Tuple3d)i2);
                this.i.cross(this.j, axis);
                double angleI = i2.angle(this.i);
                double angleJ = i2.angle(this.j);
                this.prevAngle = Math.atan2(Math.cos(angleJ), Math.cos(angleI));
            } else {
                this.i.cross(ray.dir, axis);
                MathTools.intersectStraightStraight((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)this.i, (Tuple3d)new Vector3d(), (Tuple3d)new Vector3d(), (double[])s);
                this.prevS = s[1];
            }
        }
        if (this.inputType != InputType.KEY) {
            this.axis = this.getRotationAxis();
        }
        if (this.axis == null) {
            return;
        }
        Vector3d taxis = null;
        if (!this.worldCoord) {
            taxis = new Vector3d(this.axis);
            MathTools.rotate((Quat4d)this.parentWorldOrientation, (Tuple3d)this.axis, (Tuple3d)this.axis);
        }
        if (this.inputType == InputType.INTERSECT) {
            s = new double[2];
            i2 = new Vector3d();
            MathTools.intersectStraightPlane((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)this.axis, (Vector3d)i2, (double[])s);
            i2.sub((Tuple3d)p);
            double angleI = i2.angle(this.i);
            double angleJ = i2.angle(this.j);
            double angle = Math.atan2(Math.cos(angleJ), Math.cos(angleI));
            if (!this.worldCoord) {
                this.axis = taxis;
            }
            if (this.useStep) {
                AxisAngle4d rot2 = new AxisAngle4d(this.axis, angle - this.prevAngle);
                Quat4d qrot = new Quat4d();
                MathTools.getQuat((AxisAngle4d)rot2, (Quat4d)qrot);
                qrot.mulInverse(this.worldOrientation);
                if (this.stepMethod == 0) {
                    rot2.set(qrot);
                    rot2.angle = this.roundAngle(rot2.angle);
                    MathTools.getQuat((AxisAngle4d)rot2, (Quat4d)qrot);
                    this.setOrientation(qrot);
                } else if (this.stepMethod == 1) {
                    Vector3d euler = EulerTools.getEulerFromQuat((EulerTools.Order)this.order, (Quat4d)qrot);
                    euler.x = this.roundAngle(euler.x);
                    euler.y = this.roundAngle(euler.y);
                    euler.z = this.roundAngle(euler.z);
                    Quat4d q = EulerTools.getQuatFromEuler((EulerTools.Order)this.order, (Vector3d)euler);
                    this.setOrientation(q);
                } else {
                    this.setOrientation(qrot);
                }
            } else {
                if (this.worldCoord) {
                    AxisAngle4d aa2 = MathTools.getAxisAngle((Quat4d)this.node.getWorldOrientation());
                    AxisAngle4d rot3 = new AxisAngle4d(this.axis, angle - this.prevAngle);
                    MathTools.multiplyOrientation((AxisAngle4d)aa2, (AxisAngle4d)rot3);
                    this.setWorldOrientation(MathTools.getQuat((AxisAngle4d)rot3));
                } else {
                    AxisAngle4d aa3 = MathTools.getAxisAngle((Quat4d)this.node.getOrientation());
                    AxisAngle4d rot4 = new AxisAngle4d(this.axis, angle - this.prevAngle);
                    MathTools.multiplyOrientation((AxisAngle4d)aa3, (AxisAngle4d)rot4);
                    this.setOrientation(MathTools.getQuat((AxisAngle4d)rot4));
                }
                this.prevAngle = angle;
            }
        } else if (this.inputType == InputType.NONINTERSECT) {
            s = new double[2];
            MathTools.intersectStraightStraight((Tuple3d)ray.pos, (Vector3d)ray.dir, (Tuple3d)p, (Vector3d)this.i, (Tuple3d)new Vector3d(), (Tuple3d)new Vector3d(), (double[])s);
            if (!this.worldCoord) {
                this.axis = taxis;
            }
            if (this.useStep) {
                rot = new AxisAngle4d(this.axis, s[1] - this.prevS);
                Quat4d qrot = new Quat4d();
                MathTools.getQuat((AxisAngle4d)rot, (Quat4d)qrot);
                qrot.mulInverse(this.worldOrientation);
                if (this.stepMethod == 0) {
                    rot.set(qrot);
                    rot.angle = this.roundAngle(rot.angle);
                    MathTools.getQuat((AxisAngle4d)rot, (Quat4d)qrot);
                    this.setOrientation(qrot);
                } else if (this.stepMethod == 1) {
                    Vector3d euler = EulerTools.getEulerFromQuat((EulerTools.Order)this.order, (Quat4d)qrot);
                    euler.x = this.roundAngle(euler.x);
                    euler.y = this.roundAngle(euler.y);
                    euler.z = this.roundAngle(euler.z);
                    Quat4d q = EulerTools.getQuatFromEuler((EulerTools.Order)this.order, (Vector3d)euler);
                    this.setOrientation(q);
                } else {
                    this.setOrientation(qrot);
                }
                this.prevS = s[1];
            } else {
                AxisAngle4d aa4;
                if (this.worldCoord) {
                    aa4 = MathTools.getAxisAngle((Quat4d)this.node.getWorldOrientation());
                    AxisAngle4d rot5 = new AxisAngle4d(this.axis, s[1] - this.prevS);
                    MathTools.multiplyOrientation((AxisAngle4d)aa4, (AxisAngle4d)rot5);
                    this.setWorldOrientation(MathTools.getQuat((AxisAngle4d)rot5));
                } else {
                    aa4 = MathTools.getAxisAngle((Quat4d)this.node.getOrientation());
                    AxisAngle4d rot6 = new AxisAngle4d(this.axis, s[1] - this.prevS);
                    MathTools.multiplyOrientation((AxisAngle4d)aa4, (AxisAngle4d)rot6);
                    this.setOrientation(MathTools.getQuat((AxisAngle4d)rot6));
                }
                this.prevS = s[1];
            }
        } else if (this.worldCoord) {
            aa = MathTools.getAxisAngle((Quat4d)this.node.getWorldOrientation());
            rot = new AxisAngle4d(this.axis, 1.5707963267948966);
            MathTools.multiplyOrientation((AxisAngle4d)aa, (AxisAngle4d)rot);
            this.setWorldOrientation(MathTools.getQuat((AxisAngle4d)rot));
        } else {
            aa = MathTools.getAxisAngle((Quat4d)this.node.getOrientation());
            rot = new AxisAngle4d(this.axis, 1.5707963267948966);
            MathTools.multiplyOrientation((AxisAngle4d)aa, (AxisAngle4d)rot);
            this.setOrientation(MathTools.getQuat((AxisAngle4d)rot));
        }
    }

    protected void setOrientation(Quat4d q) {
        this.node.setOrientation(q);
    }

    protected void setWorldOrientation(Quat4d q) {
        this.node.setWorldOrientation(q);
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return this.getDefaultAction().mouseMoved(e);
    }

    private Vector3d getRotationAxis() {
        switch (this.index) {
            case 0: {
                return new Vector3d(1.0, 0.0, 0.0);
            }
            case 1: {
                return new Vector3d(0.0, 1.0, 0.0);
            }
            case 2: {
                return new Vector3d(0.0, 0.0, 1.0);
            }
            case 3: {
                Vector3d axis = new Vector3d(this.panel.getRenderer().GetActiveCamera().GetDirectionOfProjection());
                axis.normalize();
                return axis;
            }
        }
        return null;
    }

    private double roundAngle(double angle) {
        double d2;
        double d;
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        int index = 0;
        while (angle > this.angles[index]) {
            ++index;
        }
        angle = index == 0 ? this.angles[0] : ((d = angle - this.angles[index - 1]) < (d2 = this.angles[index] - angle) ? this.angles[index - 1] : this.angles[index]);
        return angle;
    }

    static enum InputType {
        INTERSECT,
        NONINTERSECT,
        KEY,
        NONE;

    }
}

