/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import org.simantics.g3d.shape.Mesh;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.shape.MeshActor;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import vtk.vtkProp;
import vtk.vtkRenderer;

public class vtkMeshObject {
    private VtkView panel;
    private Mesh mesh;
    private MeshActor meshActor;

    public vtkMeshObject(VtkView panel, Mesh mesh) {
        this.mesh = mesh;
        this.panel = panel;
    }

    public void visualizeMesh() {
        this.clearActorsVTK();
        this.meshActor = new MeshActor();
        this.meshActor.setMesh(this.mesh);
        this.showActorsVTK();
    }

    public MeshActor getActor() {
        assert (Thread.currentThread() == this.panel.getThreadQueue().getThread());
        return this.meshActor;
    }

    public void showActorsVTK() {
        assert (Thread.currentThread() == this.panel.getThreadQueue().getThread());
        this.panel.lock();
        vtkRenderer ren = this.panel.getRenderer();
        if (this.meshActor != null) {
            ren.AddActor((vtkProp)this.meshActor);
        }
        this.panel.unlock();
    }

    public void showActors() {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkMeshObject.this.showActorsVTK();
            }
        });
    }

    public void clearActorsVTK() {
        assert (Thread.currentThread() == this.panel.getThreadQueue().getThread());
        if (this.meshActor == null) {
            return;
        }
        vtkRenderer ren = this.panel.getRenderer();
        if (ren == null) {
            return;
        }
        this.panel.lock();
        if (this.meshActor.GetVTKId() != 0L) {
            ren.RemoveActor((vtkProp)this.meshActor);
            this.meshActor.Delete();
        }
        this.panel.unlock();
        this.meshActor = null;
    }

    private void clearActorsVTK(MeshActor meshActor) {
        assert (Thread.currentThread() == this.panel.getThreadQueue().getThread());
        if (meshActor == null) {
            return;
        }
        vtkRenderer ren = this.panel.getRenderer();
        if (ren == null) {
            return;
        }
        this.panel.lock();
        if (meshActor.GetVTKId() != 0L) {
            ren.RemoveActor((vtkProp)meshActor);
            meshActor.Delete();
        }
        this.panel.unlock();
        meshActor = null;
    }

    public void clearActors() {
        if (this.meshActor == null) {
            return;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                vtkMeshObject.this.clearActorsVTK(vtkMeshObject.this.meshActor);
            }
        });
    }

    public void dispose() {
        this.mesh = null;
        this.clearActors();
    }

    public void delete() {
        this.mesh = null;
        this.clearActorsVTK();
    }
}

