/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.shape;

import javax.vecmath.Tuple3d;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.shape.Mesh;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkFloatArray;
import vtk.vtkIdList;
import vtk.vtkMapper;
import vtk.vtkPointData;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;
import vtk.vtkTriangle;
import vtk.vtkUnsignedCharArray;

public class MeshActor
extends vtkActor {
    public static vtkPolyData createPolyData(Mesh mesh) {
        vtkPolyData polyData = new vtkPolyData();
        polyData.Allocate((long)(mesh.getIndices().size() / 3), mesh.getIndices().size() / 3);
        vtkTriangle triangle = new vtkTriangle();
        vtkIdList list = triangle.GetPointIds();
        int i = 0;
        while (i < mesh.getIndices().size()) {
            list.SetId(0L, (long)((Integer)mesh.getIndices().get(i)).intValue());
            list.SetId(1L, (long)((Integer)mesh.getIndices().get(i + 1)).intValue());
            list.SetId(2L, (long)((Integer)mesh.getIndices().get(i + 2)).intValue());
            polyData.InsertNextCell(triangle.GetCellType(), list);
            i += 3;
        }
        list.Delete();
        triangle.Delete();
        vtkPoints points = new vtkPoints();
        int i2 = 0;
        while (i2 < mesh.getVertices().size()) {
            Tuple3d p = (Tuple3d)mesh.getVertices().get(i2);
            points.InsertPoint((long)i2, p.x, p.y, p.z);
            ++i2;
        }
        polyData.SetPoints(points);
        points.Delete();
        if (mesh.getNormals() != null) {
            vtkFloatArray normals = new vtkFloatArray();
            normals.SetNumberOfComponents(3);
            normals.SetNumberOfTuples((long)mesh.getNormals().size());
            int i3 = 0;
            while (i3 < mesh.getNormals().size()) {
                Tuple3d p = (Tuple3d)mesh.getNormals().get(i3);
                normals.InsertTuple3((long)i3, p.x, p.y, p.z);
                ++i3;
            }
            vtkPointData pointData = polyData.GetPointData();
            pointData.SetNormals((vtkDataArray)normals);
            normals.Delete();
            pointData.Delete();
        }
        if (mesh.getColors() != null) {
            vtkUnsignedCharArray colors = new vtkUnsignedCharArray();
            colors.SetName("Colors");
            colors.SetNumberOfComponents(3);
            colors.SetNumberOfTuples((long)mesh.getColors().size());
            int i4 = 0;
            while (i4 < mesh.getColors().size()) {
                Color4d c = (Color4d)mesh.getColors().get(i4);
                colors.InsertTuple3((long)i4, 255.0 * c.x, 255.0 * c.y, 255.0 * c.z);
                ++i4;
            }
            polyData.GetPointData().AddArray((vtkAbstractArray)colors);
            colors.Delete();
        }
        return polyData;
    }

    public void setMesh(Mesh mesh) {
        vtkPolyDataMapper mapper = new vtkPolyDataMapper();
        vtkPolyData polyData = MeshActor.createPolyData(mesh);
        if (mesh.getNormals() == null) {
            vtkPolyDataNormals normals = new vtkPolyDataNormals();
            normals.SetInputData((vtkDataObject)polyData);
            normals.ComputePointNormalsOn();
            mapper.SetInputConnection(normals.GetOutputPort());
            normals.GetOutputPort().Delete();
            normals.Delete();
        } else {
            mapper.SetInputData(polyData);
        }
        if (mesh.getColors() != null) {
            mapper.ScalarVisibilityOn();
            mapper.SetScalarModeToUsePointFieldData();
            mapper.SelectColorArray("Colors");
        }
        this.SetMapper((vtkMapper)mapper);
        mapper.Delete();
        polyData.GetPointData().Delete();
        polyData.Delete();
    }

    public void Delete() {
        super.Delete();
    }
}

