/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.common;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.g3d.scenegraph.NodeMapListener;
import org.simantics.g3d.scenegraph.RenderListener;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.IMappingListener;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vtk.vtkProp;

public abstract class AbstractVTKNodeMap<DBObject, E extends INode>
implements VTKNodeMap<DBObject, E>,
IMappingListener,
RenderListener,
NodeListener,
UndoRedoSupport.ChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVTKNodeMap.class);
    protected Session session;
    protected IMapping<DBObject, INode> mapping;
    protected VtkView view;
    private MapList<E, vtkProp> nodeToActor = new MapList();
    private Map<vtkProp, E> actorToNode = new HashMap<vtkProp, E>();
    protected ParentNode<E> rootNode;
    protected Object editMutex = new Object();
    protected UndoRedoSupport undoRedoSupport;
    protected int undoOpCount = 0;
    protected int redoOpCount = 0;
    protected boolean runUndo = false;
    protected boolean runRedo = false;
    private boolean changeTracking = true;
    protected Object syncMutex = new Object();
    private List<Pair<E, String>> added = new ArrayList<Pair<E, String>>();
    private List<Pair<E, String>> removed = new ArrayList<Pair<E, String>>();
    private MapSet<E, String> updated = new MapSet.Hash();
    private List<E> mapToRemove = new ArrayList();
    private boolean rangeModified = false;
    private boolean graphUpdates = false;
    private Set<E> graphModified = new HashSet();
    private boolean requestCommit = false;
    private String commitMessage = null;
    private boolean useFullSyncWithUndo = false;
    List<Pair<E, String>> rem = new ArrayList<Pair<E, String>>();
    List<Pair<E, String>> add = new ArrayList<Pair<E, String>>();
    MapSet<E, String> mod = new MapSet.Hash();
    Set<E> propagation = new HashSet();
    Stack<E> stack = new Stack();
    private List<NodeListener> nodeListeners = new ArrayList<NodeListener>();
    private List<NodeMapListener> nodeMaplisteners = new ArrayList<NodeMapListener>();
    List<NodeMapListener> tempListenerlist = new ArrayList<NodeMapListener>();

    public AbstractVTKNodeMap(Session session, IMapping<DBObject, INode> mapping, VtkView view, ParentNode<E> rootNode) {
        this.session = session;
        this.mapping = mapping;
        this.view = view;
        this.rootNode = rootNode;
        view.addListener(this);
        mapping.addMappingListener((IMappingListener)this);
        rootNode.addListener((NodeListener)this);
        this.undoRedoSupport = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        this.undoRedoSupport.subscribe((UndoRedoSupport.ChangeListener)this);
        try {
            UndoContext undoContext = this.undoRedoSupport.getUndoContext(session);
            this.undoOpCount = undoContext.getAll().size();
            this.redoOpCount = undoContext.getRedoList().size();
        }
        catch (DatabaseException e) {
            LOGGER.error("Error reading from undo context", (Throwable)e);
        }
    }

    protected abstract void addActor(E var1);

    protected abstract void removeActor(E var1);

    protected abstract void updateActor(E var1, Set<String> var2);

    public void repaint() {
        this.view.refresh();
    }

    public void populate() {
        for (INode node : this.rootNode.getNodes()) {
            this.receiveAdd(node, node.getParentRel(), true);
        }
        this.repaint();
    }

    public E getNode(vtkProp prop) {
        return (E)((INode)this.actorToNode.get(prop));
    }

    public Collection<vtkProp> getRenderObjects(INode node) {
        return this.nodeToActor.getValues((Object)node);
    }

    protected <T extends vtkProp> void map(E node, Collection<T> props) {
        for (vtkProp p : props) {
            this.nodeToActor.add(node, (Object)p);
            this.actorToNode.put(p, node);
        }
    }

    protected void removeMap(E node) {
        ArrayList coll = new ArrayList(this.nodeToActor.getValuesUnsafe(node));
        this.nodeToActor.remove(node);
        if (coll.size() > 0) {
            this.view.lock();
            for (vtkProp p : coll) {
                this.actorToNode.remove(p);
                if (p.GetVTKId() == 0L) continue;
                this.view.getRenderer().RemoveActor(p);
                p.Delete();
            }
            this.view.unlock();
        }
    }

    public ParentNode<E> getRootNode() {
        return this.rootNode;
    }

    public boolean isChangeTracking() {
        return this.changeTracking;
    }

    public void setChangeTracking(boolean enabled) {
        this.changeTracking = enabled;
    }

    public boolean isRangeModified() {
        return this.rangeModified;
    }

    public void onChanged() {
        try {
            UndoContext undoContext = this.undoRedoSupport.getUndoContext(this.session);
            int ucount = undoContext.getAll().size();
            int rcount = undoContext.getRedoList().size();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Previous U:" + this.undoOpCount + " R:" + this.redoOpCount + " Current U:" + ucount + " R:" + rcount);
            }
            this.runUndo = ucount < this.undoOpCount;
            this.runRedo = !this.runUndo && rcount > 0;
            this.undoOpCount = ucount;
            this.redoOpCount = rcount;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Undo " + this.runUndo + " Redo " + this.runRedo);
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Error resolving undo/redo information", (Throwable)e);
        }
    }

    public void updateRenderObjectsFor(E node) {
        ArrayList<vtkProp> toDelete = new ArrayList<vtkProp>();
        this.view.lock();
        for (vtkProp prop : this.nodeToActor.getValues(node)) {
            if (prop.GetVTKId() != 0L) {
                this.view.getRenderer().RemoveActor(prop);
                toDelete.add(prop);
            }
            this.actorToNode.remove(prop);
        }
        this.view.unlock();
        this.nodeToActor.remove(node);
        Collection<vtkProp> coll = this.getActors(node);
        if (coll != null) {
            for (vtkProp prop : coll) {
                this.nodeToActor.add(node, (Object)prop);
                this.actorToNode.put(prop, node);
                toDelete.remove(prop);
            }
        }
        for (vtkProp p : toDelete) {
            p.Delete();
        }
    }

    protected abstract Collection<vtkProp> getActors(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAdd(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveAdd " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.added) {
                if (!((INode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking) {
                this.mapping.rangeModified((Object)node.getParent());
                this.mapping.rangeModified(node);
            }
            this.added.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveRemove(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveRemove " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            for (Pair<E, String> n : this.removed) {
                if (!((INode)n.first).equals(node)) continue;
                return;
            }
            if (this.changeTracking && !db) {
                this.mapping.rangeModified(node);
                this.mapping.rangeModified((Object)node.getParent());
            }
            this.removed.add(new Pair(node, (Object)id));
            this.rangeModified = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveUpdate(E node, String id, boolean db) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("receiveUpdate " + this.debugString(node) + " " + id + " " + db);
        }
        Object object = this.syncMutex;
        synchronized (object) {
            if (this.changeTracking && !db) {
                this.mapping.rangeModified(node);
            }
            this.updated.add(node, (Object)id);
            this.rangeModified = true;
        }
        this.repaint();
    }

    public void commit(String message) {
        this.requestCommit = true;
        this.commitMessage = message;
    }

    protected void doCommit() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IRunnableWithProgress runnable = monitor -> {
            monitor.beginTask("Commit pipeline changes", -1);
            try {
                try {
                    this.session.syncRequest(graph -> this.doCommit(graph));
                }
                catch (DatabaseException e) {
                    LOGGER.error("Cannot commit editor changes", (Throwable)e);
                    ExceptionUtils.logAndShowError((String)"Cannot commit editor changes", (Throwable)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window != null) {
                window.run(true, false, runnable);
            } else {
                workbench.getProgressService().busyCursorWhile(runnable);
            }
            this.postCommit();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.error("Unexpected exception", (Throwable)e);
        }
    }

    protected void postCommit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(WriteGraph graph) throws DatabaseException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Commit " + this.commitMessage);
        }
        if (this.commitMessage != null) {
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)this.commitMessage);
            graph.markUndoPoint();
            this.commitMessage = null;
        }
        Object object = this.editMutex;
        synchronized (object) {
            this.commit(graph);
            this.fireCommit(graph);
            for (INode o : this.mapToRemove) {
                this.mapping.getRange().remove(o);
            }
            this.mapToRemove.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(WriteGraph graph) throws DatabaseException {
        Object object = this.syncMutex;
        synchronized (object) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Commit");
            }
            this.graphUpdates = true;
            this.mapping.updateDomain(graph);
            this.graphUpdates = false;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Commit done");
            }
        }
    }

    public void domainModified() {
        if (this.graphUpdates) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("domainModified");
        }
        this.session.asyncRequest((Read)new UniqueRead<Object>(){

            public Object perform(ReadGraph graph) throws DatabaseException {
                return new Object();
            }
        }, (SyncProcedure)new SyncProcedure<Object>(){

            public void execute(ReadGraph graph, Object result) throws DatabaseException {
                AbstractVTKNodeMap.this.update(graph);
            }

            public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
                LOGGER.error("Failed to update pipeline changes" + String.valueOf(throwable));
            }
        });
    }

    protected void reset(ReadGraph graph) throws MappingException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Reset");
        }
        this.graphUpdates = true;
        this.mapping.getRangeModified().clear();
        for (Object o : this.mapping.getDomain()) {
            this.mapping.domainModified(o);
        }
        this.mapping.updateRange(graph);
        this.graphModified.clear();
        this.graphUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ReadGraph graph) throws DatabaseException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Graph update start");
        }
        if (this.runUndo && this.useFullSyncWithUndo) {
            Object object = this.syncMutex;
            synchronized (object) {
                this.reset(graph);
            }
        }
        Object object = this.syncMutex;
        synchronized (object) {
            this.graphUpdates = true;
            for (Object domainObject : this.mapping.getDomainModified()) {
                INode rangeObject = (INode)this.mapping.get(domainObject);
                if (rangeObject == null) continue;
                this.graphModified.add(rangeObject);
            }
        }
        this.mapping.updateRange(graph);
        object = this.syncMutex;
        synchronized (object) {
            this.graphModified.clear();
        }
        this.graphUpdates = false;
        if (this.mapping.isRangeModified() && !this.runUndo && !this.runRedo) {
            this.commit((String)null);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Graph update done");
        }
    }

    public void rangeModified() {
    }

    public void postRender() {
        if (this.requestCommit && !this.rangeModified) {
            this.requestCommit = false;
            SWTThread.getThreadAccess().asyncExec(() -> this.doCommit());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preRender() {
        Object object = this.editMutex;
        synchronized (object) {
            this.updateCycle();
        }
    }

    protected String debugString(E n) {
        return String.valueOf(n) + "@" + Integer.toHexString(n.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCycle() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Update cycle");
        }
        this.rem.clear();
        this.add.clear();
        this.mod.clear();
        this.propagation.clear();
        Object object = this.syncMutex;
        synchronized (object) {
            this.collectModifications(this.rem, this.add, this.mod);
        }
        AbstractVTKNodeMap.filterAddRemove(this.rem, this.add, this.mod);
        for (Pair<E, String> n : this.rem) {
            this.handleRemoved(n);
        }
        for (Pair<E, String> n : this.add) {
            this.handleAdded(n);
        }
        for (INode e : this.mod.getKeys()) {
            AbstractVTKNodeMap.collectPositionChanges(e, this.mod.getValues((Object)e), this.propagation);
        }
        if (this.propagation.size() > 0) {
            this.propagatePositionUpdates(this.propagation);
        }
        for (INode e : this.mod.getKeys()) {
            this.updateActor(e, this.mod.getValues((Object)e));
        }
        this.fireNodeListeners(this.rem, this.add, this.mod);
        object = this.syncMutex;
        synchronized (object) {
            if (this.added.isEmpty() && this.removed.isEmpty() && this.updated.getKeys().size() == 0) {
                this.rangeModified = false;
            }
        }
    }

    private void fireNodeListeners(List<Pair<E, String>> rem, List<Pair<E, String>> add, MapSet<E, String> mod) {
        for (NodeListener l : this.nodeListeners) {
            for (Pair<E, String> n : rem) {
                l.nodeRemoved(null, (INode)n.first, (String)n.second);
            }
            for (Pair<E, String> n : add) {
                l.nodeAdded(((INode)n.first).getParent(), (INode)n.first, (String)n.second);
            }
            for (INode e : mod.getKeys()) {
                for (String s : mod.getValues((Object)e)) {
                    l.propertyChanged(e, s);
                }
            }
        }
    }

    private void propagatePositionUpdates(Set<E> propagation) {
        this.stack.clear();
        this.stack.addAll(propagation);
        propagation.clear();
        while (!this.stack.isEmpty()) {
            INode node = (INode)this.stack.pop();
            if (propagation.contains(node)) continue;
            propagation.add(node);
            for (NodeListener l : node.getListeners()) {
                if (l == this) continue;
                l.propertyChanged(node, "http://www.simantics.org/G3D-0.1/hasWorldPosition");
            }
            if (!(node instanceof ParentNode)) continue;
            this.stack.addAll(((ParentNode)node).getNodes());
        }
    }

    private void collectModifications(List<Pair<E, String>> rem, List<Pair<E, String>> add, MapSet<E, String> mod) {
        rem.addAll(this.removed);
        add.addAll(this.added);
        for (INode e : this.updated.getKeys()) {
            for (String s : this.updated.getValues((Object)e)) {
                mod.add((Object)e, (Object)s);
            }
        }
        this.removed.clear();
        this.added.clear();
        this.updated.clear();
    }

    private void handleRemoved(Pair<E, String> n) {
        this.stopListening((INode)n.first);
        this.removeActor((INode)n.first);
        ((INode)n.first).remove();
        this.mapToRemove.add((INode)n.first);
    }

    private void handleAdded(Pair<E, String> n) {
        this.addActor((INode)n.first);
        this.listen((INode)n.first);
    }

    private static <E extends INode> void collectPositionChanges(E e, Set<String> ids, Set<E> propagation) {
        if ((ids.contains("http://www.simantics.org/G3D-0.1/hasPosition") || ids.contains("http://www.simantics.org/G3D-0.1/hasOrientation")) && !propagation.contains(e)) {
            propagation.add(e);
        }
    }

    private static <E extends INode> void filterAddRemove(List<Pair<E, String>> rem, List<Pair<E, String>> add, MapSet<E, String> mod) {
        Pair<E, String> n;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Filter additions and removals");
        }
        ListIterator<Pair<E, String>> it = add.listIterator();
        while (it.hasNext()) {
            n = it.next();
            if (((INode)n.first).getRootNode() != null) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Prevent adding {}", n);
            }
            it.remove();
        }
        it = rem.listIterator();
        while (it.hasNext()) {
            n = it.next();
            if (((INode)n.first).getRootNode() == null) continue;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Prevent removing {}", n);
            }
            it.remove();
        }
        for (Pair<E, String> r : rem) {
            mod.removeValues((Object)((INode)r.first));
        }
    }

    private void listen(INode node) {
        node.addListener((NodeListener)this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.listen(n);
            }
        }
    }

    private void stopListening(INode node) {
        node.removeListener((NodeListener)this);
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            for (INode n : parentNode.getNodes()) {
                this.stopListening(n);
            }
        }
    }

    public void propertyChanged(INode node, String id) {
        this.receiveUpdate(node, id, this.graphModified.contains(node));
    }

    public <T extends INode> void nodeAdded(ParentNode<T> node, INode child, String rel) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Node added " + String.valueOf(child) + " parent " + String.valueOf(node));
        }
        this.receiveAdd(child, rel, this.graphModified.contains(node));
    }

    public <T extends INode> void nodeRemoved(ParentNode<T> node, INode child, String rel) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Node removed " + String.valueOf(child) + " parent " + String.valueOf(node));
        }
        this.receiveRemove(child, rel, this.graphModified.contains(node));
    }

    public void delete() {
        if (this.undoRedoSupport != null) {
            this.undoRedoSupport.cancel((UndoRedoSupport.ChangeListener)this);
        }
        this.changeTracking = false;
        this.view.removeListener(this);
        this.mapping.removeMappingListener((IMappingListener)this);
        ArrayList nodes = new ArrayList(this.nodeToActor.getKeySize());
        nodes.addAll(this.nodeToActor.getKeys());
        for (Object node : this.mapping.getRange()) {
            if (!(node instanceof INode)) continue;
            ((INode)node).removeListener((NodeListener)this);
        }
        for (Object node : nodes) {
            this.removeActor(node);
            node.cleanup();
        }
        for (vtkProp prop : this.actorToNode.keySet()) {
            if (prop.GetVTKId() == 0L) continue;
            prop.Delete();
        }
        this.actorToNode.clear();
        this.nodeToActor.clear();
    }

    public void addListener(NodeListener listener) {
        this.nodeListeners.add(listener);
    }

    public void removeListener(NodeListener listener) {
        this.nodeListeners.remove(listener);
    }

    public IMapping<DBObject, INode> getMapping() {
        return this.mapping;
    }

    private void fireCommit(WriteGraph graph) {
        if (this.nodeMaplisteners.size() > 0) {
            this.tempListenerlist.addAll(this.nodeMaplisteners);
            for (NodeMapListener l : this.tempListenerlist) {
                l.commit(graph);
            }
            this.tempListenerlist.clear();
        }
    }

    public void addListener(NodeMapListener listener) {
        this.nodeMaplisteners.add(listener);
    }

    public void removeListener(NodeMapListener listener) {
        this.nodeMaplisteners.remove(listener);
    }
}

