/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.datastructures;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class Box {
    Point3d min;
    Point3d max;

    public Point3d getMin() {
        return this.min;
    }

    public Point3d getMax() {
        return this.max;
    }

    public Point3d getCenter() {
        return new Point3d((this.max.x - this.min.x) * 0.5 + this.min.x, (this.max.y - this.min.y) * 0.5 + this.min.y, (this.max.z - this.min.z) * 0.5 + this.min.z);
    }

    public Point3d getSize() {
        return new Point3d(this.max.x - this.min.x, this.max.y - this.min.y, this.max.z - this.min.z);
    }

    public Box(Point3d min, Point3d max) {
        this.max = max;
        this.min = min;
    }

    public Box(Tuple3d min, Tuple3d max) {
        this.max = new Point3d(max);
        this.min = new Point3d(min);
    }

    public Box(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min = new Point3d(minx, miny, minz);
        this.max = new Point3d(maxx, maxy, maxz);
    }

    public Box(double[] min, double[] max) {
        this.min = new Point3d(min);
        this.max = new Point3d(max);
    }

    public Box(double[] bb) {
        this.min = new Point3d(bb[0], bb[1], bb[2]);
        this.max = new Point3d(bb[3], bb[4], bb[5]);
    }

    public Box(Box box) {
        this.min = new Point3d(box.min);
        this.max = new Point3d(box.max);
    }

    public double getDiagonal() {
        return this.min.distance(this.max);
    }

    public void add(Box box) {
        if (this.min.x > box.min.x) {
            this.min.x = box.min.x;
        }
        if (this.max.x < box.max.x) {
            this.max.x = box.max.x;
        }
        if (this.min.y > box.min.y) {
            this.min.y = box.min.y;
        }
        if (this.max.y < box.max.y) {
            this.max.y = box.max.y;
        }
        if (this.min.z > box.min.z) {
            this.min.z = box.min.z;
        }
        if (this.max.z < box.max.z) {
            this.max.z = box.max.z;
        }
    }

    public boolean overlaps(Box box) {
        if (this.min.x > box.max.x) {
            return false;
        }
        if (this.max.x < box.min.x) {
            return false;
        }
        if (this.min.y > box.max.y) {
            return false;
        }
        if (this.max.y < box.min.y) {
            return false;
        }
        if (this.min.z > box.max.z) {
            return false;
        }
        return !(this.max.z < box.min.z);
    }
}

