/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.wizard;

import java.util.Deque;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.g3d.csg.wizard.CSGBrepModelExporter;
import org.simantics.g3d.csg.wizard.CSGExportModel;
import org.simantics.g3d.csg.wizard.CSGExportPage;
import org.simantics.g3d.wizard.ModelExportWizard;
import org.simantics.g3d.wizard.ModelExportWizardPage;

public class CSGBRepExportWizard
extends ModelExportWizard<CSGExportModel> {
    public static final String RECENT_CSG_EXPORT_LOCATIONS = "RECENT_CSG_EXPORT_LOCATIONS";
    public static final String CSG_EXPORT_OVERWRITE = "CSG_EXPORT_OVERWRITE";

    public CSGBRepExportWizard() {
        this.setWindowTitle("Export CSG Model to Brep");
        this.setNeedsProgressMonitor(true);
    }

    protected CSGExportModel createExportModel(Deque<String> recentExportPaths) {
        return new CSGExportModel(recentExportPaths);
    }

    protected ModelExportWizardPage<CSGExportModel> createExportPage(CSGExportModel exportModel) {
        return new CSGExportPage(exportModel);
    }

    protected IRunnableWithProgress createExportRunnable(CSGExportModel exportModel) {
        return new CSGBrepModelExporter(exportModel);
    }

    protected String getExportLocationId() {
        return RECENT_CSG_EXPORT_LOCATIONS;
    }

    protected String getExportOverwriteId() {
        return CSG_EXPORT_OVERWRITE;
    }

    protected IPersistentPreferenceStore getPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.g3d.csg");
    }
}

