/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.g3d.csg.scenegraph2.CSGrootNode;
import org.simantics.g3d.csg.scenegraph2.ICSGnode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.vtk.awt.InteractiveVtkPanel;
import org.simantics.g3d.vtk.common.AbstractVTKNodeMap;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.objmap.graph.IMapping;
import vtk.vtkProp;
import vtk.vtkProp3D;

public class CSGNodeMap
extends AbstractVTKNodeMap<Resource, ICSGnode> {
    public CSGNodeMap(Session session, IMapping<Resource, INode> mapping, InteractiveVtkPanel panel, CSGrootNode rootNode) {
        super(session, mapping, (VtkView)panel, (ParentNode)rootNode);
        rootNode.setNodeMap(this);
    }

    protected void updateActor(ICSGnode node, Set<String> ids) {
        if (node.getParent() instanceof ICSGnode) {
            ICSGnode parent = (ICSGnode)node.getParent();
            if (!"child".equals(node.getParentRel())) {
                this.updateActor(parent, null);
                return;
            }
        }
        if (node instanceof ParentNode) {
            ParentNode p = (ParentNode)node;
            for (ICSGnode n : p.getNodes()) {
                this.remActor(n);
            }
        }
        this.remActor(node);
        this.addActor(node);
    }

    protected Collection<vtkProp> getActors(ICSGnode node) {
        ArrayList<vtkProp> props = new ArrayList<vtkProp>();
        for (vtkProp3D p : node.getActors()) {
            props.add((vtkProp)p);
        }
        return props;
    }

    protected void removeActor(ICSGnode node) {
        this.remActor(node);
        if (!"child".equals(node.getParentRel()) && node.getParent() instanceof ICSGnode) {
            this.updateActor((ICSGnode)node.getParent(), null);
        }
    }

    protected void addActor(ICSGnode node) {
        if (this.hasActor(node)) {
            return;
        }
        if (Thread.currentThread() != this.view.getThreadQueue().getThread()) {
            throw new RuntimeException("Illegal thread.");
        }
        this.view.lock();
        node.visualize(this.view);
        this.map((INode)node, node.getActors());
        this.view.unlock();
    }

    private boolean hasActor(ICSGnode node) {
        Collection list = this.getRenderObjects((INode)node);
        return list != null && list.size() != 0;
    }

    private void remActor(ICSGnode node) {
        if (Thread.currentThread() != this.view.getThreadQueue().getThread()) {
            throw new RuntimeException("Illegal thread.");
        }
        Collection list = this.getRenderObjects((INode)node);
        if (list.size() > 0) {
            this.removeMap((INode)node);
            this.view.lock();
            node.stopVisualize();
            this.view.unlock();
        }
    }
}

