/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.editor;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.csg.actions.AddBooleanOpAction2;
import org.simantics.g3d.csg.actions.AddPrimitiveAction2;
import org.simantics.g3d.csg.actions.SplitBooleanOpAction2;
import org.simantics.g3d.csg.editor.CSGNodeMap;
import org.simantics.g3d.csg.scenegraph2.BarrelNode;
import org.simantics.g3d.csg.scenegraph2.BoxNode;
import org.simantics.g3d.csg.scenegraph2.CSGparentNode;
import org.simantics.g3d.csg.scenegraph2.CSGrootNode;
import org.simantics.g3d.csg.scenegraph2.ConeNode;
import org.simantics.g3d.csg.scenegraph2.CylinderNode;
import org.simantics.g3d.csg.scenegraph2.DifferenceNode;
import org.simantics.g3d.csg.scenegraph2.EllipticCylinderNode;
import org.simantics.g3d.csg.scenegraph2.ICSGnode;
import org.simantics.g3d.csg.scenegraph2.IntersectionNode;
import org.simantics.g3d.csg.scenegraph2.RectangularSolidNode;
import org.simantics.g3d.csg.scenegraph2.RegularPrismNode;
import org.simantics.g3d.csg.scenegraph2.SchemaBuilder;
import org.simantics.g3d.csg.scenegraph2.SphereNode;
import org.simantics.g3d.csg.scenegraph2.TorusNode;
import org.simantics.g3d.csg.scenegraph2.UnionNode;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.NodeMap;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.vtk.action.RemoveAction;
import org.simantics.g3d.vtk.action.vtkAction;
import org.simantics.g3d.vtk.awt.InteractiveVtkPanel;
import org.simantics.g3d.vtk.awt.RotateAction;
import org.simantics.g3d.vtk.awt.TranslateAction;
import org.simantics.g3d.vtk.awt.vtkCameraAndSelectorAction;
import org.simantics.g3d.vtk.common.HoverHighlighter;
import org.simantics.g3d.vtk.common.NodeSelectionProvider2;
import org.simantics.g3d.vtk.common.SelectionHighlighter;
import org.simantics.g3d.vtk.common.VTKContentOutlinePage;
import org.simantics.g3d.vtk.common.VTKNodeMap;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.g3d.vtk.shape.vtkShape;
import org.simantics.g3d.vtk.utils.vtkPanelUtil;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.Mappings;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorPart;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.SWTAWTComponent;
import vtk.vtkActor;
import vtk.vtkCameraPass;
import vtk.vtkDefaultPass;
import vtk.vtkLightsPass;
import vtk.vtkObjectBase;
import vtk.vtkPanel;
import vtk.vtkProp;
import vtk.vtkRenderPass;
import vtk.vtkRenderPassCollection;
import vtk.vtkRenderer;
import vtk.vtkSequencePass;

public class CSGEditor2
extends ResourceEditorPart {
    private Composite parent;
    private Resource input;
    private InteractiveVtkPanel panel;
    private SWTAWTComponent component;
    private CSGrootNode rootNode;
    private IMapping<Resource, INode> mapping;
    private NodeSelectionProvider2<Resource, INode> selectionProvider;
    private vtkCameraAndSelectorAction cameraAction;
    private TranslateAction translateAction;
    private RotateAction rotateAction;
    private RemoveAction removeAction;
    private CSGNodeMap nodeMap;
    protected Menu contextMenu;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.component = new SWTAWTComponent(parent, 0){

            protected Component createSwingComponent() {
                if (CSGEditor2.this.panel == null) {
                    CSGEditor2.this.panel = new InteractiveVtkPanel();
                    vtkPanelUtil.registerPanel((vtkPanel)CSGEditor2.this.panel);
                    CSGEditor2.this.createScene();
                }
                return CSGEditor2.this.panel;
            }
        };
        IResourceEditorInput rei = (IResourceEditorInput)this.getEditorInput();
        this.input = rei.getResource();
        this.hookContextMenu();
        this.component.syncPopulate();
        this.panel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(final MouseEvent e) {
                if (e.getButton() == 3) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).CSGEditor2.this.contextMenu.setLocation(e.getXOnScreen(), e.getYOnScreen());
                            (this).CSGEditor2.this.contextMenu.setVisible(true);
                        }
                    });
                }
            }
        });
        this.cameraAction = new vtkCameraAndSelectorAction(this.panel);
        this.panel.setDefaultAction((vtkAction)this.cameraAction);
        this.panel.useDefaultAction();
        try {
            this.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    IMappingSchema<Resource, Object> schema = SchemaBuilder.getSchema(graph);
                    CSGEditor2.this.mapping = Mappings.createWithListening(schema);
                    CSGEditor2.this.rootNode = (CSGrootNode)((Object)CSGEditor2.this.mapping.map(graph, (Object)CSGEditor2.this.input));
                    CSGEditor2.this.nodeMap = new CSGNodeMap(CSGEditor2.this.getSession(), CSGEditor2.this.mapping, CSGEditor2.this.panel, CSGEditor2.this.rootNode);
                }
            });
            if (this.rootNode == null) {
                throw new RuntimeException("Scenegraph loading failed.");
            }
            this.populate();
            this.selectionProvider = new NodeSelectionProvider2((IEditorPart)this, this.mapping, (VTKNodeMap)this.nodeMap);
            this.cameraAction.addSelectionChangedListener(this.selectionProvider);
            this.cameraAction.addHoverChangedListener((ISelectionChangedListener)new HoverHighlighter((VtkView)this.panel, (VTKNodeMap)this.nodeMap));
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)new SelectionHighlighter((VtkView)this.panel, (VTKNodeMap)this.nodeMap));
            this.getSite().setSelectionProvider(this.selectionProvider);
            this.getSite().getPage().addPostSelectionListener(this.selectionProvider);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CSGEditor2.this.getSite().getPage().removePostSelectionListener(CSGEditor2.this.selectionProvider);
                    ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).CSGEditor2.this.nodeMap.delete();
                            vtkPanelUtil.unregisterPanel((vtkPanel)(this).CSGEditor2.this.panel);
                        }
                    });
                    CSGEditor2.this.mapping.dispose();
                    CSGEditor2.this.component.dispose();
                }
            });
        }
        catch (DatabaseException e1) {
            ExceptionUtils.logAndShowError((String)"Cannot open CSG editor", (Throwable)e1);
            return;
        }
        this.translateAction = new TranslateAction(this.panel, (VTKNodeMap)this.nodeMap);
        this.rotateAction = new RotateAction(this.panel, (VTKNodeMap)this.nodeMap);
        this.removeAction = new RemoveAction((VTKNodeMap)this.nodeMap){

            public void setNode(INode node) {
                super.setNode(node);
                if (node.getParent() instanceof CSGparentNode) {
                    this.setEnabled(false);
                }
            }
        };
    }

    public void populate() {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CSGEditor2.this.nodeMap.populate();
            }
        });
    }

    public void setFocus() {
        this.component.setFocus();
    }

    private void createScene() {
        vtkRenderer ren1 = this.panel.GetRenderer();
        boolean multiPass = false;
        if (multiPass) {
            vtkLightsPass lightsPass = new vtkLightsPass();
            vtkDefaultPass defaultPass = new vtkDefaultPass();
            vtkRenderPassCollection passes = new vtkRenderPassCollection();
            passes.AddItem((vtkRenderPass)lightsPass);
            passes.AddItem((vtkRenderPass)defaultPass);
            vtkSequencePass seq = new vtkSequencePass();
            seq.SetPasses(passes);
            vtkCameraPass cameraPass = new vtkCameraPass();
            cameraPass.SetDelegatePass((vtkRenderPass)seq);
            ren1.SetPass((vtkRenderPass)cameraPass);
        }
        ren1.SetBackground2(1.0, 1.0, 1.0);
        ren1.SetBackground(0.9, 0.9, 0.9);
        ren1.SetGradientBackground(true);
        vtkActor grid = vtkShape.createGridActor((int)8, (double)1.0, (int)2);
        grid.SetPickable(0);
        ren1.AddActor((vtkProp)grid);
        this.panel.addDeletable((vtkObjectBase)grid);
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IMenuManager m = manager;
                List selected = CSGEditor2.this.selectionProvider.getSelectedNodes();
                if (selected.size() == 0) {
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, BarrelNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, BoxNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, ConeNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, CylinderNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, EllipticCylinderNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, RectangularSolidNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, RegularPrismNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, SphereNode.class));
                    m.add((IAction)new AddPrimitiveAction2(CSGEditor2.this.rootNode, TorusNode.class));
                } else if (selected.size() == 1) {
                    m.add((IAction)CSGEditor2.this.translateAction);
                    m.add((IAction)CSGEditor2.this.rotateAction);
                    m.add((IAction)CSGEditor2.this.removeAction);
                    ICSGnode node = (ICSGnode)selected.get(0);
                    CSGEditor2.this.translateAction.setNode((IG3DNode)node);
                    CSGEditor2.this.rotateAction.setNode((IG3DNode)node);
                    CSGEditor2.this.removeAction.setNode((INode)node);
                    if (node instanceof CSGparentNode) {
                        m.add((IAction)new SplitBooleanOpAction2(CSGEditor2.this.rootNode, (CSGparentNode)node));
                    }
                } else if (selected.size() == 2 && ((INode)selected.get(0)).getParent().equals((Object)CSGEditor2.this.rootNode) && ((INode)selected.get(1)).getParent().equals((Object)CSGEditor2.this.rootNode)) {
                    ArrayList<ICSGnode> nodes = new ArrayList<ICSGnode>();
                    for (INode n : selected) {
                        nodes.add((ICSGnode)n);
                    }
                    m.add((IAction)new AddBooleanOpAction2(CSGEditor2.this.rootNode, DifferenceNode.class, nodes));
                    m.add((IAction)new AddBooleanOpAction2(CSGEditor2.this.rootNode, IntersectionNode.class, nodes));
                    m.add((IAction)new AddBooleanOpAction2(CSGEditor2.this.rootNode, UnionNode.class, nodes));
                }
            }
        });
        this.contextMenu = menuMgr.createContextMenu((Control)this.parent);
    }

    private IContentOutlinePage createOutline() {
        if (this.rootNode == null || this.selectionProvider == null) {
            return null;
        }
        VTKContentOutlinePage outlinePage = new VTKContentOutlinePage((ParentNode)this.rootNode, this.selectionProvider);
        outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CSGEditor2.this.selectionProvider.selectionChanged(event);
            }
        });
        return outlinePage;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IPropertyPage.class)) {
            return adapter.cast(new StandardPropertyPage(this.getSite(), this.getPropertyContexts()));
        }
        if (adapter.isAssignableFrom(IContentOutlinePage.class)) {
            return adapter.cast(this.createOutline());
        }
        if (adapter.isAssignableFrom(NodeMap.class)) {
            return adapter.cast((Object)this.nodeMap);
        }
        if (adapter.isAssignableFrom(INode.class)) {
            return adapter.cast((Object)this.rootNode);
        }
        if (adapter.isAssignableFrom(IMapping.class)) {
            return adapter.cast(this.mapping);
        }
        if (adapter.isAssignableFrom(InteractiveVtkPanel.class)) {
            return adapter.cast(this.panel);
        }
        if (adapter.isAssignableFrom(VtkView.class)) {
            return adapter.cast(this.panel);
        }
        return (T)super.getAdapter(adapter);
    }

    public Set<String> getPropertyContexts() {
        HashSet<String> result = new HashSet<String>();
        result.add("http://www.simantics.org/Project-1.0/ProjectBrowseContext");
        return result;
    }
}

