/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection;

import java.util.List;
import java.util.UUID;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.district.selection.ElementSelectionResource;
import org.simantics.layer0.Layer0;

public class ElementSelectionUtils {
    public static Resource ensureSelectionLibrary(RequestProcessor graph) throws DatabaseException {
        return (Resource)graph.syncRequest((WriteResult)new WriteResult<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                ElementSelectionResource ES = ElementSelectionResource.getInstance((ReadGraph)graph);
                Resource model = (Resource)graph.sync((ReadInterface)new PossibleActiveModel(Simantics.getProjectResource()));
                if (model == null) {
                    return null;
                }
                List libs = QueryIndexUtils.searchByTypeShallow((ReadGraph)graph, (Resource)model, (Resource)ES.SelectionLibrary);
                if (libs.isEmpty()) {
                    Resource lib = graph.newResource();
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    graph.claim(lib, L0.InstanceOf, ES.SelectionLibrary);
                    graph.claim(model, L0.ConsistsOf, lib);
                    graph.claimLiteral(lib, L0.HasName, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
                    return lib;
                }
                return (Resource)libs.get(0);
            }
        });
    }
}

