/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.selection.ui.handlers;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Display;
import org.simantics.district.selection.ElementSelector;
import org.simantics.district.selection.ui.parts.ElementSelectionView;

public class PerformSelectionQueryHandler {
    @Inject
    EPartService partService;

    @CanExecute
    public boolean canExecute(ESelectionService selectionService) {
        MPart part = this.partService.getActivePart();
        if (part == null) {
            return false;
        }
        Object object = part.getObject();
        if (object == null || !(object instanceof ElementSelectionView)) {
            return false;
        }
        ElementSelectionView view = (ElementSelectionView)object;
        return view.getSelectedItem() != null;
    }

    @Execute
    public void performElementSelection(IEclipseContext context, IWorkbench workbench) {
        MPart part = this.partService.getActivePart();
        if (part == null) {
            return;
        }
        Object object = part.getObject();
        if (object == null || !(object instanceof ElementSelectionView)) {
            return;
        }
        ElementSelectionView view = (ElementSelectionView)object;
        ElementSelector selectedItem = view.getSelectedItem();
        Display display = (Display)context.getActive(Display.class);
        view.performSelection(display, selectedItem);
    }
}

