/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.region.ui;

import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Set;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.SyncListenerAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.district.region.DiagramRegions;
import org.simantics.district.region.ui.handlers.ZoomToRegionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramRegionsTableUI
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagramRegionsTableUI.class);
    private TreeViewer viewer;
    private TreeViewerColumn column1;
    private TreeViewerColumn column2;
    private ESelectionService selectionService;

    public DiagramRegionsTableUI(ESelectionService selectionService, final Composite parent, int style) {
        super(parent, style);
        this.selectionService = selectionService;
        parent.setLayout((Layout)new FillLayout());
        this.setLayout((Layout)new FillLayout());
        Simantics.getSession().asyncRequest((Read)new DiagramRegions.DiagramRegionsRequest(), (SyncListener)new SyncListenerAdapter<Collection<DiagramRegions.DiagramRegion>>(){

            public void execute(ReadGraph graph, Collection<DiagramRegions.DiagramRegion> result) {
                parent.getDisplay().asyncExec(() -> DiagramRegionsTableUI.this.viewer.setInput((Object)result));
            }

            public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
                LOGGER.error("Could not listen", t);
            }

            public boolean isDisposed() {
                return DiagramRegionsTableUI.this.isDisposed();
            }
        });
        this.viewer = new TreeViewer((Composite)this, 65536);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiagramRegionsTableUI.this.selectionService.setSelection((Object)event.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection selection = (TreeSelection)DiagramRegionsTableUI.this.viewer.getSelection();
                DiagramRegions.DiagramRegion region = (DiagramRegions.DiagramRegion)selection.getFirstElement();
                ZoomToRegionHandler.zoomTo(DiagramRegionsTableUI.this.viewer.getControl(), DiagramRegionsTableUI.this.getDisplay(), region.getResource());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null && !(inputElement instanceof Collection)) {
                    return new Object[0];
                }
                Set set = (Set)inputElement;
                return set.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        Tree table = this.viewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.column1 = new TreeViewerColumn(this.viewer, 0);
        this.column1.getColumn().setText("Region");
        this.column1.getColumn().setWidth(200);
        this.column1.getColumn().setResizable(true);
        this.column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DiagramRegions.DiagramRegion region = (DiagramRegions.DiagramRegion)element;
                return region.getLabel();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.column2 = new TreeViewerColumn(this.viewer, 0);
        this.column2.getColumn().setText("Coordinates");
        this.column2.getColumn().setWidth(200);
        this.column2.getColumn().setResizable(true);
        this.column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DiagramRegions.DiagramRegion region = (DiagramRegions.DiagramRegion)element;
                Rectangle2D rect = region.getShape().getBounds2D();
                DecimalFormat df = new DecimalFormat("0.00");
                String x = df.format(rect.getX());
                String y = df.format(rect.getY());
                String width = df.format(rect.getWidth());
                String height = df.format(rect.getHeight());
                return "[x=" + x + ", y=" + y + ", width=" + width + ", height=" + height + "]";
            }

            public Image getImage(Object element) {
                return null;
            }
        });
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }
}

