/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.visualisations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.profile.ActiveDynamicVisualisationsRequest;
import org.simantics.district.network.profile.DynamicVisualisationsRequest;
import org.simantics.district.network.visualisations.DynamicVisualisations;
import org.simantics.district.network.visualisations.DynamicVisualisationsContributions;
import org.simantics.district.network.visualisations.model.ColorBarOptions;
import org.simantics.district.network.visualisations.model.DynamicArrowContribution;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicColorMap;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeMap;
import org.simantics.district.network.visualisations.model.DynamicVisualisation;
import org.simantics.district.network.visualisations.model.SizeBarOptions;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.dialogs.ShowError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVisualisationsUI {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVisualisationsUI.class);
    private Resource parentResource;
    private VisualisationListener listener;
    private DynamicVisualisation visualisation;
    private Button showSizeButton;
    private Button sizeTicksButton;
    private Button sizeGradientButton;
    private Combo sizeLocationCombo;
    private Combo sizeSizeCombo;
    private Button showColorButton;
    private Button colorTicksButton;
    private Button colorGradientButton;
    private Combo colorLocationCombo;
    private Combo colorSizeCombo;
    private Combo templateSelectionCombo;
    private List<Supplier<Pair<String, DynamicColorContribution>>> colorSuppliers;
    private Button removeVisualisationTemplateButton;
    private Composite parent;
    private Button disableUpdatesButton;
    private Button resetVisualisationButton;
    private Button hoveringVertexEnabledButton;
    private Button hoveringEdgesEnabledButton;
    private Button elevationServerEnabledButton;
    private Button notInSimulationButton;
    private Button showConnectedComponentsButton;
    private List<Supplier<Pair<String, List<DynamicArrowContribution>>>> edgeArrowSuppliers;
    private Button saveVisualisationTemplateAsButton;
    private Button hideEdgesButton;
    private Button hidePointsButton;
    private Button hideConsumersButton;
    private Button hideProducersButton;
    private Button hideValvesButton;
    private Button hidePumpingStationsButton;
    private Button networkBranchesStaticPropertiesButton;
    private Button pointsStaticPropertiesButton;
    private Button consumersStaticPropertiesButton;
    private Button dynamicSymbolsEdgesButton;
    private Button dynamicSymbolsProducersButton;
    private Button dynamicSymbolsValvesButton;
    private Button dynamicSymbolsPumpingStationsButton;
    private Text intervalText;
    private Map<String, ColoringObjectRow> coloringRows = new HashMap<String, ColoringObjectRow>();
    private Map<String, SizingObjectRow> sizingRows = new HashMap<String, SizingObjectRow>();
    private Map<String, ArrowObjectRow> arrowRows = new HashMap<String, ArrowObjectRow>();
    private VisualisationsListener visualisationsListener;
    private Collection<NamedResource> visualisations;
    private List<Supplier<Pair<String, DynamicSizeContribution>>> sizeSuppliers;

    public DynamicVisualisationsUI(Composite parent) {
        this.parent = parent;
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite firstContent = new Composite((Composite)scrolledComposite, 0);
        firstContent.setLayout((Layout)new GridLayout(1, false));
        firstContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultInitializeUI(firstContent);
        scrolledComposite.setContent((Control)firstContent);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(firstContent.computeSize(-1, -1));
    }

    private void defaultInitializeUI(Composite parent) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(parent);
        Composite selectionComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)selectionComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(selectionComposite);
        Label templateNameLabel = new Label(selectionComposite, 0);
        templateNameLabel.setText("Visualisation template");
        this.templateSelectionCombo = new Combo(selectionComposite, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.templateSelectionCombo);
        this.templateSelectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String item = DynamicVisualisationsUI.this.templateSelectionCombo.getItem(DynamicVisualisationsUI.this.templateSelectionCombo.getSelectionIndex());
                Resource visualisationResource = null;
                for (NamedResource template : DynamicVisualisationsUI.this.visualisations) {
                    if (!item.equals(template.getName())) continue;
                    visualisationResource = template.getResource();
                    break;
                }
                final Resource vr = visualisationResource;
                if (DynamicVisualisationsUI.this.parentResource != null) {
                    final Resource res = DynamicVisualisationsUI.this.parentResource;
                    Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            Resource vf = DynamicVisualisations.getVisualisationFolder((ReadGraph)graph, (Resource)res);
                            DynamicVisualisations.setActiveVisualisation((WriteGraph)graph, (Resource)vf, (Resource)vr);
                        }
                    });
                }
            }
        });
        Composite intervalElementsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)intervalElementsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(intervalElementsComposite);
        this.initializeIntervalElements(intervalElementsComposite);
        Composite hoverElementsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hoverElementsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(hoverElementsComposite);
        this.initializeHoverElements(hoverElementsComposite);
        Composite hideElementsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hideElementsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(hideElementsComposite);
        this.initializeHideElements(hideElementsComposite);
        Composite staticPropertiesComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)staticPropertiesComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(staticPropertiesComposite);
        this.initializeStaticProperties(staticPropertiesComposite);
        Composite dynamicSymbolsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dynamicSymbolsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(dynamicSymbolsComposite);
        this.initializeDynamicSymbols(dynamicSymbolsComposite);
        Composite coloringObjectsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)coloringObjectsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(coloringObjectsComposite);
        this.initializeColoringObjects(coloringObjectsComposite);
        Composite colorBarsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)colorBarsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(colorBarsComposite);
        this.initializeColorBars(colorBarsComposite);
        Composite objectSizesComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)objectSizesComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(objectSizesComposite);
        this.initializeObjectSizes(objectSizesComposite);
        Composite sizeBarsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sizeBarsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(sizeBarsComposite);
        this.initializeSizeBars(sizeBarsComposite);
        Composite edgeArrowsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)edgeArrowsComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(edgeArrowsComposite);
        this.initializeEdgeArrows(edgeArrowsComposite);
        Composite buttonBarsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonBarsComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonBarsComposite);
        this.saveVisualisationTemplateAsButton = new Button(buttonBarsComposite, 0);
        this.saveVisualisationTemplateAsButton.setText("Save as visualisation template");
        this.saveVisualisationTemplateAsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicVisualisationsUI.this.showSaveVisualisationTemplateDialog(e.widget.getDisplay().getActiveShell());
            }
        });
        this.removeVisualisationTemplateButton = new Button(buttonBarsComposite, 0);
        this.removeVisualisationTemplateButton.setText("Remove");
        this.removeVisualisationTemplateButton.setEnabled(this.visualisation != null && this.visualisation.getVisualisationResource() != null);
        this.removeVisualisationTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicVisualisationsUI.this.removeVisualisationTemplate(DynamicVisualisationsUI.this.visualisation.getName(), Optional.of(DynamicVisualisationsUI.this.visualisation.getVisualisationResource()));
            }
        });
    }

    private void initializeIntervalElements(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Generic");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo((Composite)group);
        this.createIntervalElements((Composite)group);
    }

    private void createIntervalElements(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Interval (seconds)");
        this.intervalText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.intervalText);
        this.addSelectionListener((Widget)this.intervalText);
        this.disableUpdatesButton = new Button(parent, 32);
        this.disableUpdatesButton.setText("Disable updates");
        this.addSelectionListener((Widget)this.disableUpdatesButton);
        this.resetVisualisationButton = new Button(parent, 32);
        this.resetVisualisationButton.setText("Disable Visualisation");
        this.addSelectionListener((Widget)this.resetVisualisationButton);
        this.notInSimulationButton = new Button(parent, 32);
        this.notInSimulationButton.setText("Not in Simulation");
        this.addSelectionListener((Widget)this.notInSimulationButton);
        this.elevationServerEnabledButton = new Button(parent, 32);
        this.elevationServerEnabledButton.setText("Elevation Server Bounding Box");
        this.addSelectionListener((Widget)this.elevationServerEnabledButton);
        this.showConnectedComponentsButton = new Button(parent, 32);
        this.showConnectedComponentsButton.setText("Show Connected Components");
        this.addSelectionListener((Widget)this.showConnectedComponentsButton);
    }

    private void initializeHoverElements(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Hover");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo((Composite)group);
        this.createHoverElements((Composite)group);
    }

    private void createHoverElements(Composite parent) {
        this.hoveringVertexEnabledButton = new Button(parent, 32);
        this.hoveringVertexEnabledButton.setText("Vertex Key Variables on Hover");
        this.addSelectionListener((Widget)this.hoveringVertexEnabledButton);
        this.hoveringEdgesEnabledButton = new Button(parent, 32);
        this.hoveringEdgesEnabledButton.setText("Edge Key Variables on Hover");
        this.addSelectionListener((Widget)this.hoveringEdgesEnabledButton);
    }

    private void initializeHideElements(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Hide Elements");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(5, 5).applyTo((Composite)group);
        this.createHideElements((Composite)group);
    }

    private void createHideElements(Composite parent) {
        this.hideEdgesButton = new Button(parent, 32);
        this.hideEdgesButton.setText("Edges");
        this.addSelectionListener((Widget)this.hideEdgesButton);
        this.hidePointsButton = new Button(parent, 32);
        this.hidePointsButton.setText("Points");
        this.addSelectionListener((Widget)this.hidePointsButton);
        this.hideConsumersButton = new Button(parent, 32);
        this.hideConsumersButton.setText("Consumers");
        this.addSelectionListener((Widget)this.hideConsumersButton);
        this.hideProducersButton = new Button(parent, 32);
        this.hideProducersButton.setText("Producers");
        this.addSelectionListener((Widget)this.hideProducersButton);
        this.hideValvesButton = new Button(parent, 32);
        this.hideValvesButton.setText("Valves");
        this.addSelectionListener((Widget)this.hideValvesButton);
        this.hidePumpingStationsButton = new Button(parent, 32);
        this.hidePumpingStationsButton.setText("Pumping Stations");
        this.addSelectionListener((Widget)this.hidePumpingStationsButton);
    }

    private void initializeStaticProperties(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Static Properties");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(5, 5).applyTo((Composite)group);
        this.createStaticProperties((Composite)group);
    }

    private void createStaticProperties(Composite parent) {
        this.networkBranchesStaticPropertiesButton = new Button(parent, 32);
        this.networkBranchesStaticPropertiesButton.setText("Network Branches");
        this.addSelectionListener((Widget)this.networkBranchesStaticPropertiesButton);
        this.pointsStaticPropertiesButton = new Button(parent, 32);
        this.pointsStaticPropertiesButton.setText("Points");
        this.addSelectionListener((Widget)this.pointsStaticPropertiesButton);
        this.consumersStaticPropertiesButton = new Button(parent, 32);
        this.consumersStaticPropertiesButton.setText("Consumers");
        this.addSelectionListener((Widget)this.consumersStaticPropertiesButton);
    }

    private void initializeDynamicSymbols(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Dynamic Symbols");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(5, 5).applyTo((Composite)group);
        this.createDynamicSymbols((Composite)group);
    }

    private void createDynamicSymbols(Composite parent) {
        this.dynamicSymbolsEdgesButton = new Button(parent, 32);
        this.dynamicSymbolsEdgesButton.setText("Shutoff Valves in Pipes");
        this.addSelectionListener((Widget)this.dynamicSymbolsEdgesButton);
        this.dynamicSymbolsProducersButton = new Button(parent, 32);
        this.dynamicSymbolsProducersButton.setText("Producers");
        this.addSelectionListener((Widget)this.dynamicSymbolsProducersButton);
        this.dynamicSymbolsValvesButton = new Button(parent, 32);
        this.dynamicSymbolsValvesButton.setText("Valves");
        this.addSelectionListener((Widget)this.dynamicSymbolsValvesButton);
        this.dynamicSymbolsPumpingStationsButton = new Button(parent, 32);
        this.dynamicSymbolsPumpingStationsButton.setText("Pumping Stations");
        this.addSelectionListener((Widget)this.dynamicSymbolsPumpingStationsButton);
    }

    private void initializeEdgeArrows(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Edge Arrows");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(7).margins(5, 5).applyTo((Composite)group);
        this.createEdgeArrowsHeaderRow((Composite)group);
        this.edgeArrowSuppliers = new ArrayList<Supplier<Pair<String, List<DynamicArrowContribution>>>>();
        try {
            Collection result = (Collection)Simantics.getSession().syncRequest((Read)new UniqueRead<Collection<DynamicVisualisationsContributions.DynamicArrowObject>>(){

                public Collection<DynamicVisualisationsContributions.DynamicArrowObject> perform(ReadGraph graph) throws DatabaseException {
                    return DynamicVisualisationsContributions.dynamicEdgeArrowObjects((ReadGraph)graph);
                }
            });
            for (DynamicVisualisationsContributions.DynamicArrowObject object : result) {
                this.edgeArrowSuppliers.add(this.createEdgeArrowRow((Composite)group, object));
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not create coloring objecst", (Throwable)e);
        }
    }

    private void createEdgeArrowsHeaderRow(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Label");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Category");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Used");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Variable");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Gain");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Bias");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Default");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
    }

    private Supplier<Pair<String, List<DynamicArrowContribution>>> createEdgeArrowRow(Composite parent, DynamicVisualisationsContributions.DynamicArrowObject object) {
        Map arrowContributionss = object.getArrowContributions();
        if (arrowContributionss.isEmpty()) {
            return null;
        }
        HashMap<String, HashMap<String, DynamicArrowContribution>> byCategory = new HashMap<String, HashMap<String, DynamicArrowContribution>>();
        for (Map.Entry contr : object.getArrowContributions().entrySet()) {
            String categ = ((DynamicArrowContribution)contr.getValue()).getCategory();
            HashMap<String, DynamicArrowContribution> cc = (HashMap<String, DynamicArrowContribution>)byCategory.get(categ);
            if (cc == null) {
                cc = new HashMap<String, DynamicArrowContribution>();
                byCategory.put(categ, cc);
            }
            cc.put((String)contr.getKey(), (DynamicArrowContribution)contr.getValue());
        }
        final ArrayList<Supplier<Pair<String, DynamicArrowContribution>>> suppliers = new ArrayList<Supplier<Pair<String, DynamicArrowContribution>>>();
        for (Map.Entry contr : byCategory.entrySet()) {
            Supplier<Pair<String, DynamicArrowContribution>> supplier = this.createEdgeArrowRowInternal(parent, object, (String)contr.getKey(), (Map)contr.getValue());
            suppliers.add(supplier);
        }
        return new Supplier<Pair<String, List<DynamicArrowContribution>>>(){

            @Override
            public Pair<String, List<DynamicArrowContribution>> get() {
                ArrayList<DynamicArrowContribution> contrs = new ArrayList<DynamicArrowContribution>();
                String name = "";
                for (Supplier s : suppliers) {
                    Pair pair = (Pair)s.get();
                    if (pair == null) continue;
                    name = (String)pair.first;
                    contrs.add((DynamicArrowContribution)pair.second);
                }
                return Pair.make((Object)name, contrs);
            }
        };
    }

    private Supplier<Pair<String, DynamicArrowContribution>> createEdgeArrowRowInternal(Composite parent, final DynamicVisualisationsContributions.DynamicArrowObject object, String category, final Map<String, DynamicArrowContribution> arrowContributions) {
        Label label = new Label(parent, 0);
        label.setText(object.getArrowObject().getName());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText(category);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label);
        final Button usedButton = new Button(parent, 32);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)usedButton);
        this.addSelectionListener((Widget)usedButton);
        final Combo variableCombo = new Combo(parent, 8);
        variableCombo.setItems(arrowContributions.keySet().toArray(new String[arrowContributions.size()]));
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)variableCombo);
        final Text gainText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)gainText);
        this.addSelectionListener((Widget)gainText);
        final Text biasText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)biasText);
        this.addSelectionListener((Widget)biasText);
        final Button defaultButton = new Button(parent, 32);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)defaultButton);
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = variableCombo.getSelectionIndex();
                if (index >= 0) {
                    String key = variableCombo.getItem(index);
                    DynamicArrowContribution cont = (DynamicArrowContribution)arrowContributions.get(key);
                    gainText.setText(Double.toString(cont.getDefaultGain()));
                    gainText.setEnabled(!defaultButton.getSelection());
                    biasText.setText(Double.toString(cont.getDefaultBias()));
                    biasText.setEnabled(!defaultButton.getSelection());
                }
            }
        });
        this.addSelectionListener((Widget)defaultButton);
        variableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String key = variableCombo.getItem(variableCombo.getSelectionIndex());
                DynamicArrowContribution cont = (DynamicArrowContribution)arrowContributions.get(key);
                if (gainText.getText().isEmpty()) {
                    gainText.setText(Double.toString(cont.getDefaultGain()));
                }
                if (biasText.getText().isEmpty()) {
                    biasText.setText(Double.toString(cont.getDefaultBias()));
                }
                defaultButton.setSelection(true);
            }
        });
        this.addSelectionListener((Widget)variableCombo);
        this.arrowRows.put(object.getArrowObject().getName(), new ArrowObjectRow(label, usedButton, variableCombo, gainText, biasText, defaultButton));
        return new Supplier<Pair<String, DynamicArrowContribution>>(){

            @Override
            public Pair<String, DynamicArrowContribution> get() {
                String key;
                DynamicArrowContribution cont;
                int selectionIndex = variableCombo.getSelectionIndex();
                if (selectionIndex >= 0 && (cont = (DynamicArrowContribution)arrowContributions.get(key = variableCombo.getItem(selectionIndex))) != null) {
                    String label = variableCombo.getItem(variableCombo.getSelectionIndex());
                    double gain = cont.getDefaultGain();
                    String gainS = gainText.getText();
                    if (gainS != null && !gainS.isEmpty()) {
                        gain = Double.parseDouble(gainS);
                    }
                    double bias = cont.getDefaultBias();
                    String biasS = biasText.getText();
                    if (biasS != null && !biasS.isEmpty()) {
                        bias = Double.parseDouble(biasText.getText());
                    }
                    DynamicArrowContribution dsc = new DynamicArrowContribution(label, cont.getModuleName(), cont.getAttributeName(), gain, bias);
                    dsc.setUsed(usedButton.getSelection());
                    dsc.setUseDefault(defaultButton.getSelection());
                    return Pair.make((Object)object.getArrowObject().getName(), (Object)dsc);
                }
                return null;
            }
        };
    }

    protected void removeVisualisationTemplate(String name, Optional<Resource> of) {
        if (of.isPresent()) {
            final Resource visualisation = of.get();
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    RemoverUtil.remove((WriteGraph)graph, (Resource)visualisation);
                }
            });
        }
    }

    private void showSaveVisualisationTemplateDialog(Shell shell) {
        InputDialog dialog = new InputDialog(shell, "Save visualisation template", "Give template a name", "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.isEmpty()) {
                    return "Name cannot be empty";
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String name = dialog.getValue();
            try {
                this.persistVisualisationTemplate(name, Optional.empty());
            }
            catch (Exception e) {
                LOGGER.error("Could not persist visualisation template", (Throwable)e);
                ShowError.showError((String)"Could not persist visualisation template", (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void persistCurrentVisualisationTemplateIfAvailable() {
        if (this.visualisation != null) {
            try {
                this.persistVisualisationTemplate(this.visualisation.getName(), Optional.of(this.visualisation.getVisualisationResource()));
            }
            catch (Exception e1) {
                LOGGER.error("Could not persist visualisation template", (Throwable)e1);
                ShowError.showError((String)"Could not persist visualisation template", (String)e1.getMessage(), (Throwable)e1);
            }
        } else {
            LOGGER.info("No current visualisation template selected for saving");
        }
    }

    private void persistVisualisationTemplate(final String templateName, final Optional<Resource> existing) throws Exception {
        Long interval;
        final List colorCollect = this.colorSuppliers.stream().filter(Objects::nonNull).map(s -> (Pair)s.get()).filter(Objects::nonNull).collect(Collectors.toList());
        String colorLocation = this.colorLocationCombo.getItem(this.colorLocationCombo.getSelectionIndex());
        String colorSize = this.colorSizeCombo.getItem(this.colorSizeCombo.getSelectionIndex());
        final ColorBarOptions colorBarOptions = new ColorBarOptions().showColorBars(this.showColorButton.getSelection()).showColorBarsTicks(this.colorTicksButton.getSelection()).useGradients(this.colorGradientButton.getSelection()).withLocation(ColorBarOptions.ColorBarsLocation.valueOf((String)colorLocation)).withSize(ColorBarOptions.ColorBarsSize.valueOf((String)colorSize));
        final List sizeCollect = this.sizeSuppliers.stream().filter(Objects::nonNull).map(s -> (Pair)s.get()).filter(Objects::nonNull).collect(Collectors.toList());
        String sizeLocation = this.sizeLocationCombo.getItem(this.sizeLocationCombo.getSelectionIndex());
        String sizeSize = this.sizeSizeCombo.getItem(this.sizeSizeCombo.getSelectionIndex());
        final SizeBarOptions sizeBarOptions = new SizeBarOptions().showSizeBars(this.showSizeButton.getSelection()).showSizeBarsTicks(this.sizeTicksButton.getSelection()).useGradients(this.sizeGradientButton.getSelection()).withLocation(SizeBarOptions.SizeBarsLocation.valueOf((String)sizeLocation)).withSize(SizeBarOptions.SizeBarsSize.valueOf((String)sizeSize));
        final List edgeArrowCollect = this.edgeArrowSuppliers.stream().filter(Objects::nonNull).map(s -> (Pair)s.get()).filter(Objects::nonNull).collect(Collectors.toList());
        final boolean hideEdges = this.hideEdgesButton.getSelection();
        final boolean hidePoints = this.hidePointsButton.getSelection();
        final boolean hideConsumers = this.hideConsumersButton.getSelection();
        final boolean hideProducers = this.hideProducersButton.getSelection();
        final boolean hideValves = this.hideValvesButton.getSelection();
        final boolean hidePumpingStations = this.hidePumpingStationsButton.getSelection();
        final boolean networkBranchesStaticProperties = this.networkBranchesStaticPropertiesButton.getSelection();
        final boolean pointsStaticProperties = this.pointsStaticPropertiesButton.getSelection();
        final boolean consumersStaticProperties = this.consumersStaticPropertiesButton.getSelection();
        final boolean dynamicSymbolsEdges = this.dynamicSymbolsEdgesButton.getSelection();
        final boolean dynamicSymbolsProducers = this.dynamicSymbolsProducersButton.getSelection();
        final boolean dynamicSymbolsValves = this.dynamicSymbolsValvesButton.getSelection();
        final boolean dynamicSymbolsPumpingStations = this.dynamicSymbolsPumpingStationsButton.getSelection();
        final boolean disabled = this.disableUpdatesButton.getSelection();
        final boolean resetVisualisation = this.resetVisualisationButton.getSelection();
        try {
            interval = (long)(Double.parseDouble(this.intervalText.getText()) * 1000.0);
        }
        catch (NumberFormatException numberFormatException) {
            interval = 2000L;
        }
        final long finalInterval = interval;
        final boolean hoverVertex = this.hoveringVertexEnabledButton.getSelection();
        final boolean hoverEdges = this.hoveringEdgesEnabledButton.getSelection();
        final boolean elevationServerBoundingBox = this.elevationServerEnabledButton.getSelection();
        final boolean notInSimulation = this.notInSimulationButton.getSelection();
        final boolean showConnectedComponents = this.showConnectedComponentsButton.getSelection();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                Resource exist = existing.isPresent() ? (Resource)existing.get() : DynamicVisualisations.createVisualisation((WriteGraph)graph, (Resource)DynamicVisualisationsUI.this.parentResource, (String)templateName);
                DynamicVisualisations.setIntervalAndDisabled((WriteGraph)graph, (Resource)exist, (long)finalInterval, (boolean)disabled, (boolean)resetVisualisation);
                DynamicVisualisations.setColorContributions((WriteGraph)graph, (Resource)exist, (List)colorCollect);
                DynamicVisualisations.setColorBarOptions((WriteGraph)graph, (Resource)exist, (ColorBarOptions)colorBarOptions);
                DynamicVisualisations.setSizeContributions((WriteGraph)graph, (Resource)exist, (List)sizeCollect);
                DynamicVisualisations.setSizeBarOptions((WriteGraph)graph, (Resource)exist, (SizeBarOptions)sizeBarOptions);
                DynamicVisualisations.setEdgeArrowContributions((WriteGraph)graph, (Resource)exist, (List)edgeArrowCollect);
                DynamicVisualisations.setHideElements((WriteGraph)graph, (Resource)exist, (boolean)hideEdges, (boolean)hidePoints, (boolean)hideConsumers, (boolean)hideProducers, (boolean)hideValves, (boolean)hidePumpingStations);
                DynamicVisualisations.setStaticProperties((WriteGraph)graph, (Resource)exist, (boolean)networkBranchesStaticProperties, (boolean)pointsStaticProperties, (boolean)consumersStaticProperties);
                DynamicVisualisations.setDynamicSymbols((WriteGraph)graph, (Resource)exist, (boolean)dynamicSymbolsEdges, (boolean)dynamicSymbolsProducers, (boolean)dynamicSymbolsValves, (boolean)dynamicSymbolsPumpingStations);
                DynamicVisualisations.setKeyVariablesHover((WriteGraph)graph, (Resource)exist, (boolean)hoverVertex, (boolean)hoverEdges);
                DynamicVisualisations.setElevationServerBoundingBox((WriteGraph)graph, (Resource)exist, (boolean)elevationServerBoundingBox);
                DynamicVisualisations.setNotInSimulation((WriteGraph)graph, (Resource)exist, (boolean)notInSimulation);
                DynamicVisualisations.setShowConnectedComponents((WriteGraph)graph, (Resource)exist, (boolean)showConnectedComponents);
            }
        });
    }

    private void initializeColoringObjects(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Coloring Objects");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(5, 5).applyTo((Composite)group);
        this.createColoringObjectHeaderRow((Composite)group);
        this.colorSuppliers = new ArrayList<Supplier<Pair<String, DynamicColorContribution>>>();
        try {
            Pair result = (Pair)Simantics.getSession().syncRequest((Read)new UniqueRead<Pair<Collection<DynamicVisualisationsContributions.DynamicColoringObject>, Map<String, DynamicColorMap>>>(){

                public Pair<Collection<DynamicVisualisationsContributions.DynamicColoringObject>, Map<String, DynamicColorMap>> perform(ReadGraph graph) throws DatabaseException {
                    Map dynamicColorMaps = DynamicVisualisationsContributions.dynamicColorMaps((ReadGraph)graph);
                    return Pair.make((Object)DynamicVisualisationsContributions.dynamicColoringObjects((ReadGraph)graph), (Object)dynamicColorMaps);
                }
            });
            for (DynamicVisualisationsContributions.DynamicColoringObject object : (Collection)result.first) {
                this.colorSuppliers.add(this.createColoringObjectRow((Composite)group, object, (Map)result.second));
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not create coloring objecst", (Throwable)e);
        }
    }

    private void createColoringObjectHeaderRow(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Label");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Used");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Variable");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Min");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Max");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Unit");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("ColorMap");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Default");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
    }

    private Supplier<Pair<String, DynamicColorContribution>> createColoringObjectRow(Composite parent, final DynamicVisualisationsContributions.DynamicColoringObject object, final Map<String, DynamicColorMap> colorMaps) {
        Label label = new Label(parent, 0);
        label.setText(object.getColoringObject().getName());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label);
        final Map colorContributions = object.getColorContributions();
        final Button usedButton = new Button(parent, 32);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)usedButton);
        this.addSelectionListener((Widget)usedButton);
        final Combo variableCombo = new Combo(parent, 8);
        variableCombo.setItems(colorContributions.keySet().toArray(new String[colorContributions.size()]));
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)variableCombo);
        final Text minText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)minText);
        this.addSelectionListener((Widget)minText);
        final Text maxText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)maxText);
        this.addSelectionListener((Widget)maxText);
        final Text unit = new Text(parent, 8);
        GridDataFactory.fillDefaults().grab(true, false).hint(30, -1).align(0x1000000, 0x1000000).applyTo((Control)unit);
        final Combo colorMapCombo = new Combo(parent, 8);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)colorMapCombo);
        colorMapCombo.setItems(colorMaps.keySet().toArray(new String[colorMaps.keySet().size()]));
        this.addSelectionListener((Widget)colorMapCombo);
        final Button defaultButton = new Button(parent, 32);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)defaultButton);
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = variableCombo.getSelectionIndex();
                if (index >= 0) {
                    String key = variableCombo.getItem(index);
                    DynamicColorContribution cont = (DynamicColorContribution)colorContributions.get(key);
                    minText.setText(Double.toString(cont.getDefaultMin()));
                    minText.setEnabled(!defaultButton.getSelection());
                    maxText.setText(Double.toString(cont.getDefaultMax()));
                    maxText.setEnabled(!defaultButton.getSelection());
                    unit.setText(cont.getUnit());
                    String[] items = colorMapCombo.getItems();
                    int i = 0;
                    while (i < items.length) {
                        String item = items[i];
                        if (item.equals(cont.getDefaultColorMap().getLabel())) {
                            colorMapCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                    colorMapCombo.setEnabled(!defaultButton.getSelection());
                }
            }
        });
        this.addSelectionListener((Widget)defaultButton);
        variableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = variableCombo.getSelectionIndex();
                if (index >= 0) {
                    String key = variableCombo.getItem(index);
                    DynamicColorContribution cont = (DynamicColorContribution)colorContributions.get(key);
                    if (minText.getText().isEmpty()) {
                        minText.setText(Double.toString(cont.getDefaultMin()));
                    }
                    if (maxText.getText().isEmpty()) {
                        maxText.setText(Double.toString(cont.getDefaultMax()));
                    }
                    unit.setText(cont.getUnit());
                    String[] items = colorMapCombo.getItems();
                    int i = 0;
                    while (i < items.length) {
                        String item = items[i];
                        if (item.equals(cont.getDefaultColorMap().getLabel())) {
                            colorMapCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                    defaultButton.setSelection(true);
                }
            }
        });
        this.addSelectionListener((Widget)variableCombo);
        this.coloringRows.put(object.getColoringObject().getName(), new ColoringObjectRow(label, usedButton, variableCombo, minText, maxText, unit, colorMapCombo, defaultButton));
        return new Supplier<Pair<String, DynamicColorContribution>>(){

            @Override
            public Pair<String, DynamicColorContribution> get() {
                String key;
                DynamicColorContribution cont;
                int selectionIndex = variableCombo.getSelectionIndex();
                if (selectionIndex >= 0 && (cont = (DynamicColorContribution)colorContributions.get(key = variableCombo.getItem(selectionIndex))) != null) {
                    DynamicColorContribution dcc;
                    String label = variableCombo.getItem(variableCombo.getSelectionIndex());
                    if (colorMapCombo.getSelectionIndex() > -1) {
                        String colorMap = colorMapCombo.getItem(colorMapCombo.getSelectionIndex());
                        DynamicColorMap dColorMap = (DynamicColorMap)colorMaps.get(colorMap);
                        dcc = new DynamicColorContribution(label, cont.getModuleName(), cont.getAttributeName(), unit.getText(), cont.getVariableGain(), cont.getVariableBias(), dColorMap, Double.parseDouble(minText.getText()), Double.parseDouble(maxText.getText()));
                    } else {
                        dcc = (DynamicColorContribution)colorContributions.get(label);
                    }
                    dcc.setUsed(usedButton.getSelection());
                    dcc.setUseDefault(defaultButton.getSelection());
                    return Pair.make((Object)object.getColoringObject().getName(), (Object)dcc);
                }
                return null;
            }
        };
    }

    private void createSizingObjectHeaderRow(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Label");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Used");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Variable");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Min");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Max");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Unit");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("SizeMap");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
        label = new Label(parent, 0);
        label.setText("Default");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)label);
    }

    private Supplier<Pair<String, DynamicSizeContribution>> createSizingObjectRow(Composite parent, final DynamicVisualisationsContributions.DynamicSizingObject object, final Map<String, DynamicSizeMap> sizeMaps) {
        Label label = new Label(parent, 0);
        label.setText(object.getSizingObject().getName());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label);
        final Map sizeContributions = object.getSizeContributions();
        final Button usedButton = new Button(parent, 32);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)usedButton);
        this.addSelectionListener((Widget)usedButton);
        final Combo variableCombo = new Combo(parent, 8);
        variableCombo.setItems(sizeContributions.keySet().toArray(new String[sizeContributions.size()]));
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)variableCombo);
        final Text minText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)minText);
        this.addSelectionListener((Widget)minText);
        final Text maxText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)maxText);
        this.addSelectionListener((Widget)maxText);
        final Label unit = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(30, -1).align(0x1000000, 0x1000000).applyTo((Control)unit);
        final Combo sizeMapCombo = new Combo(parent, 8);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).align(0x1000000, 0x1000000).applyTo((Control)sizeMapCombo);
        sizeMapCombo.setItems(sizeMaps.keySet().toArray(new String[sizeMaps.keySet().size()]));
        this.addSelectionListener((Widget)sizeMapCombo);
        final Button defaultButton = new Button(parent, 32);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)defaultButton);
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = variableCombo.getSelectionIndex();
                if (index >= 0) {
                    String key = variableCombo.getItem(index);
                    DynamicSizeContribution cont = (DynamicSizeContribution)sizeContributions.get(key);
                    minText.setText(Double.toString(cont.getDefaultMin()));
                    minText.setEnabled(!defaultButton.getSelection());
                    maxText.setText(Double.toString(cont.getDefaultMax()));
                    maxText.setEnabled(!defaultButton.getSelection());
                    unit.setText(cont.getUnit());
                    String[] items = sizeMapCombo.getItems();
                    int i = 0;
                    while (i < items.length) {
                        String item = items[i];
                        if (item.equals(cont.getDefaultSizeMap().getLabel())) {
                            sizeMapCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                    sizeMapCombo.setEnabled(!defaultButton.getSelection());
                }
            }
        });
        this.addSelectionListener((Widget)defaultButton);
        variableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String key = variableCombo.getItem(variableCombo.getSelectionIndex());
                DynamicSizeContribution cont = (DynamicSizeContribution)sizeContributions.get(key);
                if (minText.getText().isEmpty()) {
                    minText.setText(Double.toString(cont.getDefaultMin()));
                }
                if (maxText.getText().isEmpty()) {
                    maxText.setText(Double.toString(cont.getDefaultMax()));
                }
                unit.setText(cont.getUnit());
                String[] items = sizeMapCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    String item = items[i];
                    if (item.equals(cont.getDefaultSizeMap().getLabel())) {
                        sizeMapCombo.select(i);
                        break;
                    }
                    ++i;
                }
                defaultButton.setSelection(true);
            }
        });
        this.addSelectionListener((Widget)variableCombo);
        this.sizingRows.put(object.getSizingObject().getName(), new SizingObjectRow(label, usedButton, variableCombo, minText, maxText, unit, sizeMapCombo, defaultButton));
        return new Supplier<Pair<String, DynamicSizeContribution>>(){

            @Override
            public Pair<String, DynamicSizeContribution> get() {
                String key;
                DynamicSizeContribution cont;
                int selectionIndex = variableCombo.getSelectionIndex();
                if (selectionIndex >= 0 && (cont = (DynamicSizeContribution)sizeContributions.get(key = variableCombo.getItem(selectionIndex))) != null) {
                    DynamicSizeContribution dsc;
                    String label = variableCombo.getItem(variableCombo.getSelectionIndex());
                    if (sizeMapCombo.getSelectionIndex() > -1) {
                        String sizeMap = sizeMapCombo.getItem(sizeMapCombo.getSelectionIndex());
                        DynamicSizeMap dSizeMap = (DynamicSizeMap)sizeMaps.get(sizeMap);
                        dsc = new DynamicSizeContribution(label, cont.getModuleName(), cont.getAttributeName(), unit.getText(), cont.getVariableGain(), cont.getVariableBias(), dSizeMap, Double.parseDouble(minText.getText()), Double.parseDouble(maxText.getText()));
                    } else {
                        dsc = (DynamicSizeContribution)sizeContributions.get(label);
                    }
                    dsc.setUsed(usedButton.getSelection());
                    dsc.setUseDefault(defaultButton.getSelection());
                    return Pair.make((Object)object.getSizingObject().getName(), (Object)dsc);
                }
                return null;
            }
        };
    }

    private void initializeColorBars(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Color Bars");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(5, 5).applyTo((Composite)group);
        this.createColorBars((Composite)group);
    }

    private void createColorBars(Composite parent) {
        this.showColorButton = new Button(parent, 32);
        this.showColorButton.setText("Show");
        this.addSelectionListener((Widget)this.showColorButton);
        this.colorTicksButton = new Button(parent, 32);
        this.colorTicksButton.setText("Ticks");
        this.addSelectionListener((Widget)this.colorTicksButton);
        this.colorGradientButton = new Button(parent, 32);
        this.colorGradientButton.setText("Gradients");
        this.addSelectionListener((Widget)this.colorGradientButton);
        Label label = new Label(parent, 0);
        label.setText("Location");
        this.colorLocationCombo = new Combo(parent, 8);
        String[] colorLocationItems = (String[])Stream.of(ColorBarOptions.ColorBarsLocation.values()).map(size -> size.toString()).toArray(String[]::new);
        this.colorLocationCombo.setItems(colorLocationItems);
        if (colorLocationItems.length > 0) {
            this.colorLocationCombo.select(0);
        }
        this.addSelectionListener((Widget)this.colorLocationCombo);
        label = new Label(parent, 0);
        label.setText("Size");
        this.colorSizeCombo = new Combo(parent, 8);
        String[] colorSizeItems = (String[])Stream.of(ColorBarOptions.ColorBarsSize.values()).map(size -> size.toString()).toArray(String[]::new);
        this.colorSizeCombo.setItems(colorSizeItems);
        if (colorSizeItems.length > 0) {
            this.colorSizeCombo.select(0);
        }
        this.addSelectionListener((Widget)this.colorSizeCombo);
    }

    private void initializeObjectSizes(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Object Sizes");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(5, 5).applyTo((Composite)group);
        this.createSizingObjectHeaderRow((Composite)group);
        this.createObjectSizes((Composite)group);
    }

    private void createObjectSizes(Composite parent) {
        this.sizeSuppliers = new ArrayList<Supplier<Pair<String, DynamicSizeContribution>>>();
        try {
            Pair resultSizing = (Pair)Simantics.getSession().syncRequest((Read)new UniqueRead<Pair<Collection<DynamicVisualisationsContributions.DynamicSizingObject>, Map<String, DynamicSizeMap>>>(){

                public Pair<Collection<DynamicVisualisationsContributions.DynamicSizingObject>, Map<String, DynamicSizeMap>> perform(ReadGraph graph) throws DatabaseException {
                    Map dynamicSizeMaps = DynamicVisualisationsContributions.dynamicSizeMaps((ReadGraph)graph);
                    return Pair.make((Object)DynamicVisualisationsContributions.dynamicSizingObjects((ReadGraph)graph), (Object)dynamicSizeMaps);
                }
            });
            for (DynamicVisualisationsContributions.DynamicSizingObject object : (Collection)resultSizing.first) {
                this.sizeSuppliers.add(this.createSizingObjectRow(parent, object, (Map)resultSizing.second));
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not create object sizes", (Throwable)e);
        }
    }

    private void initializeSizeBars(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Size Bars");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(5, 5).applyTo((Composite)group);
        this.createSizeBars((Composite)group);
    }

    private void createSizeBars(Composite parent) {
        this.showSizeButton = new Button(parent, 32);
        this.showSizeButton.setText("Show");
        this.addSelectionListener((Widget)this.showSizeButton);
        this.sizeTicksButton = new Button(parent, 32);
        this.sizeTicksButton.setText("Ticks");
        this.addSelectionListener((Widget)this.sizeTicksButton);
        this.sizeGradientButton = new Button(parent, 32);
        this.sizeGradientButton.setText("Gradient");
        this.addSelectionListener((Widget)this.sizeGradientButton);
        Label label = new Label(parent, 0);
        label.setText("Location");
        this.sizeLocationCombo = new Combo(parent, 8);
        String[] sizeLocationItems = (String[])Stream.of(SizeBarOptions.SizeBarsLocation.values()).map(size -> size.toString()).toArray(String[]::new);
        this.sizeLocationCombo.setItems(sizeLocationItems);
        if (sizeLocationItems.length > 0) {
            this.sizeLocationCombo.select(0);
        }
        this.addSelectionListener((Widget)this.sizeLocationCombo);
        label = new Label(parent, 0);
        label.setText("Size");
        this.sizeSizeCombo = new Combo(parent, 8);
        String[] sizeSizeItems = (String[])Stream.of(SizeBarOptions.SizeBarsSize.values()).map(size -> size.toString()).toArray(String[]::new);
        this.sizeSizeCombo.setItems(sizeSizeItems);
        if (sizeSizeItems.length > 0) {
            this.sizeSizeCombo.select(0);
        }
        this.addSelectionListener((Widget)this.sizeSizeCombo);
    }

    private void addSelectionListener(Widget widget) {
        if (widget instanceof Button) {
            ((Button)widget).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DynamicVisualisationsUI.this.persistCurrentVisualisationTemplateIfAvailable();
                }
            });
        } else if (widget instanceof Combo) {
            ((Combo)widget).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DynamicVisualisationsUI.this.persistCurrentVisualisationTemplateIfAvailable();
                }
            });
        } else if (widget instanceof Text) {
            ((Text)widget).addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    DynamicVisualisationsUI.this.persistCurrentVisualisationTemplateIfAvailable();
                }
            });
            ((Text)widget).addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 10) {
                        DynamicVisualisationsUI.this.persistCurrentVisualisationTemplateIfAvailable();
                    }
                }
            });
        }
    }

    public void setParentResource(Resource parentResource) {
        if (this.parentResource != parentResource) {
            this.parentResource = parentResource;
            this.updateListening();
        }
        this.saveVisualisationTemplateAsButton.setEnabled(parentResource != null);
    }

    private void updateListening() {
        if (this.visualisationsListener != null) {
            this.visualisationsListener.dispose();
        }
        if (this.parentResource != null) {
            this.visualisationsListener = new VisualisationsListener(this);
            Simantics.getSession().asyncRequest((Read)new DynamicVisualisationsRequest(this.parentResource), (Listener)this.visualisationsListener);
        }
        if (this.listener != null) {
            this.listener.dispose();
        }
        if (this.parentResource != null) {
            this.listener = new VisualisationListener(this);
            Simantics.getSession().asyncRequest((Read)new ActiveDynamicVisualisationsRequest(this.parentResource), (Listener)this.listener);
        }
    }

    public void updateVisualisation(DynamicVisualisation result) {
        this.visualisation = result;
        Display.getDefault().asyncExec(() -> {
            if (this.getParent().isDisposed()) {
                return;
            }
            this.removeVisualisationTemplateButton.setEnabled(this.visualisation != null && this.visualisation.getVisualisationResource() != null);
            if (this.visualisation != null) {
                String item;
                String item2;
                String[] items = this.templateSelectionCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (this.visualisation.getName().equals(items[i])) {
                        this.templateSelectionCombo.select(i);
                        break;
                    }
                    ++i;
                }
                this.intervalText.setText(Double.toString((double)this.visualisation.getInterval() / 1000.0));
                this.disableUpdatesButton.setSelection(this.visualisation.disabledUpdates());
                this.hoveringVertexEnabledButton.setSelection(this.visualisation.isKeyVariablesVertexHover());
                this.hoveringEdgesEnabledButton.setSelection(this.visualisation.isKeyVariablesEdgesHover());
                this.showConnectedComponentsButton.setSelection(this.visualisation.showConnectedComponents());
                this.notInSimulationButton.setSelection(this.visualisation.isInSimulation());
                this.elevationServerEnabledButton.setSelection(this.visualisation.isShowElevationServerBoundingBox());
                this.hideConsumersButton.setSelection(this.visualisation.isHideConsumers());
                this.hideEdgesButton.setSelection(this.visualisation.isHideEdges());
                this.hideProducersButton.setSelection(this.visualisation.isHideProducers());
                this.hideValvesButton.setSelection(this.visualisation.isHideValves());
                this.hidePumpingStationsButton.setSelection(this.visualisation.isHidePumpingStations());
                this.hidePointsButton.setSelection(this.visualisation.isHidePoints());
                Map colorContributions = this.visualisation.getColorContributions();
                for (Map.Entry entry : colorContributions.entrySet()) {
                    ColoringObjectRow coloringObjectRow = this.coloringRows.get(entry.getKey());
                    if (coloringObjectRow != null) {
                        coloringObjectRow.update((DynamicColorContribution)entry.getValue());
                        continue;
                    }
                    LOGGER.info("No coloring object visualisation row for key {}", entry.getKey());
                }
                ColorBarOptions colorOptions = this.visualisation.getColorBarOptions();
                this.showColorButton.setSelection(colorOptions.isShowColorBars());
                this.colorTicksButton.setSelection(colorOptions.isShowColorBarsTicks());
                this.colorGradientButton.setSelection(colorOptions.isUseGradients());
                int i2 = 0;
                while (i2 < this.colorLocationCombo.getItems().length) {
                    item2 = this.colorLocationCombo.getItem(i2);
                    if (item2.equals(colorOptions.getLocation().toString())) {
                        this.colorLocationCombo.select(i2);
                        break;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.colorSizeCombo.getItems().length) {
                    item2 = this.colorSizeCombo.getItem(i2);
                    if (item2.equals(colorOptions.getSize().toString())) {
                        this.colorSizeCombo.select(i2);
                        break;
                    }
                    ++i2;
                }
                Map sizeContributions = this.visualisation.getSizeContributions();
                for (Map.Entry entry : sizeContributions.entrySet()) {
                    SizingObjectRow sizingObjectRow = this.sizingRows.get(entry.getKey());
                    if (sizingObjectRow != null) {
                        sizingObjectRow.update((DynamicSizeContribution)entry.getValue());
                        continue;
                    }
                    LOGGER.info("No sizing object visualisation row for key {}", entry.getKey());
                }
                SizeBarOptions sizeOptions = this.visualisation.getSizeBarOptions();
                this.showSizeButton.setSelection(sizeOptions.isShowSizeBars());
                this.sizeTicksButton.setSelection(sizeOptions.isShowSizeBarsTicks());
                this.sizeGradientButton.setSelection(sizeOptions.isUseGradients());
                int i3 = 0;
                while (i3 < this.sizeLocationCombo.getItems().length) {
                    item = this.sizeLocationCombo.getItem(i3);
                    if (item.equals(sizeOptions.getLocation().toString())) {
                        this.sizeLocationCombo.select(i3);
                        break;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < this.sizeSizeCombo.getItems().length) {
                    item = this.sizeSizeCombo.getItem(i3);
                    if (item.equals(sizeOptions.getSize().toString())) {
                        this.sizeSizeCombo.select(i3);
                        break;
                    }
                    ++i3;
                }
                this.pointsStaticPropertiesButton.setSelection(this.visualisation.isStaticPropertiesPoints());
                this.networkBranchesStaticPropertiesButton.setSelection(this.visualisation.isStaticPropertiesNetworkBranches());
                this.consumersStaticPropertiesButton.setSelection(this.visualisation.isStaticPropertiesConsumers());
            }
        });
    }

    public void updateVisualisations(Collection<NamedResource> result) {
        this.visualisations = result;
        Display.getDefault().asyncExec(() -> {
            if (this.getParent().isDisposed()) {
                return;
            }
            List<String> templateItems = this.visualisations.stream().map(NamedResource::getName).collect(Collectors.toList());
            templateItems.add(0, "<empty>");
            String[] templateItemsArray = templateItems.toArray(new String[this.visualisations.size()]);
            this.templateSelectionCombo.setItems(templateItemsArray);
            if (this.visualisation != null) {
                String[] items = this.templateSelectionCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (this.visualisation.getName().equals(items[i])) {
                        this.templateSelectionCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
        });
    }

    public Composite getParent() {
        return this.parent;
    }

    private static class ArrowObjectRow {
        private final Label label;
        private final Button usedButton;
        private final Combo variableCombo;
        private final Text gainText;
        private final Text biasText;
        private final Button defaultButton;

        public ArrowObjectRow(Label label, Button usedButton, Combo variableCombo, Text gainText, Text biasText, Button defaultButton) {
            this.label = label;
            this.usedButton = usedButton;
            this.variableCombo = variableCombo;
            this.gainText = gainText;
            this.biasText = biasText;
            this.defaultButton = defaultButton;
        }

        public void update(DynamicColorContribution colorContribution) {
            String[] items = this.variableCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (colorContribution.getLabel().equals(items[i])) {
                    this.variableCombo.select(i);
                    break;
                }
                ++i;
            }
            this.gainText.setText(Double.toString(colorContribution.getDefaultMin()));
            this.biasText.setText(Double.toString(colorContribution.getDefaultMax()));
            this.usedButton.setSelection(colorContribution.isUsed());
            this.defaultButton.setSelection(colorContribution.isUseDefault());
            this.gainText.setEnabled(!colorContribution.isUseDefault());
            this.biasText.setEnabled(!colorContribution.isUseDefault());
        }
    }

    private static class ColoringObjectRow {
        private final Label label;
        private final Button usedButton;
        private final Combo variableCombo;
        private final Text minText;
        private final Text maxText;
        private final Text unit;
        private final Combo colorMapCombo;
        private final Button defaultButton;

        public ColoringObjectRow(Label label, Button usedButton, Combo variableCombo, Text minText, Text maxText, Text unit, Combo colorMapCombo, Button defaultButton) {
            this.label = label;
            this.usedButton = usedButton;
            this.variableCombo = variableCombo;
            this.minText = minText;
            this.maxText = maxText;
            this.unit = unit;
            this.colorMapCombo = colorMapCombo;
            this.defaultButton = defaultButton;
        }

        public void update(DynamicColorContribution colorContribution) {
            String[] items = this.variableCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (colorContribution.getLabel().equals(items[i])) {
                    this.variableCombo.select(i);
                    break;
                }
                ++i;
            }
            this.minText.setText(Double.toString(colorContribution.getDefaultMin()));
            this.maxText.setText(Double.toString(colorContribution.getDefaultMax()));
            this.unit.setText(colorContribution.getUnit());
            String[] colorItems = this.colorMapCombo.getItems();
            int i2 = 0;
            while (i2 < colorItems.length) {
                if (colorContribution.getDefaultColorMap().getLabel().equals(colorItems[i2])) {
                    this.colorMapCombo.select(i2);
                    break;
                }
                ++i2;
            }
            this.usedButton.setSelection(colorContribution.isUsed());
            this.defaultButton.setSelection(colorContribution.isUseDefault());
            this.minText.setEnabled(!colorContribution.isUseDefault());
            this.maxText.setEnabled(!colorContribution.isUseDefault());
            this.colorMapCombo.setEnabled(!colorContribution.isUseDefault());
        }
    }

    private static class SizingObjectRow {
        private final Label label;
        private final Button usedButton;
        private final Combo variableCombo;
        private final Text minText;
        private final Text maxText;
        private final Label unit;
        private final Combo sizeMapCombo;
        private final Button defaultButton;

        public SizingObjectRow(Label label, Button usedButton, Combo variableCombo, Text minText, Text maxText, Label unit, Combo sizeMapCombo, Button defaultButton) {
            this.label = label;
            this.usedButton = usedButton;
            this.variableCombo = variableCombo;
            this.minText = minText;
            this.maxText = maxText;
            this.unit = unit;
            this.sizeMapCombo = sizeMapCombo;
            this.defaultButton = defaultButton;
        }

        public void update(DynamicSizeContribution sizeContribution) {
            String[] items = this.variableCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (sizeContribution.getLabel().equals(items[i])) {
                    this.variableCombo.select(i);
                    break;
                }
                ++i;
            }
            this.minText.setText(Double.toString(sizeContribution.getDefaultMin()));
            this.maxText.setText(Double.toString(sizeContribution.getDefaultMax()));
            this.unit.setText(sizeContribution.getUnit());
            String[] sizeItems = this.sizeMapCombo.getItems();
            int i2 = 0;
            while (i2 < sizeItems.length) {
                if (sizeContribution.getDefaultSizeMap().getLabel().equals(sizeItems[i2])) {
                    this.sizeMapCombo.select(i2);
                    break;
                }
                ++i2;
            }
            this.usedButton.setSelection(sizeContribution.isUsed());
            this.defaultButton.setSelection(sizeContribution.isUseDefault());
            this.minText.setEnabled(!sizeContribution.isUseDefault());
            this.maxText.setEnabled(!sizeContribution.isUseDefault());
            this.sizeMapCombo.setEnabled(!sizeContribution.isUseDefault());
        }
    }

    private static class VisualisationListener
    implements Listener<DynamicVisualisation> {
        private static final Logger LOGGER = LoggerFactory.getLogger(VisualisationListener.class);
        private boolean disposed;
        private DynamicVisualisationsUI ui;

        public VisualisationListener(DynamicVisualisationsUI ui) {
            this.ui = ui;
        }

        public void execute(DynamicVisualisation result) {
            this.ui.updateVisualisation(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen visualisation", t);
        }

        public boolean isDisposed() {
            return this.disposed || this.ui.getParent().isDisposed();
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    private static class VisualisationsListener
    implements Listener<Collection<NamedResource>> {
        private static final Logger LOGGER = LoggerFactory.getLogger(VisualisationsListener.class);
        private boolean disposed;
        private DynamicVisualisationsUI ui;

        public VisualisationsListener(DynamicVisualisationsUI ui) {
            this.ui = ui;
        }

        public void execute(Collection<NamedResource> result) {
            this.ui.updateVisualisations(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen visualisation", t);
        }

        public boolean isDisposed() {
            return this.disposed || this.ui.getParent().isDisposed();
        }

        public void dispose() {
            this.disposed = true;
        }
    }
}

