/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.techtype.table;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.techtype.TechTypeUtils;
import org.simantics.district.network.techtype.requests.PossibleTechTypeTable;
import org.simantics.district.network.ui.techtype.table.TechTypeTable;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.gfx.HSVAdjustmentImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechTypeTableView {
    private static final String CMD_RESET_COMPONENT_PROPERTIES = "org.simantics.district.network.ui.command.resetcomponentproperties";
    private static final String CMD_IMPORT_CSV = "org.simantics.district.network.ui.command.importtechtypecsv";
    private static final String CMD_VALIDATE_TABLE = "org.simantics.district.network.ui.command.validatetechtypetable";
    private static final Logger LOGGER = LoggerFactory.getLogger(TechTypeTableView.class);
    public static final String ID = "org.simantics.district.network.ui.techtype.table.techtypeTableView";
    private static final String KEY_MODE = "mode";
    private static final String KEY_TABLE = "tableResource";
    private static final String KEY_COMPONENT_TYPE = "componentTypeResource";
    @Inject
    IEclipseContext context;
    @Inject
    ESelectionService selectionService;
    @Inject
    MPart part;
    private ResourceManager resourceManager;
    private ImageDescriptor lockedImage;
    private ImageDescriptor unlockedImage;
    private Button modeButton;
    private Label tableLocationLabel;
    private Combo componentTypeCombo;
    private TechTypeTable table;
    private Mode mode = Mode.SHOW_ACTIVE_MODEL_TABLE_BY_COMPONENT_TYPE;
    private TableData data = TableData.SENTINEL;
    private TableDataListener currentTableDataListener;
    private MHandledToolItem validateTableItem;
    private MHandledToolItem resetComponentPropertiesItem;

    private void disposeTableDataListener() {
        if (this.currentTableDataListener != null) {
            this.currentTableDataListener.dispose();
            this.currentTableDataListener = null;
        }
    }

    private static Mode parseMode(String s, Mode defaultMode) {
        try {
            return s != null ? Mode.valueOf(s) : defaultMode;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultMode;
        }
    }

    private static Resource parseResource(String resourceId) {
        block3: {
            if (resourceId != null && !resourceId.isEmpty()) break block3;
            return null;
        }
        try {
            long rid = Long.parseUnsignedLong(resourceId, 10);
            return ((SerialisationSupport)Simantics.getSession().getService(SerialisationSupport.class)).getResource(rid);
        }
        catch (NumberFormatException | DatabaseException | ServiceNotFoundException throwable) {
            return null;
        }
    }

    private static Mode getStateMode(MPart element, String key, Mode defaultMode) {
        return TechTypeTableView.parseMode((String)element.getPersistedState().get(key), defaultMode);
    }

    private static void setStateValue(MPart element, String key, Object value) {
        element.getPersistedState().put(key, value.toString());
    }

    private static Resource getStateResource(MPart element, String key) {
        return TechTypeTableView.parseResource((String)element.getPersistedState().get(key));
    }

    private static void setStateResource(MPart element, String key, Resource input) {
        if (input != null) {
            TechTypeTableView.setStateValue(element, key, Long.toUnsignedString(input.getResourceId()));
        } else {
            element.getPersistedState().remove(key);
        }
    }

    @Inject
    public void init(MApplication app) {
        MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
        toolBar.setToBeRendered(true);
        toolBar.getChildren().add(this.createImportCSVDataToolItem(app));
        toolBar.getChildren().add(this.createValidateTableToolItem(app));
        toolBar.getChildren().add(this.createResetComponentsItem(app));
        this.part.setToolbar(toolBar);
        this.part.getTags().add("removeOnHide");
    }

    private MHandledToolItem createValidateTableToolItem(MApplication app) {
        this.validateTableItem = MMenuFactory.INSTANCE.createHandledToolItem();
        this.validateTableItem.setElementId(UUID.randomUUID().toString());
        MCommand command = app.getCommand(CMD_VALIDATE_TABLE);
        this.validateTableItem.setCommand(command);
        this.validateTableItem.setLabel("Validate Tech Type Table");
        this.validateTableItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/accept.png");
        return this.validateTableItem;
    }

    private MHandledToolItem createImportCSVDataToolItem(MApplication app) {
        MHandledToolItem createHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        MCommand command = app.getCommand(CMD_IMPORT_CSV);
        createHandledToolItem.setCommand(command);
        createHandledToolItem.setLabel("Import Tech Type");
        createHandledToolItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/table_edit.png");
        return createHandledToolItem;
    }

    private MToolBarElement createResetComponentsItem(MApplication app) {
        this.resetComponentPropertiesItem = MMenuFactory.INSTANCE.createHandledToolItem();
        this.resetComponentPropertiesItem.setElementId(UUID.randomUUID().toString());
        MCommand command = app.getCommand(CMD_RESET_COMPONENT_PROPERTIES);
        this.resetComponentPropertiesItem.setCommand(command);
        this.resetComponentPropertiesItem.setLabel("Reset Component Properties");
        this.resetComponentPropertiesItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/database_go.png");
        return this.resetComponentPropertiesItem;
    }

    private static NamedResource resolveDefaultComponentType(List<NamedResource> componentTypes) {
        return componentTypes.stream().filter(r -> r.getName().toLowerCase().contains("pipe")).findFirst().orElse(null);
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.part.getTags().add("removeOnHide");
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.lockedImage = BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/lock.png");
        this.unlockedImage = HSVAdjustmentImageDescriptor.adjust((ImageDescriptor)BundleUtils.getImageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/lock_open.png"), (float)0.0f, (float)0.7f, (float)0.8f);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.createContentBar(parent);
        this.table = new TechTypeTable(parent, 0);
        Mode mode = TechTypeTableView.getStateMode(this.part, KEY_MODE, Mode.SHOW_ACTIVE_MODEL_TABLE_BY_COMPONENT_TYPE);
        Resource previousTable = TechTypeTableView.getStateResource(this.part, KEY_TABLE);
        if (mode == Mode.SHOW_SPECIFIED_TABLE && previousTable != null) {
            this.setTableResource(previousTable);
        } else {
            this.setComponentType(null);
        }
        this.modeButton.setSelection(mode != Mode.SHOW_ACTIVE_MODEL_TABLE_BY_COMPONENT_TYPE);
        this.refreshModeControls();
    }

    private void createContentBar(Composite parent) {
        Composite contentComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)contentComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(3, 3).applyTo(contentComposite);
        this.modeButton = new Button(contentComposite, 2);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)this.modeButton);
        this.modeButton.setImage((Image)this.resourceManager.get((DeviceResourceDescriptor)this.unlockedImage));
        this.modeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean locked = this.modeButton.getSelection();
            this.mode = locked ? Mode.SHOW_SPECIFIED_TABLE : Mode.SHOW_ACTIVE_MODEL_TABLE_BY_COMPONENT_TYPE;
            this.refreshModeControls();
            if (locked) {
                this.setTableResource(this.data.table != null ? this.data.table.getResource() : null);
            } else {
                this.setComponentType(this.data.componentType != null ? this.data.componentType.getResource() : null);
            }
        }));
        Label ctLabel = new Label(contentComposite, 0);
        ctLabel.setText("Table for");
        GridDataFactory.fillDefaults().grab(false, true).align(131072, 0x1000000).applyTo((Control)ctLabel);
        this.componentTypeCombo = new Combo(contentComposite, 12);
        this.componentTypeCombo.setToolTipText("Selects the table component type binding");
        GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)this.componentTypeCombo);
        this.componentTypeCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String selectedType = this.componentTypeCombo.getText();
            NamedResource nr = (NamedResource)this.componentTypeCombo.getData(selectedType);
            if (nr != null) {
                this.setComponentType(nr.getResource());
            }
        }));
        this.tableLocationLabel = new Label(contentComposite, 0);
        this.tableLocationLabel.setToolTipText("Shows the location of this table");
        GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)this.tableLocationLabel);
    }

    @PreDestroy
    public void dispose() {
        this.disposeTableDataListener();
        this.table.dispose();
    }

    private void setTableData(TableData r) {
        NamedResource selectedComponentType;
        LOGGER.debug("New tech type table data in mode {}: {}", (Object)this.mode, (Object)r);
        boolean componentTypesChanged = !Objects.equals(this.data.availableComponentTypes, r.availableComponentTypes);
        this.data = r;
        this.table.setTable(r.table != null ? r.table.getResource() : null);
        this.table.setComponentType(r.componentType != null ? r.componentType.getResource() : null);
        this.table.setTechTypeData(r.data, r.enabled);
        this.table.setValidationResult(null);
        this.tableLocationLabel.setText(r.indexRoot != null ? (r.table != null ? NLS.bind((String)"in {0}", (Object)r.table.getName()) : NLS.bind((String)"not defined in {0}", (Object)r.indexRoot.getName())) : "not available without active model");
        if (componentTypesChanged) {
            this.componentTypeCombo.removeAll();
            r.availableComponentTypes.forEach(nr -> {
                this.componentTypeCombo.add(nr.getName());
                this.componentTypeCombo.setData(nr.getName(), nr);
            });
        }
        NamedResource namedResource = selectedComponentType = r.componentType != null ? r.componentType : TechTypeTableView.resolveDefaultComponentType(r.availableComponentTypes);
        if (selectedComponentType != null) {
            int ctCount = r.availableComponentTypes.size();
            int i = 0;
            while (i < ctCount) {
                NamedResource nr2 = r.availableComponentTypes.get(i);
                if (nr2.getResource().equals(selectedComponentType.getResource())) {
                    this.componentTypeCombo.select(i);
                    break;
                }
                ++i;
            }
        }
        this.refreshModeControls();
        this.updateActions();
    }

    private void refreshModeControls() {
        boolean locked = this.mode == Mode.SHOW_SPECIFIED_TABLE;
        this.modeButton.setImage((Image)this.resourceManager.get((DeviceResourceDescriptor)(locked ? this.lockedImage : this.unlockedImage)));
        this.modeButton.setToolTipText(locked ? "Unlock Current Model and Component Type Selection to Track Active Model" : "Lock Current Model and Component Type Selection");
        if (this.mode == Mode.SHOW_ACTIVE_MODEL_TABLE_BY_COMPONENT_TYPE) {
            this.modeButton.setEnabled(this.data.table != null);
        } else {
            this.modeButton.setEnabled(true);
        }
        this.componentTypeCombo.setEnabled(!locked);
    }

    private void setTableResource(Resource tableResource) {
        this.disposeTableDataListener();
        this.currentTableDataListener = new TableDataListener(this);
        Simantics.getSession().asyncRequest((Read)new TableDataRequest(tableResource), (Listener)this.currentTableDataListener);
        this.mode = Mode.SHOW_SPECIFIED_TABLE;
        TechTypeTableView.setStateValue(this.part, KEY_MODE, (Object)this.mode);
        TechTypeTableView.setStateResource(this.part, KEY_TABLE, tableResource);
        TechTypeTableView.setStateResource(this.part, KEY_COMPONENT_TYPE, null);
    }

    private void setComponentType(Resource componentType) {
        this.disposeTableDataListener();
        this.currentTableDataListener = new TableDataListener(this);
        Simantics.getSession().asyncRequest((Read)new ComponentTypeTableDataRequest(componentType), (Listener)this.currentTableDataListener);
        this.mode = Mode.SHOW_ACTIVE_MODEL_TABLE_BY_COMPONENT_TYPE;
        TechTypeTableView.setStateValue(this.part, KEY_MODE, (Object)this.mode);
        TechTypeTableView.setStateResource(this.part, KEY_TABLE, null);
        TechTypeTableView.setStateResource(this.part, KEY_COMPONENT_TYPE, componentType);
    }

    public TechTypeTable getTable() {
        return this.table;
    }

    public void setTechTypePath(String path, Charset charset) {
        if (this.data.componentType != null) {
            try {
                TechTypeUtils.loadTechTypeTable((Resource)this.data.componentType.getResource(), (String)path, (Charset)charset);
            }
            catch (IOException | DatabaseException e) {
                LOGGER.error("Failed to set new data for tech type table of component type {}", (Object)this.data.componentType, (Object)e);
            }
        } else {
            LOGGER.warn("componentType is null and therefore tech type table can not be imported");
        }
    }

    private static Read<Resource> tableComponentTypeReader(Resource tableResource) {
        return new ResourceRead<Resource>(tableResource){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                return graph.getPossibleObject(this.resource, DistrictNetworkResource.getInstance((ReadGraph)graph).TechType_TechTypeTable_HasComponentType);
            }
        };
    }

    private static NamedResource getLabel(ReadGraph graph, Resource r) throws DatabaseException {
        return r != null ? new NamedResource(NameLabelUtil.modalName((ReadGraph)graph, (Resource)r, (NameLabelMode)NameLabelMode.NAME), r) : null;
    }

    private static NamedResource getRelativePath(ReadGraph graph, Resource r) throws DatabaseException {
        if (r == null) {
            return null;
        }
        Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
        if (root == null) {
            return null;
        }
        String rootLabel = NameLabelUtil.modalName((ReadGraph)graph, (Resource)root);
        return new NamedResource(rootLabel, r);
    }

    private void updateActions() {
        IEventBroker eventBroker = (IEventBroker)this.context.get(IEventBroker.class);
        eventBroker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)this.validateTableItem.getElementId());
        eventBroker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)this.resetComponentPropertiesItem.getElementId());
    }

    public static void openTechTypeTable(Resource tableResource) {
        IEclipseContext eclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        if (eclipseContext == null) {
            LOGGER.error("No Eclipse context available");
            return;
        }
        EPartService partService = (EPartService)(eclipseContext = eclipseContext.getActiveLeaf()).get(EPartService.class);
        if (partService == null) {
            return;
        }
        Collection parts = partService.getParts();
        for (MPart p : parts) {
            Resource partTable;
            if (!ID.equals(p.getElementId()) || !tableResource.equals(partTable = TechTypeTableView.getStateResource(p, KEY_TABLE))) continue;
            partService.activate(p, true);
            return;
        }
        MPart part = partService.createPart(ID);
        TechTypeTableView.setStateValue(part, KEY_MODE, (Object)Mode.SHOW_SPECIFIED_TABLE);
        TechTypeTableView.setStateResource(part, KEY_TABLE, tableResource);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
    }

    private static class ComponentTypeTableDataRequest
    extends UniqueRead<TableData> {
        private final Resource resource;

        private ComponentTypeTableDataRequest(Resource componentType) {
            this.resource = componentType;
        }

        public TableData perform(ReadGraph graph) throws DatabaseException {
            Resource model = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
            Resource componentType = this.resource;
            if (componentType == null) {
                List available = model != null ? DistrictNetworkUtil.getDistrictComponents((RequestProcessor)graph, (Resource)model) : Collections.emptyList();
                NamedResource def = TechTypeTableView.resolveDefaultComponentType(available);
                if (def == null) {
                    return new TableData(available, TechTypeTableView.getLabel(graph, model));
                }
                componentType = def.getResource();
            }
            Resource table = model != null ? (Resource)graph.syncRequest((Read)new PossibleTechTypeTable(model, componentType)) : null;
            List cts = model != null ? DistrictNetworkUtil.getDistrictComponents((RequestProcessor)graph, (Resource)model) : DistrictNetworkUtil.getDistrictComponents((RequestProcessor)graph);
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            String data = table != null ? (String)graph.getRelatedValue2(table, DN.TechType_TechTypeTable_HasData) : null;
            int[] enabled = table != null ? (int[])graph.getRelatedValue2(table, DN.TechType_TechTypeTable_HasEnabledItems) : null;
            return new TableData(cts, TechTypeTableView.getLabel(graph, model), TechTypeTableView.getLabel(graph, componentType), TechTypeTableView.getRelativePath(graph, table), data, enabled);
        }
    }

    static enum Mode {
        SHOW_ACTIVE_MODEL_TABLE_BY_COMPONENT_TYPE,
        SHOW_SPECIFIED_TABLE;

    }

    private static class TableData {
        public static final TableData SENTINEL = new TableData(Collections.emptyList(), null, null, null, null, null);
        public final List<NamedResource> availableComponentTypes;
        public final NamedResource indexRoot;
        public final NamedResource componentType;
        public final NamedResource table;
        public final String data;
        public final int[] enabled;

        public TableData(List<NamedResource> availableComponentTypes, NamedResource indexRoot) {
            this(availableComponentTypes, indexRoot, null, null, null, null);
        }

        public TableData(List<NamedResource> availableComponentTypes, NamedResource indexRoot, NamedResource componentType, NamedResource table, String data, int[] enabled) {
            assert (availableComponentTypes != null);
            this.availableComponentTypes = availableComponentTypes;
            this.indexRoot = indexRoot;
            this.componentType = componentType;
            this.table = table;
            this.data = data;
            this.enabled = enabled;
        }

        public String toString() {
            return String.format("TableData [available component types=%d, root=%s, componentType=%s, table=%s, data length=%d bytes, enabled entries=%d]", this.availableComponentTypes.size(), this.indexRoot, this.componentType, this.table, this.data != null ? this.data.length() : 0, this.enabled != null ? this.enabled.length : 0);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.enabled);
            result = 31 * result + Objects.hash(this.indexRoot, this.componentType, this.data, this.table, this.availableComponentTypes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableData other = (TableData)obj;
            return Objects.equals(this.indexRoot, other.indexRoot) && Objects.equals(this.componentType, other.componentType) && Objects.equals(this.table, other.table) && Objects.equals(this.data, other.data) && Arrays.equals(this.enabled, other.enabled) && Objects.equals(this.availableComponentTypes, other.availableComponentTypes);
        }
    }

    private static class TableDataListener
    extends DisposableListener<TableData> {
        private TechTypeTableView view;

        public TableDataListener(TechTypeTableView view) {
            this.view = view;
        }

        public void execute(TableData r) {
            TechTypeTableView v = this.view;
            if (v == null) {
                return;
            }
            SWTUtils.asyncExec((Widget)v.getTable(), () -> {
                if (!v.getTable().isDisposed()) {
                    this.view.setTableData(r);
                }
            });
        }

        public void dispose() {
            super.dispose();
            this.view = null;
        }

        public void exception(Throwable t) {
            LOGGER.error("Error updating Tech Type Table data", t);
        }
    }

    private static class TableDataRequest
    extends UniqueRead<TableData> {
        private final Resource resource;

        private TableDataRequest(Resource table) {
            this.resource = table;
        }

        public TableData perform(ReadGraph graph) throws DatabaseException {
            Resource root;
            Resource resource = root = this.resource != null ? (Resource)graph.syncRequest((Read)new PossibleIndexRoot(this.resource)) : null;
            if (root == null) {
                return new TableData(DistrictNetworkUtil.getDistrictComponents((RequestProcessor)graph), null);
            }
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            List cts = DistrictNetworkUtil.getDistrictComponents((RequestProcessor)graph, (Resource)root);
            Resource componentType = (Resource)graph.syncRequest(TechTypeTableView.tableComponentTypeReader(this.resource));
            String data = (String)graph.getRelatedValue2(this.resource, DN.TechType_TechTypeTable_HasData);
            int[] enabled = (int[])graph.getRelatedValue2(this.resource, DN.TechType_TechTypeTable_HasEnabledItems);
            return new TableData(cts, TechTypeTableView.getLabel(graph, root), TechTypeTableView.getLabel(graph, componentType), TechTypeTableView.getRelativePath(graph, this.resource), data, enabled);
        }
    }
}

