/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.table;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ui.function.Functions;
import org.simantics.district.network.ui.table.DistrictCSVTableView;
import org.simantics.modeling.ModelingResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCSVHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportCSVHandler.class);
    @Inject
    EPartService partService;

    @Execute
    public void execute(@Named(value="activeShell") Shell s) {
        MPart activePart = this.partService.getActivePart();
        Object object = activePart.getObject();
        DistrictCSVTableView view = (DistrictCSVTableView)object;
        final String[][] data = view.getCurrentData();
        SelectionDialog d = new SelectionDialog(s);
        if (d.open() == 1) {
            return;
        }
        String sourceEPSGCRS = d.getSourceCRS();
        final Resource targetDiagram = d.getTargetDiagram();
        final Resource mappingType = d.getMappingType();
        try {
            MathTransform transform = null;
            if (sourceEPSGCRS != null && !sourceEPSGCRS.isEmpty()) {
                CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEPSGCRS);
                CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
                transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)false);
            }
            final MathTransform finalTransform = transform;
            final int x = this.xColumn(data);
            final int y = this.yColumn(data);
            final int z = this.zColumn(data);
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    int i = 1;
                    while (i < data.length) {
                        try {
                            String[] rows = data[i];
                            String xCoords = rows[x];
                            String yCoords = rows[y];
                            double xCoord = Double.parseDouble(xCoords);
                            double yCoord = Double.parseDouble(yCoords);
                            DirectPosition2D targetPos = new DirectPosition2D();
                            DirectPosition2D sourcePos = new DirectPosition2D(xCoord, yCoord);
                            DirectPosition res = finalTransform.transform((DirectPosition)sourcePos, (DirectPosition)targetPos);
                            double[] coords = res.getCoordinate();
                            ImportCSVHandler.flipAxes(coords);
                            DistrictNetworkUtil.createVertex((WriteGraph)graph, (Resource)targetDiagram, (double[])coords, (double)z, (Resource)mappingType);
                        }
                        catch (Exception e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        ++i;
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private static void flipAxes(double[] coords) {
        double tmp = coords[0];
        coords[0] = coords[1];
        coords[1] = tmp;
    }

    private int zColumn(String[][] data) {
        return this.column("z", data);
    }

    private int yColumn(String[][] data) {
        return this.column("y", data);
    }

    private int xColumn(String[][] data) {
        return this.column("x", data);
    }

    private int column(String expected, String[][] data) {
        String[] columns = data[0];
        int i = 0;
        while (i < columns.length) {
            String col = columns[i];
            if (col.equals(expected)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class SelectionDialog
    extends SelectionStatusDialog {
        private Map<String, Resource> diagrams = new HashMap<String, Resource>();
        private Map<String, Resource> vertexMappings = new HashMap<String, Resource>();
        private Composite composite;
        private Combo networkDiagramSelectionCombo;
        private Combo sourceCRSCombo;
        private Combo vertexMappingCombo;
        private String sourceCRS;
        private Resource diagram;
        private Resource mapping;

        public SelectionDialog(Shell parent) {
            super(parent);
        }

        public Resource getMappingType() {
            return this.mapping;
        }

        public Resource getTargetDiagram() {
            return this.diagram;
        }

        public String getSourceCRS() {
            return "EPSG:" + this.sourceCRS;
        }

        protected Control createDialogArea(Composite parent) {
            this.composite = (Composite)super.createDialogArea(parent);
            this.createMappingsGroup(this.composite);
            this.computeContent();
            return this.composite;
        }

        private void computeContent() {
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot((Resource)graph.sync((ReadInterface)new PossibleActiveModel(Simantics.getProjectResource()))));
                    vertexMappings = Functions.getVertexMappings(graph, indexRoot);
                    Collection<Resource> diagramss = Functions.getDistrictDiagrams(graph);
                    ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                    Resource projectResource = Simantics.getProjectResource();
                    String projectURI = graph.getURI(projectResource);
                    for (Resource diagram : diagramss) {
                        Resource composite = graph.getSingleObject(diagram, MOD.DiagramToComposite);
                        String compositeURI = graph.getURI(composite);
                        String path = compositeURI.replace(projectURI, "");
                        diagrams.put(path, diagram);
                    }
                    composite.getDisplay().asyncExec(() -> {
                        vertexMappingCombo.setItems(vertexMappings.keySet().toArray(new String[vertexMappings.size()]));
                        networkDiagramSelectionCombo.setItems(diagrams.keySet().toArray(new String[diagrams.size()]));
                        if (diagrams.size() > 0) {
                            networkDiagramSelectionCombo.select(0);
                        }
                        final Set codes = CRS.getSupportedCodes((String)"EPSG");
                        sourceCRSCombo.setItems(codes.toArray(new String[codes.size()]));
                        sourceCRSCombo.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                String currentText = sourceCRSCombo.getText();
                                if (codes.contains(currentText)) {
                                    String[] items = sourceCRSCombo.getItems();
                                    int i = 0;
                                    while (i < items.length) {
                                        String item = items[i];
                                        if (currentText.equals(item)) break;
                                        ++i;
                                    }
                                    if (i != 0) {
                                        sourceCRSCombo.select(i);
                                    } else {
                                        System.err.println("Should not happen");
                                    }
                                }
                            }
                        });
                    });
                }
            });
        }

        private void createMappingsGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setFont(parent.getFont());
            group.setText("Select Diagram & CRS");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setLayout((Layout)new GridLayout(1, false));
            Composite cmposite = new Composite((Composite)group, 0);
            cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
            cmposite.setLayout((Layout)new GridLayout(2, false));
            Label vertexMappingLabel = new Label(cmposite, 0);
            vertexMappingLabel.setText("Select Vertex Mapping");
            this.vertexMappingCombo = new Combo(cmposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vertexMappingCombo);
            Label selectNetworkDiagramLabel = new Label(cmposite, 0);
            selectNetworkDiagramLabel.setText("Select Network Diagram");
            this.networkDiagramSelectionCombo = new Combo(cmposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.networkDiagramSelectionCombo);
            Label label = new Label(cmposite, 0);
            label.setText("Select Source Coordinate Reference System");
            this.sourceCRSCombo = new Combo(cmposite, 0);
            this.sourceCRSCombo.setToolTipText("Select the coordinate reference system that is used in the source material for possible transformation to target coordinate reference system (EPSG:4326)");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.sourceCRSCombo);
        }

        protected void computeResult() {
            this.mapping = this.vertexMappings.get(this.vertexMappingCombo.getItem(this.vertexMappingCombo.getSelectionIndex()));
            this.diagram = this.diagrams.get(this.networkDiagramSelectionCombo.getItem(this.networkDiagramSelectionCombo.getSelectionIndex()));
            this.sourceCRS = this.sourceCRSCombo.getItem(this.sourceCRSCombo.getSelectionIndex());
        }
    }
}

