/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.table;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Composite;
import org.simantics.district.network.ui.table.DistrictCSVTable;

public class DistrictCSVTableView {
    @Inject
    ESelectionService selectionService;
    private DistrictCSVTable table;

    @Inject
    public void init(MPart part, MApplication app) {
        MToolBar toolBar = MMenuFactory.INSTANCE.createToolBar();
        toolBar.setToBeRendered(true);
        toolBar.getChildren().add(this.createImportCSVDataToolItem(app));
        part.setToolbar(toolBar);
    }

    private MHandledToolItem createImportCSVDataToolItem(MApplication app) {
        MHandledToolItem createHandledToolItem = MMenuFactory.INSTANCE.createHandledToolItem();
        createHandledToolItem.setCommand(app.getCommand("org.simantics.district.network.ui.command.importcsv"));
        createHandledToolItem.setLabel("Import CSV");
        createHandledToolItem.setIconURI("platform:/plugin/com.famfamfam.silk/icons/table_edit.png");
        return createHandledToolItem;
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        this.table = new DistrictCSVTable(parent, 0);
    }

    @PreDestroy
    public void dispose() {
        this.table.dispose();
        this.table = null;
    }

    public String[][] getCurrentData() {
        return this.table.getCurrentData();
    }
}

