/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.styles;

import java.awt.geom.Point2D;
import java.util.Objects;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.exception.MissingVariableValueException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.profile.MidBranchEdgeSetRequest;
import org.simantics.district.network.ui.nodes.DeferredRenderingNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.district.network.ui.nodes.DistrictNetworkStaticInfoNode;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DistrictNetworkStaticInfoStyle
extends StyleBase<StyleResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictNetworkStaticInfoStyle.class);
    private static final String ACTIONS_MODULE = "Actions";
    private static final String PIPELINE_INFO = "pipelineInfo";
    private static final Point2D EDGE = new Point2D.Double();

    public DistrictNetworkStaticInfoStyle(Resource style) {
    }

    public StyleResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource mapElement) throws DatabaseException {
        return DistrictNetworkStaticInfoStyle.calculateStyle(graph, entry, mapElement);
    }

    public static StyleResult calculateStyle(ReadGraph graph, Resource entry, Resource mapElement) throws DatabaseException {
        Object result;
        Resource diagram;
        Set edgesToUse;
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Set types = graph.getTypes(mapElement);
        boolean isEdge = types.contains(DN.Edge);
        boolean isVertex = types.contains(DN.Vertex);
        if (!isEdge && !isVertex) {
            return null;
        }
        if (isEdge && !(edgesToUse = (Set)graph.syncRequest((Read)new MidBranchEdgeSetRequest(diagram = graph.getSingleObject(mapElement, Layer0.getInstance((ReadGraph)graph).PartOf)), (Listener)TransientCacheListener.instance())).contains(mapElement)) {
            return null;
        }
        Resource module = DistrictNetworkUtil.getMappedComponentCached((ReadGraph)graph, (Resource)mapElement);
        if (module == null) {
            return null;
        }
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource moduleType = graph.getPossibleType(module, STR.Component);
        if (moduleType == null) {
            return null;
        }
        Function1<Variable, String> function = DistrictNetworkStaticInfoStyle.getUCPipelineInfoFunctionCached(graph, moduleType);
        if (function == null) {
            return null;
        }
        try {
            Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)module);
            Variable moduleVariable = Variables.possibleActiveVariable((ReadGraph)graph, (Variable)variable);
            if (moduleVariable == null) {
                moduleVariable = variable;
            }
            result = (String)Simantics.applySCLRead((ReadGraph)graph, function, (Object)moduleVariable);
        }
        catch (MissingVariableValueException | PendingVariableException throwable) {
            result = null;
        }
        catch (MissingVariableException e) {
            String message = e.getMessage();
            LOGGER.warn("Missing variable for calculating style with function {} {}", function, (Object)message);
            result = "<" + message + ">";
        }
        if (isVertex) {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            double[] coords = (double[])graph.getRelatedValue(mapElement, DIA.HasLocation);
            Point2D p = DistrictNetworkNodeUtils.calculatePoint2D(new Point2D.Double(coords[0], coords[1]), null);
            return new StyleResult(mapElement, p, (String)result);
        }
        if (isEdge) {
            return new StyleResult(mapElement, EDGE, (String)result);
        }
        return null;
    }

    public void applyStyleForNode(EvaluationContext evaluationContext, INode parent, StyleResult result) {
        DistrictNetworkStaticInfoNode node;
        if (result == null) {
            this.cleanupStyleForNode(evaluationContext, parent);
            return;
        }
        ParentNode root = (ParentNode)NodeUtil.getNearestParentOfType((INode)parent, RTreeNode.class);
        if (root != null) {
            DeferredRenderingNode deferred = (DeferredRenderingNode)ProfileVariables.claimChild((INode)root, (String)"", (String)"staticInfo", DeferredRenderingNode.class, (Observer)evaluationContext);
            deferred.setZIndex(0x7FFFFFFE);
        }
        if ((node = (DistrictNetworkStaticInfoNode)ProfileVariables.claimChild((INode)parent, (String)"*", (String)"DISTRICT_NETWORK_STATIC_INFO", DistrictNetworkStaticInfoNode.class, (Observer)evaluationContext)) == null) {
            return;
        }
        Point2D p1 = result.p1;
        if (p1 != EDGE) {
            node.setLocation(p1, new Point2D.Double(1.0, 0.0));
        } else {
            for (IG2DNode n : ((ConnectionNode)parent).getNodes()) {
                if (!(n instanceof DistrictNetworkEdgeNode)) continue;
                node.setEdgeNode((DistrictNetworkEdgeNode)n);
            }
        }
        node.setInfo(result.info);
    }

    private static Function1<Variable, String> getUCPipelineInfoFunctionCached(ReadGraph graph, Resource componentType) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new UCPipelineInfoRequest(componentType), (Listener)TransientCacheListener.instance());
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        ProfileVariables.denyChild((INode)node, (String)"*", (String)"DISTRICT_NETWORK_STATIC_INFO");
    }

    public static class StyleResult {
        public final Resource r;
        public final Point2D p1;
        public final String info;

        public StyleResult(Resource r, Point2D p1, String info) {
            this.r = r;
            this.p1 = p1;
            this.info = info;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.r.hashCode();
            result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
            result = 31 * result + (this.p1 == null ? 0 : this.p1.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StyleResult other = (StyleResult)obj;
            return this.r.equals(other.r) && Objects.equals(this.info, other.info) && Objects.equals(this.p1, other.p1);
        }
    }

    private static final class UCPipelineInfoRequest
    extends ResourceRead<Function1<Variable, String>> {
        public UCPipelineInfoRequest(Resource resource) {
            super(resource);
        }

        public Function1<Variable, String> perform(ReadGraph graph) throws DatabaseException {
            Resource actionsModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)this.resource, (String)DistrictNetworkStaticInfoStyle.ACTIONS_MODULE);
            if (actionsModule == null || !graph.isInstanceOf(actionsModule, Layer0.getInstance((ReadGraph)graph).SCLModule)) {
                return null;
            }
            String uri = graph.getURI(actionsModule);
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.get((Object)"graph");
            try {
                sclContext.put((Object)"graph", (Object)graph);
                Function1 function1 = (Function1)SCLOsgi.MODULE_REPOSITORY.getValue(uri, DistrictNetworkStaticInfoStyle.PIPELINE_INFO);
                return function1;
            }
            catch (ValueNotFound valueNotFound) {
                return null;
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
        }
    }
}

