/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.styles;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;

public class ConnectionLineStyle {
    public static List<Point2D> doCalculateConnectedComponentPoints(ReadGraph graph, Resource vertex, Resource component) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(vertex, DN.Vertex)) {
            return Collections.emptyList();
        }
        Resource componentType = graph.getPossibleType(component, STR.Component);
        if (componentType == null) {
            return Collections.emptyList();
        }
        Function1<Resource, List<Resource>> fun = ConnectionLineStyle.getConnectedComponentsFunctionCached(graph, componentType);
        if (fun == null) {
            return Collections.emptyList();
        }
        List components = (List)Simantics.applySCLRead((ReadGraph)graph, fun, (Object)component);
        if (components == null || components.isEmpty() || ConnectionLineStyle.onlyNulls(components)) {
            return Collections.emptyList();
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Point2D> result = new ArrayList<Point2D>(components.size() + 1);
        result.add(null);
        int foundPoints = 0;
        for (Resource comp : components) {
            Resource mappingElement;
            Resource e = comp != null ? graph.getPossibleObject(comp, MOD.ComponentToElement) : null;
            Resource resource = mappingElement = e != null ? graph.getPossibleObject(e, DN.MappedFromElement) : null;
            if (mappingElement != null) {
                double[] coords2 = (double[])graph.getRelatedValue(mappingElement, DIA.HasLocation);
                result.add(new Point2D.Double(coords2[0], coords2[1]));
                ++foundPoints;
                continue;
            }
            result.add(null);
        }
        if (foundPoints == 0) {
            return Collections.emptyList();
        }
        double[] coords = (double[])graph.getRelatedValue(vertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation);
        result.set(0, new Point2D.Double(coords[0], coords[1]));
        return result;
    }

    private static <T> boolean onlyNulls(List<T> ts) {
        for (T t : ts) {
            if (t == null) continue;
            return false;
        }
        return true;
    }

    private static Function1<Resource, List<Resource>> getConnectedComponentsFunctionCached(ReadGraph graph, Resource componentType) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new ConnectedComponentsFunctionRequest(componentType), (Listener)TransientCacheListener.instance());
    }

    private static final class ConnectedComponentsFunctionRequest
    extends ResourceRead<Function1<Resource, List<Resource>>> {
        public ConnectedComponentsFunctionRequest(Resource resource) {
            super(resource);
        }

        public Function1<Resource, List<Resource>> perform(ReadGraph graph) throws DatabaseException {
            Resource actionsModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)this.resource, (String)"Actions");
            if (actionsModule == null || !graph.isInstanceOf(actionsModule, Layer0.getInstance((ReadGraph)graph).SCLModule)) {
                return null;
            }
            String uri = graph.getURI(actionsModule);
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.get((Object)"graph");
            try {
                sclContext.put((Object)"graph", (Object)graph);
                Function1 function1 = (Function1)SCLOsgi.MODULE_REPOSITORY.getValue(uri, "getConnectedComponents");
                return function1;
            }
            catch (ValueNotFound valueNotFound) {
                return null;
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
        }
    }
}

