/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.network.DNEdgeBuilder;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.NetworkDrawingParticipant;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.district.network.ui.nodes.DistrictNetworkVertexNode;
import org.simantics.district.network.ui.participants.Modes;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDrawingNode
extends G2DNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkDrawingNode.class);
    private static final long serialVersionUID = -3475301184009620573L;
    private Point2D currentMousePos = null;
    private List<DrawingNode> nodes = new ArrayList<DrawingNode>();
    private DrawingNode currentRouteNode = null;
    private Resource diagramResource;
    private NetworkDrawingParticipant participant;
    private IDiagram diagram;
    private static final Stroke DASHED_STROKE = new BasicStroke(2.0f, 1, 1, 4.0f, new float[]{4.0f}, 0.0f);
    private static final Color BLUE_ALPHA = new Color(0, 0, 255, 100);
    private static final Color RED_ALPHA = new Color(255, 0, 0, 100);
    private boolean scaleStroke = true;
    private AffineTransform lastViewTransform = new AffineTransform();

    public void init() {
        super.init();
        this.addEventHandler((IEventHandler)this);
    }

    public void setNetworkDrawingParticipant(NetworkDrawingParticipant participant) {
        this.participant = participant;
    }

    public void setDiagram(IDiagram diagram) {
        if (diagram != null) {
            this.diagram = diagram;
            this.diagramResource = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        }
    }

    public void render(Graphics2D g2d) {
        this.lastViewTransform = g2d.getTransform();
        if (this.nodes.isEmpty()) {
            return;
        }
        Color old = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        Iterator<DrawingNode> dnodeIterator = this.nodes.iterator();
        while (dnodeIterator.hasNext()) {
            Point2D node;
            DrawingNode dnode = dnodeIterator.next();
            Iterator<Point2D> nodeIter = dnode.routeNodes.iterator();
            if (!nodeIter.hasNext()) continue;
            Path2D.Double path = new Path2D.Double();
            if (nodeIter.hasNext()) {
                node = nodeIter.next();
                ((Path2D)path).moveTo(node.getX(), node.getY());
            }
            while (nodeIter.hasNext()) {
                node = nodeIter.next();
                ((Path2D)path).lineTo(node.getX(), node.getY());
            }
            if (!dnodeIterator.hasNext() && this.currentMousePos != null) {
                ((Path2D)path).lineTo(this.currentMousePos.getX(), this.currentMousePos.getY());
            }
            if (DASHED_STROKE != null) {
                if (this.scaleStroke && DASHED_STROKE instanceof BasicStroke) {
                    BasicStroke bs = GeometryUtils.scaleStroke((Stroke)DASHED_STROKE, (float)((float)(1.0 / GeometryUtils.getScale((AffineTransform)g2d.getTransform()))));
                    g2d.setStroke(bs);
                } else {
                    g2d.setStroke(DASHED_STROKE);
                }
            }
            g2d.setColor(BLUE_ALPHA);
            g2d.draw(path);
            g2d.setColor(RED_ALPHA);
            BasicStroke stroke = GeometryUtils.scaleStroke((Stroke)DASHED_STROKE, (float)((float)(1.0 / GeometryUtils.getScale((AffineTransform)g2d.getTransform()))));
            g2d.setStroke(stroke);
            Point2D currentPoint = path.getCurrentPoint();
            g2d.draw(new Rectangle2D.Double(currentPoint.getX() - 5.0E-5, currentPoint.getY() - 5.0E-5, 1.0E-4, 1.0E-4));
        }
        g2d.setStroke(oldStroke);
        g2d.setColor(old);
    }

    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    public int getEventMask() {
        return EventTypes.AnyMask;
    }

    protected boolean mouseDoubleClicked(MouseEvent.MouseDoubleClickedEvent e) {
        IToolMode mode = this.getToolMode();
        if (mode == Hints.CONNECTTOOL || e.hasAnyModifier(8704)) {
            Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)e.controlPosition, (Point2D)new Point2D.Double());
            Point2D.Double pos = new Point2D.Double(localPos.getX(), localPos.getY());
            if (this.currentRouteNode != null) {
                this.currentRouteNode = new DrawingNode();
                this.nodes.add(this.currentRouteNode);
            } else {
                double scale = this.getTransform().getScaleY();
                double x = ModelledCRS.xToLongitude((double)(pos.getX() / scale));
                double y = ModelledCRS.yToLatitude((double)(-pos.getY() / scale));
                boolean leftButton = e.button == 1;
                ThreadUtils.getNonBlockingWorkExecutor().schedule(() -> {
                    try {
                        Simantics.getSession().syncRequest((Write)new CreateVertexWriteRequest(this.diagramResource, x, y, leftButton));
                    }
                    catch (DatabaseException e1) {
                        e1.printStackTrace();
                    }
                }, 100L, TimeUnit.MILLISECONDS);
            }
            this.repaint();
            return true;
        }
        return super.mouseDoubleClicked(e);
    }

    private void createEdge(DrawingNode node) {
        Point2D start = node.routeNodes.get(0);
        Point2D end = node.routeNodes.get(node.routeNodes.size() - 1);
        double currentPadding = 30.0;
        AffineTransform test = this.getTransform();
        ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)this);
        AffineTransform tr = (AffineTransform)ctx.getHintStack().getHint(Hints.KEY_CANVAS_TRANSFORM);
        AffineTransform testing = new AffineTransform(tr);
        testing.concatenate(test);
        double calculateScaleRecip = DistrictNetworkNodeUtils.calculateScaleRecip(testing);
        final double padding = currentPadding * calculateScaleRecip;
        double scaleY = this.getTransform().getScaleY();
        double scaleX = this.getTransform().getScaleX();
        double startLat = ModelledCRS.yToLatitude((double)(-start.getY() / scaleY));
        double startLon = ModelledCRS.xToLongitude((double)(start.getX() / scaleX));
        double endLat = ModelledCRS.yToLatitude((double)(-end.getY() / scaleY));
        double endLon = ModelledCRS.xToLongitude((double)(end.getX() / scaleX));
        final double[] startCoords = new double[]{startLon, startLat};
        final double[] endCoords = new double[]{endLon, endLat};
        int routeNodeCount = node.routeNodes.size();
        final double[] detailedGeometryCoords = new double[(routeNodeCount - 2) * 2];
        int i = 0;
        int r = 1;
        while (r < routeNodeCount - 1) {
            Point2D p = node.routeNodes.get(r);
            double lat = ModelledCRS.yToLatitude((double)(-p.getY() / scaleY));
            double lon = ModelledCRS.xToLongitude((double)(p.getX() / scaleX));
            detailedGeometryCoords[i++] = lon;
            detailedGeometryCoords[i++] = lat;
            ++r;
        }
        final DNEdgeBuilder builder = new DNEdgeBuilder(this.diagramResource, this.diagram);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                builder.create(graph, startCoords, Double.MAX_VALUE, endCoords, Double.MAX_VALUE, detailedGeometryCoords, padding);
            }
        });
    }

    protected boolean mouseClicked(MouseEvent.MouseClickEvent e) {
        IToolMode mode = this.getToolMode();
        if (mode == Hints.CONNECTTOOL || e.hasAnyModifier(8704)) {
            if (e.button == 2 && !this.nodes.isEmpty()) {
                List<Point2D> detail;
                int ds;
                int ns = this.nodes.size();
                this.nodes.remove(ns - 1);
                DrawingNode drawingNode = this.currentRouteNode = ns > 1 ? this.nodes.get(ns - 2) : null;
                if (this.currentRouteNode != null && (ds = (detail = this.currentRouteNode.routeNodes).size()) > 1) {
                    detail.remove(ds - 1);
                }
            } else if (e.button == 1) {
                Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)e.controlPosition, (Point2D)new Point2D.Double());
                DistrictNetworkVertexNode vertex = this.hoveringOverNode(localPos);
                if (vertex != null) {
                    Point2D vertexPos = DistrictNetworkNodeUtils.calculatePoint2D(vertex.getVertex().getPoint(), null);
                    vertexPos = vertex.localToParent(vertexPos);
                    if (this.currentRouteNode == null) {
                        this.currentRouteNode = new DrawingNode();
                        this.currentRouteNode.routeNodes.add(vertexPos);
                        this.nodes.add(this.currentRouteNode);
                    } else if (this.currentRouteNode != null && vertexPos != null) {
                        this.currentRouteNode.routeNodes.add(vertexPos);
                        Iterator<DrawingNode> nodeIter = this.nodes.iterator();
                        while (nodeIter.hasNext()) {
                            this.createEdge(nodeIter.next());
                        }
                        this.currentRouteNode = null;
                        this.nodes.clear();
                    }
                } else if (this.currentRouteNode != null) {
                    Point2D.Double vertexPos = new Point2D.Double(localPos.getX(), localPos.getY());
                    this.currentRouteNode.routeNodes.add(vertexPos);
                }
            }
            this.repaint();
            return true;
        }
        if (mode == Modes.INSERT_TOOL) {
            Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)e.controlPosition, (Point2D)new Point2D.Double());
            if (this.hoveringOverNode(localPos) != null) {
                LOGGER.info("hovering over another node in insert mode so not creating new one");
            } else {
                Point2D.Double pos = new Point2D.Double(localPos.getX(), localPos.getY());
                double scale = this.getTransform().getScaleY();
                double x = ModelledCRS.xToLongitude((double)(pos.getX() / scale));
                double y = ModelledCRS.yToLatitude((double)(-pos.getY() / scale));
                boolean leftButton = e.button == 1;
                Simantics.getSession().asyncRequest((Write)new CreateVertexWriteRequest(this.diagramResource, x, y, leftButton));
            }
        }
        return super.mouseClicked(e);
    }

    private DistrictNetworkVertexNode hoveringOverNode(Point2D currentPos) {
        return this.participant.hoveringOverNode(currentPos, this.lastViewTransform);
    }

    private IToolMode getToolMode() {
        return (IToolMode)this.participant.getHint(Hints.KEY_TOOL);
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        boolean isConnectionTool;
        IToolMode mode = this.getToolMode();
        boolean repaint = false;
        Point2D p = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)e.controlPosition, (Point2D)new Point2D.Double());
        boolean bl = isConnectionTool = mode == Hints.CONNECTTOOL || e.hasAnyModifier(8704);
        if (e.buttons == 0 && this.participant.pickHoveredElement(p, isConnectionTool, this.lastViewTransform)) {
            repaint = true;
        }
        if (!this.nodes.isEmpty()) {
            this.currentMousePos = p;
            this.repaint();
            return true;
        }
        this.currentMousePos = null;
        if (repaint) {
            this.repaint();
        }
        return super.mouseMoved(e);
    }

    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        if (e.keyCode == 27) {
            this.currentRouteNode = null;
            this.nodes.clear();
            this.repaint();
            return true;
        }
        return super.keyPressed(e);
    }

    private static class CreateVertexWriteRequest
    extends WriteRequest {
        private Resource diagramResource;
        private boolean leftButton;
        private double x;
        private double y;

        public CreateVertexWriteRequest(Resource diagramResource, double x, double y, boolean leftButton) {
            this.diagramResource = diagramResource;
            this.x = x;
            this.y = y;
            this.leftButton = leftButton;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            graph.markUndoPoint();
            Resource mapping = null;
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            mapping = this.leftButton ? graph.getSingleObject(this.diagramResource, DN.LeftClickDefaultMapping) : graph.getSingleObject(this.diagramResource, DN.RightClickDefaultMapping);
            if (mapping == null) {
                mapping = graph.getSingleObject(this.diagramResource, DN.VertexDefaultMapping);
            }
            DistrictNetworkUtil.createVertex((WriteGraph)graph, (Resource)this.diagramResource, (double[])new double[]{this.x, this.y}, (double)Double.MAX_VALUE, (Resource)mapping);
        }
    }

    static class DrawingNode {
        private List<Point2D> routeNodes = new ArrayList<Point2D>();

        DrawingNode() {
        }
    }
}

