/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;

public class ElevationServerNode
extends G2DNode {
    private static final long serialVersionUID = 3832908017166017921L;
    private static final Stroke DASHED_STROKE = new BasicStroke(2.0f, 1, 1, 4.0f, new float[]{4.0f}, 0.0f);
    private static final Color BLUE_ALPHA = new Color(0, 0, 255, 100);
    public static final String ID = "elevationServerNode";
    private Collection<Rectangle2D> rectangles;

    public void render(Graphics2D g2d) {
        Color old = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setColor(BLUE_ALPHA);
        BasicStroke stroke = GeometryUtils.scaleStroke((Stroke)DASHED_STROKE, (float)((float)(1.0 / GeometryUtils.getScale((AffineTransform)g2d.getTransform()))));
        g2d.setStroke(stroke);
        double scale = this.getTransform().getScaleY();
        for (Rectangle2D rect : this.getRectangles()) {
            Point2D.Double point = new Point2D.Double(rect.getY(), rect.getX());
            Point2D result = DistrictNetworkNodeUtils.calculatePoint2D(point, null);
            Point2D.Double point2 = new Point2D.Double(rect.getY() + rect.getHeight(), rect.getX() + rect.getWidth());
            Point2D result2 = DistrictNetworkNodeUtils.calculatePoint2D(point2, null);
            double x = result.getX() * scale;
            double y = result.getY() * scale;
            double width = result2.getX() * scale - result.getX() * scale;
            double height = result2.getY() * scale - result.getY() * scale;
            Rectangle2D.Double translated = new Rectangle2D.Double(x, y - Math.abs(height), width, Math.abs(height));
            g2d.draw(translated);
        }
        g2d.setStroke(oldStroke);
        g2d.setColor(old);
    }

    public Rectangle2D getBoundsInLocal() {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        for (Rectangle2D rect : this.getRectangles()) {
            bounds.add(rect);
        }
        return bounds;
    }

    public void setRectangles(Collection<Rectangle2D> rectangles) {
        this.rectangles = rectangles;
    }

    public Collection<Rectangle2D> getRectangles() {
        if (this.rectangles == null) {
            return Collections.emptyList();
        }
        return this.rectangles;
    }
}

