/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DistrictDiagramEditor;
import org.simantics.district.network.ui.NetworkDrawingParticipant;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeRoutePointToVertexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeRoutePointToVertexHandler.class);

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        return ChangeRoutePointToVertexHandler.canChangeRoutePointToVertex(selection);
    }

    public static boolean canChangeRoutePointToVertex(ISelection selection) {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() != 1) {
            return false;
        }
        try {
            return (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    Iterator iterator = elements.iterator();
                    if (iterator.hasNext()) {
                        Resource selection = (Resource)iterator.next();
                        if (!graph.isInstanceOf(selection, DN.Edge)) {
                            return false;
                        }
                        double[] detailedGeom = (double[])graph.getPossibleRelatedValue(selection, DN.Edge_HasGeometry, (Binding)Bindings.DOUBLE_ARRAY);
                        if (detailedGeom != null && detailedGeom.length > 0) {
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not evaluate if mapping can be changed for selection {}", (Object)elements, (Object)e);
            return false;
        }
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart mActiveEditorPart, @Named(value="org.eclipse.ui.selection") Object selection, ParameterizedCommand command) {
        List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        final Resource edge = (Resource)elements.get(0);
        try {
            final Point2D mouseClicked = ChangeRoutePointToVertexHandler.mouseClickedOnEditor(mActiveEditorPart);
            if (mouseClicked != null) {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        DistrictNetworkUtil.splitPipe((WriteGraph)graph, (Resource)edge, (Point2D)mouseClicked);
                    }
                });
            } else {
                LOGGER.warn("No mouseClicked for editor {}", (Object)mActiveEditorPart);
            }
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Could not change route point to vertex", (Throwable)e);
        }
    }

    private static Point2D mouseClickedOnEditor(MPart mActiveEditorPart) throws InvocationTargetException {
        IEditorPart activeEditorPart = E4WorkbenchUtils.getActiveIEditorPart((MPart)mActiveEditorPart);
        if (activeEditorPart == null) {
            return null;
        }
        if (!(activeEditorPart instanceof DistrictDiagramEditor)) {
            return null;
        }
        DistrictDiagramEditor editor = (DistrictDiagramEditor)activeEditorPart;
        ICanvasContext ctx = (ICanvasContext)editor.getAdapter(ICanvasContext.class);
        NetworkDrawingParticipant drawingParticipant = (NetworkDrawingParticipant)((Object)ctx.getAtMostOneItemOfClass(NetworkDrawingParticipant.class));
        AffineTransform drawingTransform = drawingParticipant.getTransform();
        MouseUtil util = (MouseUtil)ctx.getAtMostOneItemOfClass(MouseUtil.class);
        MouseUtil.MouseInfo mouseInfo = util.getMousePressedInfo(0);
        if (mouseInfo == null) {
            return null;
        }
        Point2D canvasPosition = mouseInfo.canvasPosition;
        Point2D transformed = null;
        try {
            transformed = drawingTransform.inverseTransform(canvasPosition, new Point2D.Double());
        }
        catch (NoninvertibleTransformException e) {
            LOGGER.error("Could not create inverse transform of {}", (Object)drawingTransform, (Object)e);
            throw new InvocationTargetException(e);
        }
        double x = ModelledCRS.xToLongitude((double)transformed.getX());
        double y = ModelledCRS.yToLatitude((double)(-transformed.getY()));
        return new Point2D.Double(x, y);
    }
}

