/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.adapters;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DistrictNetworkEdge;
import org.simantics.district.network.ui.adapters.DistrictNetworkAdditionalColor;
import org.simantics.district.network.ui.adapters.DistrictNetworkEdgeElement;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.maps.MapScalingTransform;

public class DistrictNetworkEdgeElementFactory
extends SyncElementFactory {
    public static final ElementClass CLASS = DistrictNetworkEdgeElement.CLASS;
    public static final double[] EMPTY = new double[0];
    private DistrictNetworkResource DN;
    private DiagramResource DIA;

    public DistrictNetworkEdgeElementFactory(ReadGraph graph) {
        this.DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
    }

    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)CLASS.newClassWith(false, new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}));
    }

    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return this.DN.Edge;
    }

    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource edgeResource, IElement element) throws DatabaseException {
        if (!graph.hasStatement(edgeResource)) {
            return;
        }
        if (!graph.hasStatement(edgeResource, this.DN.HasStartVertex)) {
            return;
        }
        Resource startVertex = graph.getSingleObject(edgeResource, this.DN.HasStartVertex);
        if (!graph.hasStatement(edgeResource, this.DN.HasEndVertex)) {
            return;
        }
        Resource endVertex = graph.getSingleObject(edgeResource, this.DN.HasEndVertex);
        double[] startCoords = (double[])graph.getRelatedValue2(startVertex, this.DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        double[] endCoords = (double[])graph.getRelatedValue2(endVertex, this.DIA.HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
        double[] geometry = EMPTY;
        try {
            geometry = (double[])graph.getPossibleRelatedValue2(edgeResource, this.DN.Edge_HasGeometry, (Binding)Bindings.DOUBLE_ARRAY);
        }
        catch (Exception exception) {}
        DistrictNetworkEdge edge = new DistrictNetworkEdge(new Point2D.Double(startCoords[0], startCoords[1]), new Point2D.Double(endCoords[0], endCoords[1]), geometry);
        Resource mapping = graph.getSingleObject(edgeResource, DistrictNetworkResource.getInstance((ReadGraph)graph).HasMapping);
        element.setHint(DistrictNetworkAdditionalColor.KEY_DN_MAPPING_RESOURCE, (Object)mapping);
        element.setHint(DistrictNetworkEdgeElement.KEY_DN_EDGE, (Object)edge);
        ElementUtils.setTransform((IElement)element, (AffineTransform)MapScalingTransform.INSTANCE);
        IModifiableSynchronizationContext context = (IModifiableSynchronizationContext)diagram.getHint(SynchronizationHints.CONTEXT);
        GraphLayerManager layerManager = (GraphLayerManager)context.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
        ILayersEditor layersEditor = (ILayersEditor)diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        layerManager.loadLayersForElement(graph, layersEditor, element, edgeResource);
    }
}

