/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.db.Resource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.network.ui.adapters.DistrictNetworkEdgeElement;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.district.network.ui.nodes.DistrictNetworkVertexNode;
import org.simantics.district.network.ui.nodes.NetworkDrawingNode;
import org.simantics.district.network.ui.participants.DNPickSorter;
import org.simantics.district.network.ui.participants.DynamicVisualisationContributionsParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.maps.MapScalingTransform;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.utils.GeometryUtils;

public class NetworkDrawingParticipant
extends AbstractDiagramParticipant {
    public static final String NETWORK_DRAWING_NODE = "networkDrawingNode";
    @DependencyReflection.Dependency
    PickContext pick;
    private NetworkDrawingNode node;
    private DynamicVisualisationContributionsParticipant dynamicVisualisationContributionsParticipant;
    private AffineTransform transform;
    private IElement currentHoverElement;

    public NetworkDrawingParticipant(DynamicVisualisationContributionsParticipant dynamicVisualisationContributionsParticipant, AffineTransform transform) {
        this.dynamicVisualisationContributionsParticipant = dynamicVisualisationContributionsParticipant;
        this.transform = transform;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (NetworkDrawingNode)((Object)parent.addNode(NETWORK_DRAWING_NODE, NetworkDrawingNode.class));
        this.node.setTransform(this.transform);
        this.node.setNetworkDrawingParticipant(this);
    }

    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        this.node.setDiagram(newDiagram);
    }

    public List<IElement> pickables(Point2D canvasPos, AffineTransform viewTransform) {
        PickRequest req = new PickRequest((Shape)this.getPickRect(canvasPos, viewTransform)).context(this.getContext());
        ArrayList<IElement> pickables = new ArrayList<IElement>();
        this.pick.pick(this.diagram, req, pickables);
        return pickables;
    }

    public boolean pickHoveredElement(Point2D canvasPos, boolean isConnectionTool, AffineTransform viewTransform) {
        List<IElement> pickables = this.pickables(canvasPos, viewTransform);
        Collections.sort(pickables, DNPickSorter.nearestVerticesFirst(false, DNPickSorter.centerDistSq(canvasPos.getX(), canvasPos.getY())));
        this.updateHoveredElement(pickables, true, isConnectionTool, viewTransform);
        return false;
    }

    private boolean updateHoveredElement(List<IElement> elements, boolean hover, boolean isConnectionTool, AffineTransform viewTransform) {
        if (elements == null || elements.isEmpty()) {
            this.currentHoverElement = null;
            return this.dynamicVisualisationContributionsParticipant.doHover(false, isConnectionTool);
        }
        this.dynamicVisualisationContributionsParticipant.doHover(true, isConnectionTool);
        IElement elem = elements.get(0);
        if (elem.equals(this.currentHoverElement)) {
            return false;
        }
        INode node = (INode)elem.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
        if (node == null) {
            node = (INode)elem.getHint(DistrictNetworkEdgeElement.KEY_DN_EDGE_NODE);
        }
        if (node == null) {
            return false;
        }
        Resource mapElement = (Resource)elem.getHint(ElementHints.KEY_OBJECT);
        Resource runtimeDiagram = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
        this.currentHoverElement = elem;
        this.dynamicVisualisationContributionsParticipant.hoverNode(runtimeDiagram, mapElement, node, MapScalingTransform.zoomLevel((AffineTransform)viewTransform));
        return true;
    }

    public DistrictNetworkVertexNode hoveringOverNode(Point2D canvasPos, AffineTransform viewTransform) {
        PickRequest req = new PickRequest((Shape)this.getPickRect(canvasPos, viewTransform)).context(this.getContext());
        ArrayList pickables = new ArrayList();
        this.pick.pick(this.diagram, req, pickables);
        for (IElement elem : pickables) {
            Node node = (Node)elem.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
            if (!(node instanceof DistrictNetworkVertexNode)) continue;
            return (DistrictNetworkVertexNode)node;
        }
        return null;
    }

    private Rectangle2D getPickRect(Point2D canvasPos, AffineTransform viewTransform) {
        double pixelScale = 1.0 / GeometryUtils.getScale((AffineTransform)viewTransform);
        if (Double.isInfinite(pixelScale)) {
            pixelScale = 1.0E-8;
        }
        Rectangle2D pickRect = GeometryUtils.expandRectangle((Rectangle2D)new Rectangle2D.Double(canvasPos.getX(), canvasPos.getY(), 0.0, 0.0), (double)(pixelScale * 4.0));
        return pickRect;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }
}

