/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.simantics.district.network.ui.DistrictTransformUtil;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.maps.MapScalingTransform;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.utils.GeometryUtils;

public class DistrictPanZoomRotateHandler
extends PanZoomRotateHandler {
    public static final int DISTRICT_TRANSLATE_AMOUNT = 2;
    public static final int DISTRICT_MAX_ZOOM_LEVEL = 20;
    public static final int DISTRICT_MIN_ZOOM_LEVEL = 0;
    @DependencyReflection.Dependency
    DistrictTransformUtil util;
    @DependencyReflection.Reference
    Selection selection;

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.setHint(KEY_TRANSLATE_AMOUNT, 2);
    }

    protected Class<? extends NavigationNode> getNavigationNodeClass() {
        return DistrictNavigationNode.class;
    }

    public double getTranslateAmount() {
        return 15.0 * super.getTranslateAmount();
    }

    public double limitScaleFactor(double scaleFactor) {
        return scaleFactor;
    }

    @EventHandlerReflection.EventHandler(priority=1)
    public boolean handleEvent(CommandEvent e) {
        AffineTransform transform;
        int zoomLevel;
        boolean zoomDisabled;
        super.update();
        Command c = e.command;
        boolean bl = zoomDisabled = Boolean.TRUE.equals(this.getHint(KEY_DISABLE_ZOOM));
        if (Commands.ZOOM_TO_FIT.equals((Object)c) && !zoomDisabled) {
            boolean result = this.zoomToFit();
            if (!result) {
                result = this.zoomToPage();
            }
            return result;
        }
        if (Commands.ZOOM_TO_PAGE.equals((Object)c) && !zoomDisabled) {
            return this.zoomToPage();
        }
        if (Commands.ZOOM_TO_SELECTION.equals((Object)c) && !zoomDisabled) {
            return this.zoomToSelection();
        }
        if (Commands.ZOOM_IN.equals((Object)c) && !zoomDisabled && (zoomLevel = MapScalingTransform.zoomLevel((AffineTransform)(transform = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM)))) >= 20) {
            return true;
        }
        if (Commands.ZOOM_OUT.equals((Object)c) && !zoomDisabled && (zoomLevel = MapScalingTransform.zoomLevel((AffineTransform)(transform = (AffineTransform)this.getHint(Hints.KEY_CANVAS_TRANSFORM)))) <= 0) {
            return true;
        }
        return super.handleEvent(e);
    }

    private boolean zoomToFit() {
        CanvasBoundsParticipant boundsParticipant = (CanvasBoundsParticipant)this.getContext().getAtMostOneItemOfClass(CanvasBoundsParticipant.class);
        if (boundsParticipant == null) {
            return false;
        }
        Rectangle2D controlBounds = boundsParticipant.getControlBounds().getFrame();
        if (controlBounds == null || controlBounds.isEmpty()) {
            return false;
        }
        IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null) {
            return false;
        }
        Rectangle2D diagramRect = ElementUtils.getSurroundingElementBoundsOnDiagram(DistrictPanZoomRotateHandler.getMapElements(d.getElements()));
        if (diagramRect == null) {
            return false;
        }
        if (diagramRect.isEmpty()) {
            return false;
        }
        GeometryUtils.expandRectangle((Rectangle2D)diagramRect, (double)1.0);
        this.util.fitArea(controlBounds, diagramRect, null);
        return true;
    }

    protected static List<IElement> getMapElements(Collection<IElement> elements) {
        List<IElement> justMapElements = elements.stream().filter(e -> "DistrictNetworkEdgeElement".equals(e.getElementClass().getId()) || "DistrictNetworkVertexElement".equals(e.getElementClass().getId())).collect(Collectors.toList());
        return justMapElements;
    }

    private boolean zoomToPage() {
        this.util.setTransform(new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 270.0f, 270.0f));
        return true;
    }

    private boolean zoomToSelection() {
        CanvasBoundsParticipant boundsParticipant = (CanvasBoundsParticipant)this.getContext().getAtMostOneItemOfClass(CanvasBoundsParticipant.class);
        if (boundsParticipant == null) {
            return false;
        }
        Rectangle2D controlBounds = boundsParticipant.getControlBounds().getFrame();
        if (controlBounds == null || controlBounds.isEmpty()) {
            return false;
        }
        Set selections = this.selection.getAllSelections();
        if (selections == null || selections.isEmpty()) {
            return this.zoomToPage();
        }
        Rectangle2D diagramRect = ElementUtils.getSurroundingElementBoundsOnDiagram(DistrictPanZoomRotateHandler.getMapElements(selections));
        GeometryUtils.expandRectangle((Rectangle2D)diagramRect, (double)1.0);
        this.util.fitArea(controlBounds, diagramRect, null);
        return true;
    }

    public static class DistrictNavigationNode
    extends NavigationNode {
        private static final long serialVersionUID = 5452897272925816875L;

        public DistrictNavigationNode() {
            this.setAdaptViewportToResizedControl(false);
        }

        public Double getZoomInLimit() {
            return super.getZoomInLimit();
        }

        public Double getZoomOutLimit() {
            return super.getZoomOutLimit();
        }

        public void setAdaptViewportToResizedControl(Boolean adapt) {
            super.setAdaptViewportToResizedControl(Boolean.valueOf(false));
        }

        public boolean getAdaptViewportToResizedControl() {
            return false;
        }

        public boolean mouseWheelMoved(MouseEvent.MouseWheelMovedEvent me) {
            AffineTransform transform;
            int zoomLevel;
            if (this.navigationEnabled.booleanValue() && this.zoomEnabled.booleanValue() && ((zoomLevel = MapScalingTransform.zoomLevel((AffineTransform)(transform = this.getTransform()))) > 0 && zoomLevel < 20 || zoomLevel == 0 && me.wheelRotation > 0 || zoomLevel == 20 && me.wheelRotation < 0)) {
                double z = me.wheelRotation > 0 ? 2.0 : 0.5;
                double dx = (me.controlPosition.getX() - transform.getTranslateX()) / transform.getScaleX();
                double dy = (me.controlPosition.getY() - transform.getTranslateY()) / transform.getScaleY();
                this.translate(dx *= 1.0 - z, dy *= 1.0 - z);
                this.scale(z, z);
                this.transformChanged();
                this.dropQuality();
                this.repaint();
            }
            return false;
        }
    }
}

