/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.DistrictDiagramViewerListener;
import org.simantics.district.network.ui.DistrictPanZoomRotateHandler;
import org.simantics.district.network.ui.DistrictTransformUtil;
import org.simantics.district.network.ui.NetworkDrawingParticipant;
import org.simantics.district.network.ui.internal.Activator;
import org.simantics.district.network.ui.nodes.DistrictRenderingPreparationNode;
import org.simantics.district.network.ui.nodes.DistrictSelectionNode;
import org.simantics.district.network.ui.participants.DNPointerInteractor;
import org.simantics.district.network.ui.participants.DistrictFinderVisualisationParticipant;
import org.simantics.district.network.ui.participants.DynamicVisualisationContributionsParticipant;
import org.simantics.district.network.ui.participants.MapRulerPainter;
import org.simantics.district.network.visualisations.DynamicVisualisations;
import org.simantics.district.network.visualisations.VisualizationDatabaseModelInvalidator;
import org.simantics.district.network.visualisations.model.ColorBarOptions;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.SizeBarOptions;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.DelayedBatchElementPainter;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.ElementPainterConfiguration;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.participant.ZoomToAreaHandler;
import org.simantics.maps.MapScalingTransform;
import org.simantics.maps.eclipse.MapPainter;
import org.simantics.maps.sg.commands.MapCommands;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictDiagramViewer
extends DiagramViewer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictDiagramViewer.class);
    public static final IHintContext.Key KEY_MAP_COLOR_BAR_OPTIONS = new IHintContext.KeyOf(ColorBarOptions.class, "colorBarOptions");
    public static final Command MAP_COLOR_BAR_OPTIONS_CHANGE = new Command("colorBarOptionsChange");
    public static final IHintContext.Key KEY_MAP_SIZE_BAR_OPTIONS = new IHintContext.KeyOf(SizeBarOptions.class, "sizeBarOptions");
    public static final Command MAP_SIZE_BAR_OPTIONS_CHANGE = new Command("sizeBarOptionsChange");
    public static final IHintContext.Key KEY_MAP_COLORING_OBJECTS = new IHintContext.KeyOf(Map.class, "coloringObjects");
    public static final Command MAP_COLORING_OBJECTS_CHANGE = new Command("coloringObjectsChange");
    public static final IHintContext.Key KEY_MAP_SIZING_OBJECTS = new IHintContext.KeyOf(Map.class, "sizingObjects");
    public static final Command MAP_SIZING_OBJECTS_CHANGE = new Command("sizingObjectsChange");
    public static final IHintContext.Key KEY_SHOW_ELEVATION_SERVER = new IHintContext.KeyOf(Boolean.class, "showElevationServer");
    public static final Command SHOW_ELEVATION_SERVER_CHANGE = new Command("showElevationServerChange");

    protected void addDiagramParticipants(ICanvasContext ctx) {
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)new Selection());
        ctx.add((Object)new ElementPainter(new ElementPainterConfiguration().selectionNodeClass(DistrictSelectionNode.class)));
        ctx.add((Object)new DNPointerInteractor());
        AffineTransform tr = new AffineTransform(MapScalingTransform.INSTANCE);
        ctx.add((Object)new MapPainter(tr));
        DynamicVisualisationContributionsParticipant dynamicVisualisationContributionsParticipant = new DynamicVisualisationContributionsParticipant(tr);
        ctx.add((Object)new NetworkDrawingParticipant(dynamicVisualisationContributionsParticipant, tr));
        ctx.add((Object)dynamicVisualisationContributionsParticipant);
        G2DParentNode spatialRoot = (G2DParentNode)ctx.getSceneGraph().lookupNode("spatialRoot");
        DistrictRenderingPreparationNode prepNode = new DistrictRenderingPreparationNode();
        prepNode.setZIndex(-1073741824);
        spatialRoot.addNode("districtRenderingPrepareNode", (INode)prepNode);
        IEclipseContext workbenchContext = DistrictDiagramViewer.getWorkbenchContext();
        IEventBroker eventBroker = (IEventBroker)workbenchContext.get(IEventBroker.class);
        DistrictFinderVisualisationParticipant districtFinderVisualisationParticipant = new DistrictFinderVisualisationParticipant(eventBroker);
        ctx.add((Object)districtFinderVisualisationParticipant);
    }

    public static IEclipseContext getWorkbenchContext() {
        return (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
    }

    protected String getPopupId() {
        return "#DistrictDiagramPopup";
    }

    protected void fillInitialDiagramHints(Resource diagram, IHintContext initialHints) throws DatabaseException {
        super.fillInitialDiagramHints(diagram, initialHints);
    }

    public void initializeCanvasContext(CanvasContext ctx) {
        super.initializeCanvasContext(ctx);
        IHintContext h = ctx.getDefaultHintContext();
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_IN_LIMIT, (Object)10000.0);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_OUT_LIMIT, (Object)0.01);
        h.setHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE, (Object)this.diagramResource);
        h.removeHint(DiagramHints.SNAP_ADVISOR);
        h.setHint(TimeParticipant.KEY_TIMER_ENABLED, (Object)true);
    }

    protected void addPainterParticipants(ICanvasContext ctx) {
        ctx.add((Object)new RenderingQualityInteractor());
        ctx.add((Object)new DelayedBatchElementPainter(PickRequest.PickFilter.FILTER_MONITORS, 500L, TimeUnit.MILLISECONDS));
    }

    protected void addGridRulerBackgroundParticipants(CanvasContext ctx) {
        ctx.add((Object)new GridPainter());
        ctx.add((Object)new MapRulerPainter());
        ctx.add((Object)new BackgroundPainter());
    }

    protected void addViewManipulationParticipants(CanvasContext ctx) {
        TransformUtil util = (TransformUtil)ctx.getAtMostOneItemOfClass(TransformUtil.class);
        if (util != null) {
            ctx.remove((Object)util);
        }
        ctx.add((Object)new DistrictTransformUtil());
        ctx.add((Object)new DistrictPanZoomRotateHandler());
        ctx.add((Object)new ZoomToAreaHandler());
    }

    protected void loadPageSettings(ICanvasContext ctx) {
        super.loadPageSettings(ctx);
        this.setupDrawMapEnabled();
        this.setupBackgroundColor();
        this.setupColoringObjects();
        this.setupColorBarOptions();
        this.setupSizingObjects();
        this.setupSizeBarOptions();
        this.setupShowElevationServerBoundingBox();
    }

    protected void onCreated() {
        super.onCreated();
        DistrictDiagramViewerListener[] listeners = Activator.getInstance().getDistrictDiagramViewerListeners();
        if (listeners != null) {
            Resource diagram = this.diagramResource;
            DistrictDiagramViewerListener[] districtDiagramViewerListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                DistrictDiagramViewerListener listener = districtDiagramViewerListenerArray[n2];
                listener.diagramLoaded(diagram, (ICanvasContext)this.canvasContext);
                ++n2;
            }
        }
    }

    public void dispose() {
        VisualizationDatabaseModelInvalidator invalidator;
        DistrictDiagramViewerListener[] listeners = Activator.getInstance().getDistrictDiagramViewerListeners();
        if (listeners != null) {
            Resource diagram = this.diagramResource;
            CanvasContext ctx = this.canvasContext;
            DistrictDiagramViewerListener[] districtDiagramViewerListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                DistrictDiagramViewerListener listener = districtDiagramViewerListenerArray[n2];
                listener.diagramDisposed(diagram, (ICanvasContext)ctx);
                ++n2;
            }
        }
        if ((invalidator = (VisualizationDatabaseModelInvalidator)Simantics.getSession().peekService(VisualizationDatabaseModelInvalidator.class)) != null) {
            invalidator.accept((Object)this.diagramResource, null);
        }
        super.dispose();
    }

    private void setupDrawMapEnabled() {
        this.sessionContext.getSession().asyncRequest((Read)new DrawMapEnabledRequest(this.getInputResource()), (Listener)new DrawMapEnabledListener(result -> this.canvasContext.getEventQueue().queueEvent((Event)new CommandEvent((Object)this.canvasContext, System.currentTimeMillis(), result != false ? Commands.MAP_ENABLE : Commands.MAP_DISABLE)), () -> this.isDisposed()));
    }

    private void setupBackgroundColor() {
        this.sessionContext.getSession().asyncRequest((Read)new MapBackgroundColorRequest(this.getInputResource()), (Listener)new MapBackgroundColorListener(result -> this.queueBackgroundColorChangeEvent((RGB.Integer)result), () -> this.isDisposed()));
    }

    private void queueBackgroundColorChangeEvent(RGB.Integer result) {
        if (result != null) {
            Color backgroundColor = new Color(result.red, result.green, result.blue);
            this.canvasContext.getDefaultHintContext().setHint(MapCommands.KEY_MAP_BACKGROUND_COLOR, (Object)backgroundColor);
            this.canvasContext.getEventQueue().queueEvent((Event)new CommandEvent((Object)this.canvasContext, System.currentTimeMillis(), MapCommands.MAP_BACKGROUND_COLOR_CHANGE));
        }
    }

    private void setupColoringObjects() {
        this.sessionContext.getSession().asyncRequest((Read)new ColoringObjectsRequest(this.getInputResource()), (Listener)new ColoringObjectsListener(result -> this.queueColoringObjectsChangeEvent((Map<String, DynamicColorContribution>)result), () -> this.isDisposed()));
    }

    private void setupColorBarOptions() {
        this.sessionContext.getSession().asyncRequest((Read)new ColorBarOptionsRequest(this.getInputResource()), (Listener)new ColorBarOptionsListener(result -> this.queueColorBarOptionsChangeEvent((ColorBarOptions)result), () -> this.isDisposed()));
    }

    private void setupSizingObjects() {
        this.sessionContext.getSession().asyncRequest((Read)new SizingObjectsRequest(this.getInputResource()), (Listener)new SizingObjectsListener(result -> this.queueSizingObjectsChangeEvent((Map<String, DynamicSizeContribution>)result), () -> this.isDisposed()));
    }

    private void setupSizeBarOptions() {
        this.sessionContext.getSession().asyncRequest((Read)new SizeBarOptionsRequest(this.getInputResource()), (Listener)new SizeBarOptionsListener(result -> this.queueSizeBarOptionsChangeEvent((SizeBarOptions)result), () -> this.isDisposed()));
    }

    private void setupShowElevationServerBoundingBox() {
        this.sessionContext.getSession().asyncRequest((Read)new ShowElevationServerRequest(this.getInputResource()), (Listener)new ShowElevationServerListener(result -> this.queueShowElevationServerChangeEvent((Boolean)result), () -> this.isDisposed()));
    }

    private void queueColoringObjectsChangeEvent(Map<String, DynamicColorContribution> result) {
        this.queueEventInternal(KEY_MAP_COLORING_OBJECTS, MAP_COLORING_OBJECTS_CHANGE, result);
    }

    private void queueColorBarOptionsChangeEvent(ColorBarOptions result) {
        this.queueEventInternal(KEY_MAP_COLOR_BAR_OPTIONS, MAP_COLOR_BAR_OPTIONS_CHANGE, result);
    }

    private void queueSizingObjectsChangeEvent(Map<String, DynamicSizeContribution> result) {
        this.queueEventInternal(KEY_MAP_SIZING_OBJECTS, MAP_SIZING_OBJECTS_CHANGE, result);
    }

    private void queueSizeBarOptionsChangeEvent(SizeBarOptions result) {
        this.queueEventInternal(KEY_MAP_SIZE_BAR_OPTIONS, MAP_SIZE_BAR_OPTIONS_CHANGE, result);
    }

    private void queueShowElevationServerChangeEvent(Boolean result) {
        this.queueEventInternal(KEY_SHOW_ELEVATION_SERVER, SHOW_ELEVATION_SERVER_CHANGE, result);
    }

    private void queueEventInternal(IHintContext.Key key, Command command, Object result) {
        if (result != null && !this.canvasContext.isDisposed()) {
            this.canvasContext.getThreadAccess().asyncExec(() -> {
                this.canvasContext.getDefaultHintContext().setHint(key, result);
                this.canvasContext.getEventQueue().queueEvent((Event)new CommandEvent((Object)this.canvasContext, System.currentTimeMillis(), command));
            });
        } else {
            LOGGER.info("Result is either null or canvasContext is disposed", (Object)String.valueOf(result));
        }
    }

    private static class ColorBarOptionsListener
    implements Listener<ColorBarOptions> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ColorBarOptionsListener.class);
        private Consumer<ColorBarOptions> callback;
        private Supplier<Boolean> isDisposed;

        public ColorBarOptionsListener(Consumer<ColorBarOptions> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(ColorBarOptions result) {
            this.callback.accept(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen ColorBarOptions", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class ColorBarOptionsRequest
    extends UnaryRead<Resource, ColorBarOptions> {
        public ColorBarOptionsRequest(Resource diagram) {
            super((Object)diagram);
        }

        public ColorBarOptions perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.parameter));
            if (model != null) {
                Resource vf = DynamicVisualisations.getVisualisationFolder((ReadGraph)graph, (Resource)model);
                if (vf != null) {
                    Resource activeVisualisation = graph.getPossibleObject(vf, DN.Diagram_hasActiveVisualisation);
                    if (activeVisualisation != null) {
                        return DynamicVisualisations.colorBarOptions((ReadGraph)graph, (Resource)activeVisualisation);
                    }
                } else {
                    LOGGER.debug("No visualisation folder available for model {}", (Object)model);
                }
            }
            return ColorBarOptions.useDefault();
        }
    }

    private static class ColoringObjectsListener
    implements Listener<Map<String, DynamicColorContribution>> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ColoringObjectsListener.class);
        private Consumer<Map<String, DynamicColorContribution>> callback;
        private Supplier<Boolean> isDisposed;

        public ColoringObjectsListener(Consumer<Map<String, DynamicColorContribution>> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(Map<String, DynamicColorContribution> result) {
            this.callback.accept(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen ColoringObjects", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class ColoringObjectsRequest
    extends UnaryRead<Resource, Map<String, DynamicColorContribution>> {
        public ColoringObjectsRequest(Resource diagram) {
            super((Object)diagram);
        }

        public Map<String, DynamicColorContribution> perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.parameter));
            if (model != null) {
                Resource vf = DynamicVisualisations.getVisualisationFolder((ReadGraph)graph, (Resource)model);
                if (vf != null) {
                    Resource activeVisualisation = graph.getPossibleObject(vf, DN.Diagram_hasActiveVisualisation);
                    if (activeVisualisation != null) {
                        return DynamicVisualisations.colorContributions((ReadGraph)graph, (Resource)activeVisualisation);
                    }
                } else {
                    LOGGER.debug("No visualisation folder available for model {}", (Object)model);
                }
            }
            return Collections.emptyMap();
        }
    }

    private static class DrawMapEnabledListener
    implements Listener<Boolean> {
        private static final Logger LOGGER = LoggerFactory.getLogger(DrawMapEnabledListener.class);
        private Consumer<Boolean> callback;
        private Supplier<Boolean> isDisposed;
        private Boolean lastResult;

        public DrawMapEnabledListener(Consumer<Boolean> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(Boolean result) {
            if (!Objects.equals(this.lastResult, result)) {
                this.lastResult = result;
                this.callback.accept(result);
            }
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen if draw map is enabled", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class DrawMapEnabledRequest
    extends UnaryRead<Resource, Boolean> {
        public DrawMapEnabledRequest(Resource diagram) {
            super((Object)diagram);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            return DistrictNetworkUtil.drawMapEnabled((ReadGraph)graph, (Resource)((Resource)this.parameter));
        }
    }

    private static class MapBackgroundColorListener
    implements Listener<RGB.Integer> {
        private static final Logger LOGGER = LoggerFactory.getLogger(MapBackgroundColorListener.class);
        private Consumer<RGB.Integer> callback;
        private Supplier<Boolean> isDisposed;
        private RGB.Integer lastResult;

        public MapBackgroundColorListener(Consumer<RGB.Integer> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(RGB.Integer result) {
            if (!Objects.equals(this.lastResult, result)) {
                this.lastResult = result;
                this.callback.accept(result);
            }
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen map background color", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class MapBackgroundColorRequest
    extends UnaryRead<Resource, RGB.Integer> {
        public MapBackgroundColorRequest(Resource diagram) {
            super((Object)diagram);
        }

        public RGB.Integer perform(ReadGraph graph) throws DatabaseException {
            return DistrictNetworkUtil.backgroundColor((ReadGraph)graph, (Resource)((Resource)this.parameter));
        }
    }

    private static class ShowElevationServerListener
    implements Listener<Boolean> {
        private static final Logger LOGGER = LoggerFactory.getLogger(ShowElevationServerListener.class);
        private Consumer<Boolean> callback;
        private Supplier<Boolean> isDisposed;

        public ShowElevationServerListener(Consumer<Boolean> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(Boolean result) {
            this.callback.accept(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen Show Elevation Server", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class ShowElevationServerRequest
    extends UnaryRead<Resource, Boolean> {
        public ShowElevationServerRequest(Resource diagram) {
            super((Object)diagram);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.parameter));
            if (model != null) {
                Resource vf = DynamicVisualisations.getVisualisationFolder((ReadGraph)graph, (Resource)model);
                if (vf != null) {
                    Resource activeVisualisation = graph.getPossibleObject(vf, DN.Diagram_hasActiveVisualisation);
                    if (activeVisualisation != null) {
                        return DynamicVisualisations.showElevationServerBoundingBox((ReadGraph)graph, (Resource)activeVisualisation);
                    }
                } else {
                    LOGGER.debug("No visualisation folder available for model {}", (Object)model);
                }
            }
            return false;
        }
    }

    private static class SizeBarOptionsListener
    implements Listener<SizeBarOptions> {
        private static final Logger LOGGER = LoggerFactory.getLogger(SizeBarOptionsListener.class);
        private Consumer<SizeBarOptions> callback;
        private Supplier<Boolean> isDisposed;

        public SizeBarOptionsListener(Consumer<SizeBarOptions> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(SizeBarOptions result) {
            this.callback.accept(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen SizeBarOptions", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class SizeBarOptionsRequest
    extends UnaryRead<Resource, SizeBarOptions> {
        public SizeBarOptionsRequest(Resource diagram) {
            super((Object)diagram);
        }

        public SizeBarOptions perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.parameter));
            if (model != null) {
                Resource vf = DynamicVisualisations.getVisualisationFolder((ReadGraph)graph, (Resource)model);
                if (vf != null) {
                    Resource activeVisualisation = graph.getPossibleObject(vf, DN.Diagram_hasActiveVisualisation);
                    if (activeVisualisation != null) {
                        return DynamicVisualisations.sizeBarOptions((ReadGraph)graph, (Resource)activeVisualisation);
                    }
                } else {
                    LOGGER.debug("No visualisation folder available for model {}", (Object)model);
                }
            }
            return SizeBarOptions.useDefault();
        }
    }

    private static class SizingObjectsListener
    implements Listener<Map<String, DynamicSizeContribution>> {
        private static final Logger LOGGER = LoggerFactory.getLogger(SizingObjectsListener.class);
        private Consumer<Map<String, DynamicSizeContribution>> callback;
        private Supplier<Boolean> isDisposed;

        public SizingObjectsListener(Consumer<Map<String, DynamicSizeContribution>> callback, Supplier<Boolean> isDisposed) {
            this.callback = callback;
            this.isDisposed = isDisposed;
        }

        public void execute(Map<String, DynamicSizeContribution> result) {
            this.callback.accept(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen SizingObjectsOptions", t);
        }

        public boolean isDisposed() {
            return this.isDisposed.get();
        }
    }

    private static class SizingObjectsRequest
    extends UnaryRead<Resource, Map<String, DynamicSizeContribution>> {
        public SizingObjectsRequest(Resource diagram) {
            super((Object)diagram);
        }

        public Map<String, DynamicSizeContribution> perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot((Resource)this.parameter));
            if (model != null) {
                Resource vf = DynamicVisualisations.getVisualisationFolder((ReadGraph)graph, (Resource)model);
                if (vf != null) {
                    Resource activeVisualisation = graph.getPossibleObject(vf, DN.Diagram_hasActiveVisualisation);
                    if (activeVisualisation != null) {
                        return DynamicVisualisations.sizeContributions((ReadGraph)graph, (Resource)activeVisualisation);
                    }
                } else {
                    LOGGER.debug("No visualisation folder available for model {}", (Object)model);
                }
            }
            return Collections.emptyMap();
        }
    }
}

