/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.district.imports.CSVImportModel;
import org.simantics.district.imports.DistrictImportUtils;
import org.simantics.district.network.ui.function.Functions;

public class ComponentMappingPage
extends WizardPage {
    private CSVImportModel model;
    private Composite composite;
    private Composite childComposite;
    protected Map<String, Resource> componentMappings;
    private Collection<String> distinctMappingIndexColumnValues;

    public ComponentMappingPage(CSVImportModel model) {
        super("Select component mappings");
        this.model = model;
        this.setMessage("Select component mappings");
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.composite);
        this.setControl((Control)this.composite);
        this.validatePageComplete();
        final IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (container.getCurrentPage().equals((Object)ComponentMappingPage.this)) {
                        ComponentMappingPage.this.updateComponentMappings();
                    }
                }
            });
        }
    }

    private void updateComponentMappings() {
        try {
            int mappingIndex = this.model.getComponentMappingIndex();
            this.distinctMappingIndexColumnValues = DistrictImportUtils.readDistinctValuesOfColumn((Path)this.model.getSource(), (char)this.model.getDelimiter(), (int)mappingIndex);
            try {
                Simantics.getSession().sync((ReadInterface)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        Resource indexRoot = (Resource)graph.sync((ReadInterface)new IndexRoot(ComponentMappingPage.this.model.getParentDiagram()));
                        ComponentMappingPage.this.componentMappings = ComponentMappingPage.this.model.isVertexImport() ? Functions.getVertexMappings((ReadGraph)graph, (Resource)indexRoot) : Functions.getEdgeMappings((ReadGraph)graph, (Resource)indexRoot);
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            System.out.println(this.distinctMappingIndexColumnValues);
            if (this.childComposite != null) {
                this.childComposite.dispose();
            }
            this.childComposite = new Composite(this.composite, 0);
            this.childComposite.setLayout((Layout)new GridLayout(1, false));
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.childComposite);
            for (final String value : this.distinctMappingIndexColumnValues) {
                Composite newCompo = new Composite(this.childComposite, 0);
                newCompo.setLayout((Layout)new GridLayout(2, false));
                GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)newCompo);
                Label t = new Label(newCompo, 0);
                t.setText(value);
                final Combo c = new Combo(newCompo, 8);
                c.setItems(this.componentMappings.keySet().toArray(new String[this.componentMappings.size()]));
                c.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ComponentMappingPage.this.model.setComponentMappings(value, ComponentMappingPage.this.componentMappings.get(c.getItem(c.getSelectionIndex())));
                        ComponentMappingPage.this.validatePageComplete();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
            this.composite.layout(true, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void validatePageComplete() {
        Map currentMappings = this.model.getComponentMappings();
        if (currentMappings != null && this.distinctMappingIndexColumnValues != null && currentMappings.keySet().containsAll(this.distinctMappingIndexColumnValues)) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }
}

