/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Map;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.browsing.ui.swt.DefaultSelectionDataResolver;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.ViewArgumentUtils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.project.ProjectKeys;
import org.simantics.team.internal.Images;
import org.simantics.team.ui.ChangeSetElement;
import org.simantics.team.ui.DisplayElement;
import org.simantics.team.ui.RedoContextElement;
import org.simantics.team.ui.ResourceElement;
import org.simantics.team.ui.StringElement;
import org.simantics.team.ui.UndoCombinedElement;
import org.simantics.team.ui.UndoContentProvider;
import org.simantics.team.ui.UndoContextElement;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.HintTracker;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintTracker;
import org.simantics.utils.ui.LayoutUtils;

public class SynchroniseView
extends ViewPart {
    protected LocalResourceManager resourceManager;
    protected Composite parent;
    protected TreeViewer treeViewer;
    private Map<String, String> args;
    private ISessionContextProvider contextProvider;
    private ISessionContext sessionContext;
    protected IMemento memento;
    private IHintTracker sessionContextTracker = new SessionContextProjectTracker();
    private DisposeState disposeState = DisposeState.Alive;
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            SynchroniseView.this.sessionContext = event.getNewValue();
            SynchroniseView.this.sessionContextTracker.track((IHintContext)SynchroniseView.this.sessionContext);
        }
    };

    protected void setSessionContextTracker(IHintTracker tracker) {
        this.sessionContextTracker = tracker;
    }

    protected Map<String, String> getViewArguments() {
        return this.args;
    }

    protected DisposeState getDisposeState() {
        return this.disposeState;
    }

    public ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ISessionContextProvider getSessionContextProvider() {
        return this.contextProvider;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.treeViewer = new TreeViewer(parent, 65540);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)this.treeViewer.getTree());
        Images.getInstance(JFaceResources.getResources());
        TreeColumnLayout ad = new TreeColumnLayout();
        parent.setLayout((Layout)ad);
        this.treeViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        TreeViewerColumn typeColumn = new TreeViewerColumn(this.treeViewer, 16384);
        nameColumn.setLabelProvider((CellLabelProvider)new MyColumnLabelProvider());
        typeColumn.setLabelProvider((CellLabelProvider)new MyColumnLabelProvider());
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 100));
        typeColumn.getColumn().setText("Type");
        typeColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)typeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 120));
        this.createControls(parent);
        this.attachToSession();
    }

    public void dispose() {
        this.disposeState = DisposeState.Disposing;
        try {
            if (this.contextProvider != null) {
                this.contextProvider.removeContextChangedListener(this.contextChangeListener);
                this.contextProvider = null;
            }
            this.sessionContextTracker.untrack();
            this.resourceManager.dispose();
            this.resourceManager = null;
            this.args = null;
            this.sessionContext = null;
            this.parent = null;
            super.dispose();
        }
        finally {
            this.disposeState = DisposeState.Disposed;
        }
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.args = ViewArgumentUtils.parseViewArguments((IViewPart)this);
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    protected final void attachToSession() {
        this.contextProvider = SimanticsUI.getSessionContextProvider((Object)this.getViewSite().getWorkbenchWindow());
        this.contextProvider.addContextChangedListener(this.contextChangeListener);
        this.applySessionContext(this.contextProvider.getSessionContext());
    }

    protected void createControls(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1, (boolean)false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.treeViewer.getTree());
        this.treeViewer.setContentProvider((IContentProvider)new UndoContentProvider(Simantics.getSession()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof ChangeSetElement) {
                    return Images.getInstance().CHANGE_SET_IMAGE;
                }
                if (element instanceof DisplayElement) {
                    return Images.getInstance().DISPLAY_IMAGE;
                }
                if (element instanceof ResourceElement) {
                    return Images.getInstance().RESOURCE_IMAGE;
                }
                if (element instanceof StringElement) {
                    return Images.getInstance().STRING_IMAGE;
                }
                if (element instanceof UndoCombinedElement) {
                    return Images.getInstance().COMBINED_IMAGE;
                }
                if (element instanceof RedoContextElement) {
                    return Images.getInstance().REDO_IMAGE;
                }
                if (element instanceof UndoContextElement) {
                    return Images.getInstance().UNDO_IMAGE;
                }
                return Images.getInstance().OTHER_IMAGE;
            }

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.treeViewer.setInput((Object)this);
        Control control = this.treeViewer.getControl();
        this.createContextMenu(control, (IWorkbenchSite)this.getSite());
    }

    public IMenuManager createContextMenu(Control control, IWorkbenchSite site) {
        final MenuManager mm = new MenuManager("#TeamViewPopup", "#TeamViewPopup");
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                mm.add((IContributionItem)new GroupMarker("wbStart"));
            }
        });
        Menu menu = mm.createContextMenu(control);
        control.setMenu(menu);
        if (site != null) {
            if (site instanceof IWorkbenchPartSite) {
                ((IWorkbenchPartSite)site).registerContextMenu(mm.getId(), mm, site.getSelectionProvider());
            } else if (site instanceof IPageSite) {
                ((IPageSite)site).registerContextMenu(mm.getId(), mm, site.getSelectionProvider());
            }
        }
        return mm;
    }

    protected GraphExplorer createExplorerControl(Composite parent) {
        return GraphExplorerFactory.getInstance().selectionDataResolver((SelectionDataResolver)new DefaultSelectionDataResolver()).create(parent);
    }

    protected final boolean applySessionContext(ISessionContext context) {
        if (this.disposeState != DisposeState.Alive) {
            return false;
        }
        this.sessionContext = context;
        this.sessionContextTracker.track((IHintContext)this.sessionContext);
        return true;
    }

    class MyColumnLabelProvider
    extends ColumnLabelProvider {
        MyColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText("Kraa");
            cell.setImage(Images.getInstance().OTHER_IMAGE);
        }
    }

    public class SessionContextProjectTracker
    extends HintTracker {
        public SessionContextProjectTracker() {
            HintListenerAdapter activeProjectListener = new HintListenerAdapter(){

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    SynchroniseView.this.applySessionContext(SynchroniseView.this.getSessionContext());
                }
            };
            this.addKeyHintListener(ProjectKeys.KEY_PROJECT, (IHintListener)activeProjectListener);
        }
    }
}

