/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.CommitMetadata;
import org.simantics.db.common.UndoMetadata;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.team.internal.Images;
import org.simantics.team.ui.ChangeSetDisplayElement;
import org.simantics.team.ui.Command;
import org.simantics.team.ui.CommentStringElement;
import org.simantics.team.ui.DisplayElement;
import org.simantics.team.ui.StringElement;
import org.simantics.team.ui.TreeElement;

class ChangeSetElement
extends TreeElement
implements Command {
    private boolean DEBUG = false;
    private ChangeSetIdentifier cs;
    private Map<String, byte[]> metadata = null;
    private Session session;

    ChangeSetElement(Session session, long csid) {
        this.session = session;
        this.cs = this.getChangeSetIdentifier(csid);
    }

    ChangeSetElement(Session session, ChangeSetIdentifier cs) {
        this.cs = cs;
        this.session = session;
    }

    static <T> T getMetadata(Session session, Map<String, byte[]> data, Class<? extends Metadata> dataClass) {
        if (session == null || data == null || dataClass == null) {
            return null;
        }
        Object result = null;
        try {
            Method m = dataClass.getMethod("deserialise", Session.class, byte[].class);
            byte[] bytes = data.get(dataClass.getName());
            if (bytes != null) {
                Object value;
                result = value = m.invoke(null, session, bytes);
            }
        }
        catch (RuntimeException e) {
            Logger.defaultLogError((Throwable)e);
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
        return (T)result;
    }

    @Override
    public void dumpToSelectedRevision() throws DatabaseException {
        if (this.cs == null) {
            return;
        }
        ManagementSupport ms = (ManagementSupport)this.session.getService(ManagementSupport.class);
        long csid = this.cs.getId();
        ms.dumpRevision(csid);
        if (this.DEBUG) {
            System.out.println("DEBUG: Dumped change set=" + csid + ".");
        }
    }

    @Override
    public void undoToSelectedRevision() throws DatabaseException {
        if (this.cs == null) {
            return;
        }
        UndoRedoSupport us = (UndoRedoSupport)this.session.getService(UndoRedoSupport.class);
        int n = us.undoTo(this.session, this.cs.getId());
        if (this.DEBUG) {
            System.out.println("DEBUG: Reverted " + n + " change sets.");
        }
    }

    @Override
    public void initUndoListFromSelectedRevision() throws DatabaseException {
        if (this.cs == null) {
            return;
        }
        UndoRedoSupport us = (UndoRedoSupport)this.session.getService(UndoRedoSupport.class);
        int n = us.initUndoListFrom(this.session, this.cs.getId());
        if (this.DEBUG) {
            System.out.println("DEBUG: Undo list initialised with " + n + " change sets.");
        }
    }

    @Override
    public ChangeSetIdentifier getChangeSetIdentifier() {
        return this.cs;
    }

    private ChangeSetIdentifier getChangeSetIdentifier(long id) {
        Collection cids;
        ManagementSupport ms = (ManagementSupport)this.session.getService(ManagementSupport.class);
        try {
            cids = ms.getChangeSetIdentifiers(id, id);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
        for (ChangeSetIdentifier cid : cids) {
            if (cid.getId() != id) continue;
            return cid;
        }
        return null;
    }

    private void getMetadata() {
        if (this.metadata != null) {
            return;
        }
        if (this.cs == null) {
            this.metadata = new HashMap<String, byte[]>();
            return;
        }
        try {
            ChangeSetIdentifier csid;
            this.metadata = this.cs.getMetadata();
            if (this.metadata == null && (csid = this.getChangeSetIdentifier(this.cs.getId())) != null) {
                this.metadata = csid.getMetadata();
            }
        }
        catch (Exception e) {
            Logger.defaultLogError((Throwable)e);
        }
        if (this.metadata == null) {
            this.metadata = new HashMap<String, byte[]>();
        }
    }

    public String toString() {
        if (this.cs == null) {
            return "<no change set>";
        }
        return "change set " + this.cs.getId();
    }

    @Override
    boolean hasChildren() {
        if (this.metadata == null) {
            this.getMetadata();
        }
        return this.cs != null || !this.metadata.isEmpty();
    }

    @Override
    Object[] getChildren() {
        if (this.metadata == null) {
            this.getMetadata();
        }
        if (this.cs == null && this.metadata.isEmpty()) {
            return new Object[0];
        }
        ArrayList<TreeElement> objects = new ArrayList<TreeElement>();
        if (!this.metadata.isEmpty()) {
            UndoMetadata undoMetadata;
            CommentMetadata commentMetadata;
            objects.add(new CommentStringElement("Metaclass", "Count is " + this.metadata.size() + "."));
            CommitMetadata commitMetadata = (CommitMetadata)ChangeSetElement.getMetadata(this.session, this.metadata, CommitMetadata.class);
            if (commitMetadata != null && commitMetadata.opid != 0L && commitMetadata.opid != this.cs.getId()) {
                objects.add(new StringElement("Part of operation", "" + commitMetadata.opid));
            }
            if ((commentMetadata = (CommentMetadata)ChangeSetElement.getMetadata(this.session, this.metadata, CommentMetadata.class)) != null) {
                objects.add(new DisplayElement("Comment", commentMetadata.toString()));
            }
            if ((undoMetadata = (UndoMetadata)ChangeSetElement.getMetadata(this.session, this.metadata, UndoMetadata.class)) != null) {
                String header = undoMetadata.getHeader();
                objects.add(new DisplayElement(header, undoMetadata.toString()));
            }
        }
        if (this.cs.getId() > 0L) {
            objects.add(new ChangeSetDisplayElement("Change Set", this.session, this.cs.getId()));
        }
        return objects.toArray();
    }

    @Override
    Image getIdImage() {
        return Images.getInstance().CHANGE_SET_IMAGE;
    }

    @Override
    String getIdText() {
        if (this.cs != null) {
            return "" + this.cs.getId();
        }
        return "<no id>";
    }

    @Override
    String getDateText() {
        if (this.metadata == null) {
            this.getMetadata();
        }
        if (this.cs == null || this.metadata.isEmpty()) {
            return "<no date>";
        }
        CommitMetadata commitMetadata = (CommitMetadata)ChangeSetElement.getMetadata(this.session, this.metadata, CommitMetadata.class);
        if (commitMetadata != null) {
            return commitMetadata.date.toString();
        }
        return "<no date>";
    }

    @Override
    String getCommentText() {
        if (this.metadata == null) {
            this.getMetadata();
        }
        if (this.cs == null || this.metadata.isEmpty()) {
            return "<no comment>";
        }
        CommentMetadata commentMetadata = (CommentMetadata)ChangeSetElement.getMetadata(this.session, this.metadata, CommentMetadata.class);
        if (commentMetadata != null) {
            UndoMetadata undoMetadata = (UndoMetadata)ChangeSetElement.getMetadata(this.session, this.metadata, UndoMetadata.class);
            String t = commentMetadata.toString();
            if (undoMetadata == null) {
                return t;
            }
            return undoMetadata.getHeader() + ": " + t;
        }
        return "<no comment>";
    }
}

