/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Collection;
import org.simantics.db.ChangeSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.ManagementSupport;
import org.simantics.team.ui.DisplayElement;

class ChangeSetDisplayElement
extends DisplayElement {
    private final Session session;
    private final long csid;
    private String lazyValue;

    ChangeSetDisplayElement(String name, Session session, long csid) {
        super(name, "");
        this.session = session;
        this.csid = csid;
    }

    @Override
    public String toString() {
        return this.name + "=" + this.getValue();
    }

    @Override
    String getValue() {
        if (this.lazyValue == null) {
            this.lazyValue = this.fetchChangeSet();
        }
        return this.lazyValue;
    }

    private String fetchChangeSet() {
        Collection css;
        block3: {
            try {
                css = (Collection)this.session.sync((ReadInterface)new UniqueRead<Collection<ChangeSet>>(){

                    public Collection<ChangeSet> perform(ReadGraph graph) throws DatabaseException {
                        ManagementSupport ms = (ManagementSupport)graph.getService(ManagementSupport.class);
                        return ms.fetchChangeSets(graph, ChangeSetDisplayElement.this.csid, ChangeSetDisplayElement.this.csid);
                    }
                });
                if (css.size() == 1) break block3;
                return "<no change set (1)>";
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
                return "<no change set (2)>";
            }
        }
        return ((ChangeSet)css.iterator().next()).toString();
    }
}

