/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.team.Utils;
import org.simantics.team.internal.StagingException;
import org.simantics.utils.FileUtils;
import org.simantics.utils.strings.EString;

public final class StagingLauncher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_EXEC = true;
    private static final boolean REMOTE_DEBUG_DISABLED = true;
    private static Set<String> startUpBundles = new HashSet<String>();
    private static Set<String> startedBundles;

    static {
        startUpBundles.add("org.eclipse.equinox.simpleconfigurator");
        startedBundles = new HashSet<String>();
        startedBundles.add("org.eclipse.core.runtime");
    }

    public static StagingResult launch(Config stagingConfig, String serverAddress, String targetResourceId) throws InvalidSyntaxException, IllegalArgumentException, FrameworkAdminRuntimeException, IOException, BindingConstructionException, DatabaseException {
        Bundle faBundle = FrameworkUtil.getBundle(FrameworkAdmin.class);
        if (faBundle == null) {
            throw new StagingException("Bundle for FrameworkAdmin not available.");
        }
        BundleContext faContext = faBundle.getBundleContext();
        if (faContext == null) {
            throw new StagingException("Context for FrameworkAdmin not available.");
        }
        ServiceReference ref = faContext.getServiceReference(FrameworkAdmin.class);
        if (ref == null) {
            throw new StagingException("Reference for FrameworkAdmin not available.");
        }
        FrameworkAdmin admin = (FrameworkAdmin)faContext.getService(ref);
        if (admin == null) {
            throw new StagingException("FrameworkAdmin not available.");
        }
        try {
            String errs;
            Manipulator rmanip = admin.getRunningManipulator();
            if (rmanip == null) {
                throw new StagingException("No FrameworkAdmin Manipulator available for the currently running environment.");
            }
            System.out.println("FrameworkAdmin Manipulator of the running environment:\n" + String.valueOf(rmanip));
            Properties system = System.getProperties();
            ConfigData rcd = rmanip.getConfigData();
            LauncherData rld = rmanip.getLauncherData();
            Manipulator manip = admin.getManipulator();
            manip.setConfigData(rcd);
            manip.setLauncherData(rld);
            ConfigData cd = manip.getConfigData();
            LauncherData ld = manip.getLauncherData();
            Properties config = new Properties();
            StringBuilder osgiBundles = new StringBuilder(1024);
            StringBuilder bundlesInfo = new StringBuilder(1024);
            bundlesInfo.append("#version=1\n");
            BundleInfo[] bundleInfoArray = cd.getBundles();
            int n = bundleInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleInfo bi = bundleInfoArray[n2];
                boolean started = StagingLauncher.isMarkedAsStarted(bi);
                bundlesInfo.append(bi.getSymbolicName()).append(",").append(bi.getVersion()).append(",").append(URLDecoder.decode(bi.getLocation().toString(), "UTF-8")).append(",").append(bi.getStartLevel()).append(",").append(started).append("\n");
                System.out.println("bundle: " + bi.getSymbolicName() + "\n\t" + bi.getLocation().toString() + "\n\t" + started);
                if (started) {
                    System.out.println("IS STARTED: bundle: " + bi.getSymbolicName() + "\n\t" + bi.getLocation().toString());
                }
                if (!started && bi.isMarkedAsStarted()) {
                    System.out.println("NOT STARTED, BUT WAS MARKED AS STARTED: bundle: " + bi.getSymbolicName() + "\n\t" + bi.getLocation().toString());
                }
                if (StagingLauncher.isStartUpBundle(bi)) {
                    if (osgiBundles.length() > 0) {
                        osgiBundles.append(",");
                    }
                    osgiBundles.append("reference:").append(URLDecoder.decode(bi.getLocation().toString(), "UTF-8")).append("@").append(bi.getStartLevel()).append(":start");
                }
                ++n2;
            }
            File javaHome = new File(system.getProperty("java.home"));
            String installArea = system.getProperty("osgi.install.area");
            config.setProperty("eclipse.application", "org.simantics.workbench.application");
            config.setProperty("eclipse.product", "org.simantics.devs3.ui.product");
            config.setProperty("org.eclipse.update.reconcile", "false");
            config.setProperty("osgi.bundles", osgiBundles.toString());
            config.setProperty("osgi.bundles.defaultStartLevel", "4");
            config.setProperty("osgi.configuration.cascaded", "false");
            config.setProperty("osgi.framework", URLDecoder.decode(ld.getFwJar().toURI().toString(), "UTF-8"));
            config.setProperty("osgi.install.area", installArea);
            config.setProperty("osgi.instance.area", stagingConfig.workspaceRoot.getAbsolutePath());
            config.setProperty("osgi.user.area", "@none");
            config.setProperty("equinox.use.ds", "true");
            config.setProperty("eclipse.log.level", "WARNING");
            File configDir = new File(stagingConfig.workspaceRoot, "configuration");
            File simpleConfiguratorDir = new File(configDir, "org.eclipse.equinox.simpleconfigurator");
            simpleConfiguratorDir.mkdirs();
            File bundlesInfoFile = new File(simpleConfiguratorDir, "bundles.info");
            config.setProperty("org.eclipse.equinox.simpleconfigurator.configUrl", URLDecoder.decode(bundlesInfoFile.toURI().toString(), "UTF-8"));
            File logFile = new File(stagingConfig.workspaceRoot, "db-client.log");
            StagingLauncher.writeProperties(config, new File(configDir, "config.ini"), "This configuration file was written by: " + StagingLauncher.class.getCanonicalName());
            StagingLauncher.writeFile(bundlesInfo.toString(), bundlesInfoFile);
            ld.setJvm(new File(new File(javaHome, "bin"), "java"));
            ld.setFwConfigLocation(configDir);
            ld.setFwPersistentDataLocation(configDir, false);
            ld.setLauncher(null);
            int maxHeap = 768;
            ld.addJvmArg("-Xmx" + maxHeap + "m");
            ld.addJvmArg("-Xms" + maxHeap + "m");
            ld.addJvmArg("-ea");
            if (Platform.inDevelopmentMode()) {
                ld.addJvmArg("-Dosgi.dev=" + system.getProperty("osgi.dev"));
            }
            ld.addJvmArg("-Dosgi.arch=" + rcd.getProperty("osgi.arch"));
            ld.addJvmArg("-Dosgi.os=" + rcd.getProperty("osgi.os"));
            ld.addJvmArg("-Dosgi.ws=" + rcd.getProperty("osgi.ws"));
            ld.addJvmArg("-Dosgi.nl=" + rcd.getProperty("osgi.nl"));
            ld.addJvmArg("-Dosgi.compatibility.bootdelegation=true");
            if (Platform.inDevelopmentMode()) {
                // empty if block
            }
            ld.addJvmArg("-Ddump.properties");
            ld.addJvmArg("-Dstaging.logfile=" + logFile.toURI().toString());
            Object titleArgument = System.getProperty("staging.window.title");
            titleArgument = titleArgument != null && !((String)titleArgument).equals("") ? stagingConfig.titlePrefix + " " + (String)titleArgument : stagingConfig.titlePrefix;
            ld.addJvmArg("-Dstaging.window.title=" + (String)titleArgument);
            if (stagingConfig.teamFolder != null) {
                ld.addJvmArg("-Dstaging.team.folder=" + stagingConfig.teamFolder.getAbsolutePath());
            }
            ld.addJvmArg("-Dimport.workspace.root=" + stagingConfig.workspaceRoot.toURI().toString());
            System.out.println("JVM ARGS: " + Arrays.toString(ld.getJvmArgs()));
            if (stagingConfig.clusterMapFolder != null) {
                String file = "clusterIdMap.dat";
                File f = new File(stagingConfig.clusterMapFolder, file);
                File tFolder = new File(stagingConfig.workspaceRoot, ".metadata/.plugins/org.simantics.db.procore");
                tFolder.mkdirs();
                FileUtils.copyFile((File)f, (File)new File(tFolder, file));
                String file2 = "nextId.dat";
                File f2 = new File(stagingConfig.clusterMapFolder, file2);
                File tFolder2 = new File(stagingConfig.workspaceRoot, "db");
                FileUtils.copyFile((File)f2, (File)new File(tFolder2, file2));
            }
            System.out.println("LAUNCHING\n" + String.valueOf(manip));
            LauncherData launcherData = ld;
            System.out.println("Framework JAR: " + ld.getFwJar().toURI().toString());
            org.eclipse.equinox.internal.frameworkadmin.utils.Utils.checkAbsoluteFile((File)launcherData.getFwJar(), (String)"fwJar");
            File cwd = stagingConfig.workspaceRoot;
            org.eclipse.equinox.internal.frameworkadmin.utils.Utils.checkAbsoluteDir((File)cwd, (String)"cwd");
            LinkedList<Object> cmdList = new LinkedList<Object>();
            if (launcherData.getJvm() != null) {
                cmdList.add(launcherData.getJvm().getAbsolutePath());
            } else {
                cmdList.add("java");
            }
            if (launcherData.getJvmArgs() != null) {
                int i = 0;
                while (i < launcherData.getJvmArgs().length) {
                    cmdList.add(launcherData.getJvmArgs()[i]);
                    ++i;
                }
            }
            cmdList.add("-jar");
            cmdList.add("\"" + launcherData.getFwJar().getAbsolutePath() + "\"");
            cmdList.add("-configuration");
            cmdList.add("\"" + launcherData.getFwPersistentDataLocation().getAbsolutePath() + "\"");
            cmdList.add("-data");
            cmdList.add(stagingConfig.workspaceRoot.getAbsolutePath());
            if (launcherData.isClean()) {
                cmdList.add("-clean");
            }
            Object[] cmdarray = cmdList.toArray(new String[cmdList.size()]);
            System.out.println("Launching import, CWD=" + String.valueOf(cwd) + "\n\t" + EString.implode((Object[])cmdarray, (String)"\n\t"));
            Process process = Runtime.getRuntime().exec((String[])cmdarray, null, cwd);
            long startTime = System.nanoTime();
            int exitValue = Integer.MIN_VALUE;
            InputStream is = process.getInputStream();
            InputStream es = process.getErrorStream();
            while (true) {
                try {
                    long endTime = System.nanoTime();
                    exitValue = process.exitValue();
                    System.out.println("finished in " + (double)(endTime - startTime) * 1.0E-6 + "ms");
                    System.out.println("exit value: " + exitValue);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        byte[] bytes;
                        int nr;
                        int n3 = is.available();
                        if (n3 > 0 && (nr = is.read(bytes = new byte[n3])) > 0) {
                            System.out.println("DEBUG: STDOUT:" + Utils.bytesToStringASCII(bytes, 0, nr));
                        }
                        if ((n3 = es.available()) > 0 && (nr = es.read(bytes = new byte[n3])) > 0) {
                            System.out.println("DEBUG: STDERR:" + Utils.bytesToStringASCII(bytes, 0, nr));
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            String ins = FileUtils.getContents((InputStream)is);
            if (!ins.isEmpty()) {
                System.out.println("--- STDOUT ---\n" + ins);
            }
            if (!(errs = FileUtils.getContents((InputStream)es)).isEmpty()) {
                System.out.println("--- STDERR ---\n" + errs);
            }
            StagingResult stagingResult = new StagingResult(exitValue, logFile, null);
            return stagingResult;
        }
        finally {
            faContext.ungetService(ref);
        }
    }

    private static boolean isStartUpBundle(BundleInfo bi) {
        return startUpBundles.contains(bi.getSymbolicName());
    }

    private static boolean isMarkedAsStarted(BundleInfo bi) {
        return bi.isMarkedAsStarted() && (bi.getStartLevel() < 4 || startedBundles.contains(bi.getSymbolicName()));
    }

    private static void writeProperties(Properties properties, File target, String comment) throws IOException {
        try (FileWriter writer = new FileWriter(target);){
            properties.store(writer, comment);
        }
    }

    private static void writeFile(String string, File target) throws IOException {
        try (FileWriter writer = new FileWriter(target);){
            writer.write(string);
        }
    }

    public static final class Config {
        public final Session session;
        public final Resource targetLibrary;
        public final File workspaceRoot;
        public final File clusterMapFolder;
        public final File teamFolder;
        public final PrintStream out;
        public Resource createdModel;
        public Resource createdState;
        public List<String> messages = new ArrayList<String>();
        public String titlePrefix = "Staging";

        public Config(Session session, Resource library, File workspaceRoot, File clusterMapFolder) throws DatabaseException {
            this(session, library, workspaceRoot, clusterMapFolder, null);
        }

        public Config(Session session, Resource library, File workspaceRoot, File clusterMapFolder, PrintStream out) throws DatabaseException {
            this.session = session;
            this.targetLibrary = library;
            this.workspaceRoot = workspaceRoot;
            this.clusterMapFolder = clusterMapFolder;
            this.teamFolder = Utils.getTeamFolder();
            this.out = out;
        }
    }

    static final class Constants {
        public static final String PROP_DUMP_PROPERTIES = "dump.properties";
        public static final String PROP_LOGFILE = "staging.logfile";
        public static final String PROP_WINDOW_TITLE = "staging.window.title";
        public static final String PROP_TEAM_FOLDER = "staging.team.folder";
        public static final String PROP_WORKSPACE_ROOT = "import.workspace.root";

        Constants() {
        }
    }

    public static final class StagingResult {
        private final int exitValue;
        private final File logFile;
        private final String messageLog;

        public StagingResult(String message) {
            this.exitValue = Integer.MIN_VALUE;
            this.logFile = null;
            this.messageLog = message;
        }

        public StagingResult(int exitValue, File logFile, String messageLog) {
            this.exitValue = exitValue;
            this.logFile = logFile;
            this.messageLog = messageLog;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public File getLogFile() {
            return this.logFile;
        }

        public String getMessageLog() {
            return this.messageLog;
        }
    }
}

