# Basic functions

::value[toJsonString, fromJsonString]

# Supported value types

This module supports the following value types:

```
instance Json String
instance Json Short
instance Json Integer
instance Json Long
instance Json Float
instance Json Double

instance (Json a) => Json [a]
instance (Json a) => Json (Maybe a)

instance Json ()
instance (Json a, Json b) => Json (a, b)
instance (Json a, Json b, Json c) => Json (a, b, c)
instance (Json a, Json b, Json c, Json d) => Json (a, b, c, d)
instance (Json a, Json b, Json c, Json d, Json e) => Json (a, b, c, d, e) 

instance Json Json
```

# Generic JSON Type

::data[Json, JsonField]

# Adding support for additional value types

::data[JsonGenerator, JsonParser]
::class[Json]

It is enough to implement `toJson` and `fromJson`.

# Undocumented entities

::undocumented[]