package org.simantics.layer0;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class PredicateResource {
    
    public final Resource AppliesFirst;
    public final Resource AppliesThen;
    public final Resource BinaryPredicate;
    public final Resource CompositePredicate;
    public final Resource Conjunction;
    public final Resource Disjunction;
    public final Resource HasBinaryPredicate;
    public final Resource HasPredicate;
    public final Resource IntersectionPredicate;
    public final Resource InversePredicate;
    public final Resource Negation;
    public final Resource OrderedSetElements;
    public final Resource Predicate;
    public final Resource TransitiveClosure;
    public final Resource UnionPredicate;
        
    public static class URIs {
        public static final String AppliesFirst = "http://www.simantics.org/Layer0X-1.1/Predicate/AppliesFirst";
        public static final String AppliesThen = "http://www.simantics.org/Layer0X-1.1/Predicate/AppliesThen";
        public static final String BinaryPredicate = "http://www.simantics.org/Layer0X-1.1/Predicate/BinaryPredicate";
        public static final String CompositePredicate = "http://www.simantics.org/Layer0X-1.1/Predicate/CompositePredicate";
        public static final String Conjunction = "http://www.simantics.org/Layer0X-1.1/Predicate/Conjunction";
        public static final String Disjunction = "http://www.simantics.org/Layer0X-1.1/Predicate/Disjunction";
        public static final String HasBinaryPredicate = "http://www.simantics.org/Layer0X-1.1/Predicate/HasBinaryPredicate";
        public static final String HasPredicate = "http://www.simantics.org/Layer0X-1.1/Predicate/HasPredicate";
        public static final String IntersectionPredicate = "http://www.simantics.org/Layer0X-1.1/Predicate/IntersectionPredicate";
        public static final String InversePredicate = "http://www.simantics.org/Layer0X-1.1/Predicate/InversePredicate";
        public static final String Negation = "http://www.simantics.org/Layer0X-1.1/Predicate/Negation";
        public static final String OrderedSetElements = "http://www.simantics.org/Layer0X-1.1/Predicate/OrderedSetElements";
        public static final String Predicate = "http://www.simantics.org/Layer0X-1.1/Predicate/Predicate";
        public static final String TransitiveClosure = "http://www.simantics.org/Layer0X-1.1/Predicate/TransitiveClosure";
        public static final String UnionPredicate = "http://www.simantics.org/Layer0X-1.1/Predicate/UnionPredicate";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public PredicateResource(ReadGraph graph) {
        AppliesFirst = getResourceOrNull(graph, URIs.AppliesFirst);
        AppliesThen = getResourceOrNull(graph, URIs.AppliesThen);
        BinaryPredicate = getResourceOrNull(graph, URIs.BinaryPredicate);
        CompositePredicate = getResourceOrNull(graph, URIs.CompositePredicate);
        Conjunction = getResourceOrNull(graph, URIs.Conjunction);
        Disjunction = getResourceOrNull(graph, URIs.Disjunction);
        HasBinaryPredicate = getResourceOrNull(graph, URIs.HasBinaryPredicate);
        HasPredicate = getResourceOrNull(graph, URIs.HasPredicate);
        IntersectionPredicate = getResourceOrNull(graph, URIs.IntersectionPredicate);
        InversePredicate = getResourceOrNull(graph, URIs.InversePredicate);
        Negation = getResourceOrNull(graph, URIs.Negation);
        OrderedSetElements = getResourceOrNull(graph, URIs.OrderedSetElements);
        Predicate = getResourceOrNull(graph, URIs.Predicate);
        TransitiveClosure = getResourceOrNull(graph, URIs.TransitiveClosure);
        UnionPredicate = getResourceOrNull(graph, URIs.UnionPredicate);
    }
    
    public static PredicateResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        PredicateResource ret = session.peekService(PredicateResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new PredicateResource(qc.getIndependentGraph(graph));
            session.registerService(PredicateResource.class, ret);
        }
        return ret;
    }
    
    public static PredicateResource getInstance(RequestProcessor session) throws DatabaseException {
        PredicateResource ret = session.peekService(PredicateResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<PredicateResource>() {
                public PredicateResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new PredicateResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(PredicateResource.class, ret);
        }
        return ret;
    }
    
}

