/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - further development
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncContextProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procedure.SyncProcedure;

public interface DirectQuerySupport {

    DirectStatements getDirectPersistentStatements(ReadGraph graph, Resource subject);
    DirectStatements getDirectStatements(ReadGraph graph, Resource subject);

    RelationInfo getRelationInfo(ReadGraph graph, Resource subject) throws DatabaseException;

    SyncMultiProcedure<Resource> compileForEachObject(ReadGraph graph, Resource relation, SyncMultiProcedure<Resource> user) throws DatabaseException;
    <C> SyncContextMultiProcedure<C, Resource> compileForEachObject(ReadGraph graph, Resource relation, SyncContextMultiProcedure<C, Resource> user) throws DatabaseException;
    <T> SyncProcedure<T> compilePossibleRelatedValue(ReadGraph graph, Resource relation, SyncProcedure<T> user) throws DatabaseException;
    <C,T> SyncContextProcedure<C,T> compilePossibleRelatedValue(ReadGraph graph, Resource relation, SyncContextProcedure<C,T> user) throws DatabaseException;

    void forEachObjectCompiled(ReadGraph graph, Resource subject, SyncMultiProcedure<Resource> procedure);
    <C> void forEachObjectCompiled(ReadGraph graph, Resource subject, C context, SyncContextMultiProcedure<C, Resource> procedure);
    <T> void forPossibleRelatedValueCompiled(ReadGraph graph, Resource subject, SyncProcedure<T> procedure);
    <C,T> void forPossibleRelatedValueCompiled(ReadGraph graph, Resource subject, C context, SyncContextProcedure<C,T> procedure);
    <C> void forPossibleRelatedValueBytesCompiled(ReadGraph graph, Resource subject, C context, SyncContextProcedure<C,byte[]> procedure);
    <C> void forPossibleDirectType(ReadGraph graph, Resource subject, C context, SyncContextProcedure<C,Resource> procedure);

}
