/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.event;

import org.simantics.db.Session;
import org.simantics.db.SessionManager;

/**
 * An event object concerning Sessions of a SessionManager.
 * 
 * @author Tuukka Lehtonen
 * @see Session
 * @see SessionListener
 * @see SessionManager
 */
public class SessionEvent {

    private final Session session;
    private final Throwable cause;
    
    public SessionEvent(Session session, Throwable cause) {
        this.session = session;
        this.cause = cause;
    }

    public Session getSession() {
        return session;
    }

    public Throwable getCause() {
    	return cause;
    }
}
