/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.event;

import org.simantics.db.ChangeSet;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.service.TeamSupport;

/**
 * An event structure for {@link ChangeListener}.
 * 
 * Informs of incoming changes in a Session, i.e. a completed transaction or an
 * update external to this Session caused by a synchronize operation using
 * {@link TeamSupport}.
 * 
 * @author Tuukka Lehtonen
 * @see ChangeListener
 * @see Session
 */
public class ChangeEvent {

    private final Session   session;

    private final ReadGraph graph;
    
    private final WriteGraph metadataGraph;

    private final ChangeSet changes;

    public ChangeEvent(Session session, ReadGraph graph, WriteGraph metadataGraph, ChangeSet changeSet) {
        this.session = session;
        this.graph = graph;
        this.metadataGraph = metadataGraph;
        this.changes = changeSet;
    }

    public Session getSession() {
        return session;
    }

    public ReadGraph getGraph() {
        return graph;
    }

    public ChangeSet getChanges() {
        return changes;
    }
    
    public MetadataI getMetadataI() {
    	return metadataGraph;
    }
    
    @Override
    public String toString() {
        return new StringBuilder()
                .append(getClass().getSimpleName()).append(" ")
                .append(changes).append(" ")
                .append(graph).append(" ")
                .append(metadataGraph).append(" ")
                .append(session).toString();
    }
}
