/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.exception.DatabaseException;

public interface ServerI {

	/**
	 * Start the server.
	 *
	 * @throws DatabaseException
	 */
    void start() throws DatabaseException;

    /**
     * Ask server to stop. Server has no obligation to stop.
     * After this server is either running or not.
     * You can not and should not make any assumptions on server behavior.
     * Remember that server lifetime is not under our control.
     *
     * @throws DatabaseException if server did not receive our plead or had trouble responding.
     */
    void stop() throws DatabaseException;

    /**
     * Verify if the server is in active and usable state.
     *
     * @return true if the server is alive and responsive.
     */
    boolean isActive()  throws DatabaseException;

    /**
     * Get the server address. Can be used with {@link Driver#getSession()} and {@link Driver#getServer()} methods.
     *
     * @return address of the server as canonical string.
     */
    public String getAddress() throws DatabaseException;

//    /**
//     * @return
//     * @throws DatabaseException
//     * @deprecated Was used for getting server address.
//     * Changed to string to remove dependency to ServerAddress structure.
//     * Use Use the {@link #getAddress()} method instead.
//     */
//    public ServerAddress getServerAddress() throws DatabaseException;

    /**
     * Execute server command.
     *
     * @return command output.
     */

    public String execute(String command) throws DatabaseException;

    /**
     * Execute server command and disconnect after command has been executed.
     *
     * @return command output.
     */
    public String executeAndDisconnect(String command) throws DatabaseException;
}
